/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ActiveContractsServiceOuterClass;
import com.daml.ledger.javaapi.data.TransactionFilter;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GetActiveContractsRequest {
    private final String ledgerId;
    private final TransactionFilter transactionFilter;
    private final boolean verbose;

    public GetActiveContractsRequest(@NonNull String ledgerId, @NonNull TransactionFilter transactionFilter, @NonNull boolean verbose) {
        this.ledgerId = ledgerId;
        this.transactionFilter = transactionFilter;
        this.verbose = verbose;
    }

    public static GetActiveContractsRequest fromProto(ActiveContractsServiceOuterClass.GetActiveContractsRequest request) {
        String ledgerId = request.getLedgerId();
        TransactionFilter filters = TransactionFilter.fromProto(request.getFilter());
        boolean verbose = request.getVerbose();
        return new GetActiveContractsRequest(ledgerId, filters, verbose);
    }

    public ActiveContractsServiceOuterClass.GetActiveContractsRequest toProto() {
        return ActiveContractsServiceOuterClass.GetActiveContractsRequest.newBuilder().setLedgerId(this.ledgerId).setFilter(this.transactionFilter.toProto()).setVerbose(this.verbose).build();
    }

    public @NonNull String getLedgerId() {
        return this.ledgerId;
    }

    public @NonNull TransactionFilter getTransactionFilter() {
        return this.transactionFilter;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetActiveContractsRequest that = (GetActiveContractsRequest)o;
        return this.verbose == that.verbose && Objects.equals(this.ledgerId, that.ledgerId) && Objects.equals(this.transactionFilter, that.transactionFilter);
    }

    public int hashCode() {
        return Objects.hash(this.ledgerId, this.transactionFilter, this.verbose);
    }

    public String toString() {
        return "GetActiveContractsRequest{ledgerId='" + this.ledgerId + '\'' + ", transactionFilter=" + this.transactionFilter + ", verbose=" + this.verbose + '}';
    }
}

