/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandsOuterClass;
import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExerciseByKeyCommand
extends Command {
    private final Identifier templateId;
    private final Value contractKey;
    private final String choice;
    private final Value choiceArgument;

    public ExerciseByKeyCommand(@NonNull Identifier templateId, @NonNull Value contractKey, @NonNull String choice, @NonNull Value choiceArgument) {
        this.templateId = templateId;
        this.contractKey = contractKey;
        this.choice = choice;
        this.choiceArgument = choiceArgument;
    }

    public static ExerciseByKeyCommand fromProto(CommandsOuterClass.ExerciseByKeyCommand command) {
        Identifier templateId = Identifier.fromProto(command.getTemplateId());
        Value contractKey = Value.fromProto(command.getContractKey());
        String choice = command.getChoice();
        Value choiceArgument = Value.fromProto(command.getChoiceArgument());
        return new ExerciseByKeyCommand(templateId, contractKey, choice, choiceArgument);
    }

    public CommandsOuterClass.ExerciseByKeyCommand toProto() {
        return CommandsOuterClass.ExerciseByKeyCommand.newBuilder().setTemplateId(this.templateId.toProto()).setContractKey(this.contractKey.toProto()).setChoice(this.choice).setChoiceArgument(this.choiceArgument.toProto()).build();
    }

    @Override
    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    public @NonNull Value getContractKey() {
        return this.contractKey;
    }

    public @NonNull String getChoice() {
        return this.choice;
    }

    public @NonNull Value getChoiceArgument() {
        return this.choiceArgument;
    }

    public String toString() {
        return "ExerciseByKeyCommand{templateId=" + this.templateId + ", contractKey='" + this.contractKey + '\'' + ", choice='" + this.choice + '\'' + ", choiceArgument=" + this.choiceArgument + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExerciseByKeyCommand that = (ExerciseByKeyCommand)o;
        return Objects.equals(this.templateId, that.templateId) && Objects.equals(this.contractKey, that.contractKey) && Objects.equals(this.choice, that.choice) && Objects.equals(this.choiceArgument, that.choiceArgument);
    }

    public int hashCode() {
        return Objects.hash(this.templateId, this.contractKey, this.choice, this.choiceArgument);
    }
}

