package com.daml.ledger.api.v1.testing;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Service to reset the ledger state. The goal here is to be able to reset the state in a way
 * that's much faster compared to restarting the whole ledger application (be it a sandbox
 * or the real ledger server).
 * Note that *all* state present in the ledger implementation will be reset, most importantly
 * including the ledger ID. This means that clients will have to re-fetch the ledger ID
 * from the identity service after hitting this endpoint.
 * The semantics are as follows:
 * * When the reset service returns the reset is initiated, but not completed;
 * * While the reset is performed, the ledger will not accept new requests. In fact we guarantee
 *   that ledger stops accepting new requests by the time the response to Reset is delivered;
 * * In-flight requests might be aborted, we make no guarantees on when or how quickly this
 *   happens;
 * * The ledger might be unavailable for a period of time before the reset is complete.
 * Given the above, the recommended mode of operation for clients of the reset endpoint is to
 * call it, then call the ledger identity endpoint in a retry loop that will tolerate a brief
 * window when the ledger is down, and resume operation as soon as the new ledger ID is delivered.
 * Note that this service will be available on the sandbox and might be available in some other testing
 * environments, but will *never* be available in production.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/testing/reset_service.proto")
public final class ResetServiceGrpc {

  private ResetServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.testing.ResetService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest,
      com.google.protobuf.Empty> getResetMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Reset",
      requestType = com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest,
      com.google.protobuf.Empty> getResetMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest, com.google.protobuf.Empty> getResetMethod;
    if ((getResetMethod = ResetServiceGrpc.getResetMethod) == null) {
      synchronized (ResetServiceGrpc.class) {
        if ((getResetMethod = ResetServiceGrpc.getResetMethod) == null) {
          ResetServiceGrpc.getResetMethod = getResetMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.testing.ResetService", "Reset"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
                  .setSchemaDescriptor(new ResetServiceMethodDescriptorSupplier("Reset"))
                  .build();
          }
        }
     }
     return getResetMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ResetServiceStub newStub(io.grpc.Channel channel) {
    return new ResetServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ResetServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new ResetServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static ResetServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new ResetServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Service to reset the ledger state. The goal here is to be able to reset the state in a way
   * that's much faster compared to restarting the whole ledger application (be it a sandbox
   * or the real ledger server).
   * Note that *all* state present in the ledger implementation will be reset, most importantly
   * including the ledger ID. This means that clients will have to re-fetch the ledger ID
   * from the identity service after hitting this endpoint.
   * The semantics are as follows:
   * * When the reset service returns the reset is initiated, but not completed;
   * * While the reset is performed, the ledger will not accept new requests. In fact we guarantee
   *   that ledger stops accepting new requests by the time the response to Reset is delivered;
   * * In-flight requests might be aborted, we make no guarantees on when or how quickly this
   *   happens;
   * * The ledger might be unavailable for a period of time before the reset is complete.
   * Given the above, the recommended mode of operation for clients of the reset endpoint is to
   * call it, then call the ledger identity endpoint in a retry loop that will tolerate a brief
   * window when the ledger is down, and resume operation as soon as the new ledger ID is delivered.
   * Note that this service will be available on the sandbox and might be available in some other testing
   * environments, but will *never* be available in production.
   * </pre>
   */
  public static abstract class ResetServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Resets the ledger state. Note that loaded DARs won't be removed -- this only rolls back the
     * ledger to genesis.
     * </pre>
     */
    public void reset(com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnimplementedUnaryCall(getResetMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getResetMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_RESET)))
          .build();
    }
  }

  /**
   * <pre>
   * Service to reset the ledger state. The goal here is to be able to reset the state in a way
   * that's much faster compared to restarting the whole ledger application (be it a sandbox
   * or the real ledger server).
   * Note that *all* state present in the ledger implementation will be reset, most importantly
   * including the ledger ID. This means that clients will have to re-fetch the ledger ID
   * from the identity service after hitting this endpoint.
   * The semantics are as follows:
   * * When the reset service returns the reset is initiated, but not completed;
   * * While the reset is performed, the ledger will not accept new requests. In fact we guarantee
   *   that ledger stops accepting new requests by the time the response to Reset is delivered;
   * * In-flight requests might be aborted, we make no guarantees on when or how quickly this
   *   happens;
   * * The ledger might be unavailable for a period of time before the reset is complete.
   * Given the above, the recommended mode of operation for clients of the reset endpoint is to
   * call it, then call the ledger identity endpoint in a retry loop that will tolerate a brief
   * window when the ledger is down, and resume operation as soon as the new ledger ID is delivered.
   * Note that this service will be available on the sandbox and might be available in some other testing
   * environments, but will *never* be available in production.
   * </pre>
   */
  public static final class ResetServiceStub extends io.grpc.stub.AbstractStub<ResetServiceStub> {
    private ResetServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ResetServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ResetServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ResetServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Resets the ledger state. Note that loaded DARs won't be removed -- this only rolls back the
     * ledger to genesis.
     * </pre>
     */
    public void reset(com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getResetMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Service to reset the ledger state. The goal here is to be able to reset the state in a way
   * that's much faster compared to restarting the whole ledger application (be it a sandbox
   * or the real ledger server).
   * Note that *all* state present in the ledger implementation will be reset, most importantly
   * including the ledger ID. This means that clients will have to re-fetch the ledger ID
   * from the identity service after hitting this endpoint.
   * The semantics are as follows:
   * * When the reset service returns the reset is initiated, but not completed;
   * * While the reset is performed, the ledger will not accept new requests. In fact we guarantee
   *   that ledger stops accepting new requests by the time the response to Reset is delivered;
   * * In-flight requests might be aborted, we make no guarantees on when or how quickly this
   *   happens;
   * * The ledger might be unavailable for a period of time before the reset is complete.
   * Given the above, the recommended mode of operation for clients of the reset endpoint is to
   * call it, then call the ledger identity endpoint in a retry loop that will tolerate a brief
   * window when the ledger is down, and resume operation as soon as the new ledger ID is delivered.
   * Note that this service will be available on the sandbox and might be available in some other testing
   * environments, but will *never* be available in production.
   * </pre>
   */
  public static final class ResetServiceBlockingStub extends io.grpc.stub.AbstractStub<ResetServiceBlockingStub> {
    private ResetServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ResetServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ResetServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ResetServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Resets the ledger state. Note that loaded DARs won't be removed -- this only rolls back the
     * ledger to genesis.
     * </pre>
     */
    public com.google.protobuf.Empty reset(com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest request) {
      return blockingUnaryCall(
          getChannel(), getResetMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Service to reset the ledger state. The goal here is to be able to reset the state in a way
   * that's much faster compared to restarting the whole ledger application (be it a sandbox
   * or the real ledger server).
   * Note that *all* state present in the ledger implementation will be reset, most importantly
   * including the ledger ID. This means that clients will have to re-fetch the ledger ID
   * from the identity service after hitting this endpoint.
   * The semantics are as follows:
   * * When the reset service returns the reset is initiated, but not completed;
   * * While the reset is performed, the ledger will not accept new requests. In fact we guarantee
   *   that ledger stops accepting new requests by the time the response to Reset is delivered;
   * * In-flight requests might be aborted, we make no guarantees on when or how quickly this
   *   happens;
   * * The ledger might be unavailable for a period of time before the reset is complete.
   * Given the above, the recommended mode of operation for clients of the reset endpoint is to
   * call it, then call the ledger identity endpoint in a retry loop that will tolerate a brief
   * window when the ledger is down, and resume operation as soon as the new ledger ID is delivered.
   * Note that this service will be available on the sandbox and might be available in some other testing
   * environments, but will *never* be available in production.
   * </pre>
   */
  public static final class ResetServiceFutureStub extends io.grpc.stub.AbstractStub<ResetServiceFutureStub> {
    private ResetServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ResetServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ResetServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ResetServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Resets the ledger state. Note that loaded DARs won't be removed -- this only rolls back the
     * ledger to genesis.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> reset(
        com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getResetMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_RESET = 0;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ResetServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ResetServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_RESET:
          serviceImpl.reset((com.daml.ledger.api.v1.testing.ResetServiceOuterClass.ResetRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class ResetServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    ResetServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.testing.ResetServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("ResetService");
    }
  }

  private static final class ResetServiceFileDescriptorSupplier
      extends ResetServiceBaseDescriptorSupplier {
    ResetServiceFileDescriptorSupplier() {}
  }

  private static final class ResetServiceMethodDescriptorSupplier
      extends ResetServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    ResetServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ResetServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ResetServiceFileDescriptorSupplier())
              .addMethod(getResetMethod())
              .build();
        }
      }
    }
    return result;
  }
}
