package com.daml.ledger.api.v1.admin;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Status: experimental interface, will change before it is deemed production
 * ready
 * Query the Daml-LF packages supported by the ledger participant and upload
 * DAR files. We use 'backing participant' to refer to this specific participant
 * in the methods of this API.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/admin/package_management_service.proto")
public final class PackageManagementServiceGrpc {

  private PackageManagementServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.admin.PackageManagementService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest,
      com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse> getListKnownPackagesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListKnownPackages",
      requestType = com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest,
      com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse> getListKnownPackagesMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest, com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse> getListKnownPackagesMethod;
    if ((getListKnownPackagesMethod = PackageManagementServiceGrpc.getListKnownPackagesMethod) == null) {
      synchronized (PackageManagementServiceGrpc.class) {
        if ((getListKnownPackagesMethod = PackageManagementServiceGrpc.getListKnownPackagesMethod) == null) {
          PackageManagementServiceGrpc.getListKnownPackagesMethod = getListKnownPackagesMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest, com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.admin.PackageManagementService", "ListKnownPackages"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new PackageManagementServiceMethodDescriptorSupplier("ListKnownPackages"))
                  .build();
          }
        }
     }
     return getListKnownPackagesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest,
      com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse> getUploadDarFileMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UploadDarFile",
      requestType = com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest,
      com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse> getUploadDarFileMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest, com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse> getUploadDarFileMethod;
    if ((getUploadDarFileMethod = PackageManagementServiceGrpc.getUploadDarFileMethod) == null) {
      synchronized (PackageManagementServiceGrpc.class) {
        if ((getUploadDarFileMethod = PackageManagementServiceGrpc.getUploadDarFileMethod) == null) {
          PackageManagementServiceGrpc.getUploadDarFileMethod = getUploadDarFileMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest, com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.admin.PackageManagementService", "UploadDarFile"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new PackageManagementServiceMethodDescriptorSupplier("UploadDarFile"))
                  .build();
          }
        }
     }
     return getUploadDarFileMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PackageManagementServiceStub newStub(io.grpc.Channel channel) {
    return new PackageManagementServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PackageManagementServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new PackageManagementServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PackageManagementServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new PackageManagementServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Query the Daml-LF packages supported by the ledger participant and upload
   * DAR files. We use 'backing participant' to refer to this specific participant
   * in the methods of this API.
   * </pre>
   */
  public static abstract class PackageManagementServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Returns the details of all Daml-LF packages known to the backing participant.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void listKnownPackages(com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListKnownPackagesMethod(), responseObserver);
    }

    /**
     * <pre>
     * Upload a DAR file to the backing participant.
     * Depending on the ledger implementation this might also make the package 
     * available on the whole ledger. This call might not be supported by some 
     * ledger implementations. Canton could be an example, where uploading a DAR
     * is not sufficient to render it usable, it must be activated first.
     * This call may:
     * - Succeed, if the package was successfully uploaded, or if the same package
     *   was already uploaded before.
     * - Respond with a gRPC error
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``UNIMPLEMENTED``: if DAR package uploading is not supported by the backing participant
     * - ``INVALID_ARGUMENT``: if the DAR file is too big or malformed. The maximum supported size is implementation specific.
     * </pre>
     */
    public void uploadDarFile(com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUploadDarFileMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getListKnownPackagesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest,
                com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse>(
                  this, METHODID_LIST_KNOWN_PACKAGES)))
          .addMethod(
            getUploadDarFileMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest,
                com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse>(
                  this, METHODID_UPLOAD_DAR_FILE)))
          .build();
    }
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Query the Daml-LF packages supported by the ledger participant and upload
   * DAR files. We use 'backing participant' to refer to this specific participant
   * in the methods of this API.
   * </pre>
   */
  public static final class PackageManagementServiceStub extends io.grpc.stub.AbstractStub<PackageManagementServiceStub> {
    private PackageManagementServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PackageManagementServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PackageManagementServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PackageManagementServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the details of all Daml-LF packages known to the backing participant.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void listKnownPackages(com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListKnownPackagesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Upload a DAR file to the backing participant.
     * Depending on the ledger implementation this might also make the package 
     * available on the whole ledger. This call might not be supported by some 
     * ledger implementations. Canton could be an example, where uploading a DAR
     * is not sufficient to render it usable, it must be activated first.
     * This call may:
     * - Succeed, if the package was successfully uploaded, or if the same package
     *   was already uploaded before.
     * - Respond with a gRPC error
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``UNIMPLEMENTED``: if DAR package uploading is not supported by the backing participant
     * - ``INVALID_ARGUMENT``: if the DAR file is too big or malformed. The maximum supported size is implementation specific.
     * </pre>
     */
    public void uploadDarFile(com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUploadDarFileMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Query the Daml-LF packages supported by the ledger participant and upload
   * DAR files. We use 'backing participant' to refer to this specific participant
   * in the methods of this API.
   * </pre>
   */
  public static final class PackageManagementServiceBlockingStub extends io.grpc.stub.AbstractStub<PackageManagementServiceBlockingStub> {
    private PackageManagementServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PackageManagementServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PackageManagementServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PackageManagementServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the details of all Daml-LF packages known to the backing participant.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse listKnownPackages(com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest request) {
      return blockingUnaryCall(
          getChannel(), getListKnownPackagesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Upload a DAR file to the backing participant.
     * Depending on the ledger implementation this might also make the package 
     * available on the whole ledger. This call might not be supported by some 
     * ledger implementations. Canton could be an example, where uploading a DAR
     * is not sufficient to render it usable, it must be activated first.
     * This call may:
     * - Succeed, if the package was successfully uploaded, or if the same package
     *   was already uploaded before.
     * - Respond with a gRPC error
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``UNIMPLEMENTED``: if DAR package uploading is not supported by the backing participant
     * - ``INVALID_ARGUMENT``: if the DAR file is too big or malformed. The maximum supported size is implementation specific.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse uploadDarFile(com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest request) {
      return blockingUnaryCall(
          getChannel(), getUploadDarFileMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Query the Daml-LF packages supported by the ledger participant and upload
   * DAR files. We use 'backing participant' to refer to this specific participant
   * in the methods of this API.
   * </pre>
   */
  public static final class PackageManagementServiceFutureStub extends io.grpc.stub.AbstractStub<PackageManagementServiceFutureStub> {
    private PackageManagementServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PackageManagementServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PackageManagementServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PackageManagementServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the details of all Daml-LF packages known to the backing participant.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse> listKnownPackages(
        com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListKnownPackagesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Upload a DAR file to the backing participant.
     * Depending on the ledger implementation this might also make the package 
     * available on the whole ledger. This call might not be supported by some 
     * ledger implementations. Canton could be an example, where uploading a DAR
     * is not sufficient to render it usable, it must be activated first.
     * This call may:
     * - Succeed, if the package was successfully uploaded, or if the same package
     *   was already uploaded before.
     * - Respond with a gRPC error
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``UNIMPLEMENTED``: if DAR package uploading is not supported by the backing participant
     * - ``INVALID_ARGUMENT``: if the DAR file is too big or malformed. The maximum supported size is implementation specific.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse> uploadDarFile(
        com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUploadDarFileMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LIST_KNOWN_PACKAGES = 0;
  private static final int METHODID_UPLOAD_DAR_FILE = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final PackageManagementServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(PackageManagementServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LIST_KNOWN_PACKAGES:
          serviceImpl.listKnownPackages((com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.ListKnownPackagesResponse>) responseObserver);
          break;
        case METHODID_UPLOAD_DAR_FILE:
          serviceImpl.uploadDarFile((com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.UploadDarFileResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class PackageManagementServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PackageManagementServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.admin.PackageManagementServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("PackageManagementService");
    }
  }

  private static final class PackageManagementServiceFileDescriptorSupplier
      extends PackageManagementServiceBaseDescriptorSupplier {
    PackageManagementServiceFileDescriptorSupplier() {}
  }

  private static final class PackageManagementServiceMethodDescriptorSupplier
      extends PackageManagementServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PackageManagementServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PackageManagementServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PackageManagementServiceFileDescriptorSupplier())
              .addMethod(getListKnownPackagesMethod())
              .addMethod(getUploadDarFileMethod())
              .build();
        }
      }
    }
    return result;
  }
}
