package com.daml.ledger.api.v1.admin;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Status: experimental interface, will change before it is deemed production
 * ready
 * Ledger configuration management service provides methods for the ledger administrator
 * to change the current ledger configuration. The services provides methods to modify
 * different aspects of the configuration.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/admin/config_management_service.proto")
public final class ConfigManagementServiceGrpc {

  private ConfigManagementServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.admin.ConfigManagementService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest,
      com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse> getGetTimeModelMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetTimeModel",
      requestType = com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest.class,
      responseType = com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest,
      com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse> getGetTimeModelMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest, com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse> getGetTimeModelMethod;
    if ((getGetTimeModelMethod = ConfigManagementServiceGrpc.getGetTimeModelMethod) == null) {
      synchronized (ConfigManagementServiceGrpc.class) {
        if ((getGetTimeModelMethod = ConfigManagementServiceGrpc.getGetTimeModelMethod) == null) {
          ConfigManagementServiceGrpc.getGetTimeModelMethod = getGetTimeModelMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest, com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.admin.ConfigManagementService", "GetTimeModel"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ConfigManagementServiceMethodDescriptorSupplier("GetTimeModel"))
                  .build();
          }
        }
     }
     return getGetTimeModelMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest,
      com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse> getSetTimeModelMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SetTimeModel",
      requestType = com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest.class,
      responseType = com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest,
      com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse> getSetTimeModelMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest, com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse> getSetTimeModelMethod;
    if ((getSetTimeModelMethod = ConfigManagementServiceGrpc.getSetTimeModelMethod) == null) {
      synchronized (ConfigManagementServiceGrpc.class) {
        if ((getSetTimeModelMethod = ConfigManagementServiceGrpc.getSetTimeModelMethod) == null) {
          ConfigManagementServiceGrpc.getSetTimeModelMethod = getSetTimeModelMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest, com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.admin.ConfigManagementService", "SetTimeModel"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ConfigManagementServiceMethodDescriptorSupplier("SetTimeModel"))
                  .build();
          }
        }
     }
     return getSetTimeModelMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ConfigManagementServiceStub newStub(io.grpc.Channel channel) {
    return new ConfigManagementServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ConfigManagementServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new ConfigManagementServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static ConfigManagementServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new ConfigManagementServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Ledger configuration management service provides methods for the ledger administrator
   * to change the current ledger configuration. The services provides methods to modify
   * different aspects of the configuration.
   * </pre>
   */
  public static abstract class ConfigManagementServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Return the currently active time model and the current configuration generation.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void getTimeModel(com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetTimeModelMethod(), responseObserver);
    }

    /**
     * <pre>
     * Set the ledger time model.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``INVALID_ARGUMENT``: if arguments are invalid, or the provided configuration generation
     *   does not match the current active configuration generation. The caller is expected
     *   to retry by again fetching current time model using 'GetTimeModel', applying changes
     *   and resubmitting.
     * - ``ABORTED``: if the request is rejected or times out. Note that a timed out request may
     *   have still been committed to the ledger. Application should re-query the current
     *   time model before retrying.
     * - ``UNIMPLEMENTED``: if this method is not supported by the backing ledger.
     * </pre>
     */
    public void setTimeModel(com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getSetTimeModelMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetTimeModelMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest,
                com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse>(
                  this, METHODID_GET_TIME_MODEL)))
          .addMethod(
            getSetTimeModelMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest,
                com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse>(
                  this, METHODID_SET_TIME_MODEL)))
          .build();
    }
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Ledger configuration management service provides methods for the ledger administrator
   * to change the current ledger configuration. The services provides methods to modify
   * different aspects of the configuration.
   * </pre>
   */
  public static final class ConfigManagementServiceStub extends io.grpc.stub.AbstractStub<ConfigManagementServiceStub> {
    private ConfigManagementServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ConfigManagementServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ConfigManagementServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ConfigManagementServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Return the currently active time model and the current configuration generation.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void getTimeModel(com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetTimeModelMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Set the ledger time model.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``INVALID_ARGUMENT``: if arguments are invalid, or the provided configuration generation
     *   does not match the current active configuration generation. The caller is expected
     *   to retry by again fetching current time model using 'GetTimeModel', applying changes
     *   and resubmitting.
     * - ``ABORTED``: if the request is rejected or times out. Note that a timed out request may
     *   have still been committed to the ledger. Application should re-query the current
     *   time model before retrying.
     * - ``UNIMPLEMENTED``: if this method is not supported by the backing ledger.
     * </pre>
     */
    public void setTimeModel(com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSetTimeModelMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Ledger configuration management service provides methods for the ledger administrator
   * to change the current ledger configuration. The services provides methods to modify
   * different aspects of the configuration.
   * </pre>
   */
  public static final class ConfigManagementServiceBlockingStub extends io.grpc.stub.AbstractStub<ConfigManagementServiceBlockingStub> {
    private ConfigManagementServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ConfigManagementServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ConfigManagementServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ConfigManagementServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Return the currently active time model and the current configuration generation.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse getTimeModel(com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetTimeModelMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Set the ledger time model.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``INVALID_ARGUMENT``: if arguments are invalid, or the provided configuration generation
     *   does not match the current active configuration generation. The caller is expected
     *   to retry by again fetching current time model using 'GetTimeModel', applying changes
     *   and resubmitting.
     * - ``ABORTED``: if the request is rejected or times out. Note that a timed out request may
     *   have still been committed to the ledger. Application should re-query the current
     *   time model before retrying.
     * - ``UNIMPLEMENTED``: if this method is not supported by the backing ledger.
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse setTimeModel(com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest request) {
      return blockingUnaryCall(
          getChannel(), getSetTimeModelMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Ledger configuration management service provides methods for the ledger administrator
   * to change the current ledger configuration. The services provides methods to modify
   * different aspects of the configuration.
   * </pre>
   */
  public static final class ConfigManagementServiceFutureStub extends io.grpc.stub.AbstractStub<ConfigManagementServiceFutureStub> {
    private ConfigManagementServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ConfigManagementServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ConfigManagementServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ConfigManagementServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Return the currently active time model and the current configuration generation.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse> getTimeModel(
        com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetTimeModelMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Set the ledger time model.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``INVALID_ARGUMENT``: if arguments are invalid, or the provided configuration generation
     *   does not match the current active configuration generation. The caller is expected
     *   to retry by again fetching current time model using 'GetTimeModel', applying changes
     *   and resubmitting.
     * - ``ABORTED``: if the request is rejected or times out. Note that a timed out request may
     *   have still been committed to the ledger. Application should re-query the current
     *   time model before retrying.
     * - ``UNIMPLEMENTED``: if this method is not supported by the backing ledger.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse> setTimeModel(
        com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSetTimeModelMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_TIME_MODEL = 0;
  private static final int METHODID_SET_TIME_MODEL = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ConfigManagementServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ConfigManagementServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_TIME_MODEL:
          serviceImpl.getTimeModel((com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.GetTimeModelResponse>) responseObserver);
          break;
        case METHODID_SET_TIME_MODEL:
          serviceImpl.setTimeModel((com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.SetTimeModelResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class ConfigManagementServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    ConfigManagementServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.admin.ConfigManagementServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("ConfigManagementService");
    }
  }

  private static final class ConfigManagementServiceFileDescriptorSupplier
      extends ConfigManagementServiceBaseDescriptorSupplier {
    ConfigManagementServiceFileDescriptorSupplier() {}
  }

  private static final class ConfigManagementServiceMethodDescriptorSupplier
      extends ConfigManagementServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    ConfigManagementServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ConfigManagementServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ConfigManagementServiceFileDescriptorSupplier())
              .addMethod(getGetTimeModelMethod())
              .addMethod(getSetTimeModelMethod())
              .build();
        }
      }
    }
    return result;
  }
}
