package com.daml.ledger.api.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Allows clients to query the Daml-LF packages that are supported by the server.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/package_service.proto")
public final class PackageServiceGrpc {

  private PackageServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.PackageService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest,
      com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse> getListPackagesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListPackages",
      requestType = com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest.class,
      responseType = com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest,
      com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse> getListPackagesMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest, com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse> getListPackagesMethod;
    if ((getListPackagesMethod = PackageServiceGrpc.getListPackagesMethod) == null) {
      synchronized (PackageServiceGrpc.class) {
        if ((getListPackagesMethod = PackageServiceGrpc.getListPackagesMethod) == null) {
          PackageServiceGrpc.getListPackagesMethod = getListPackagesMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest, com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.PackageService", "ListPackages"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new PackageServiceMethodDescriptorSupplier("ListPackages"))
                  .build();
          }
        }
     }
     return getListPackagesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest,
      com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse> getGetPackageMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetPackage",
      requestType = com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest.class,
      responseType = com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest,
      com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse> getGetPackageMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest, com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse> getGetPackageMethod;
    if ((getGetPackageMethod = PackageServiceGrpc.getGetPackageMethod) == null) {
      synchronized (PackageServiceGrpc.class) {
        if ((getGetPackageMethod = PackageServiceGrpc.getGetPackageMethod) == null) {
          PackageServiceGrpc.getGetPackageMethod = getGetPackageMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest, com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.PackageService", "GetPackage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new PackageServiceMethodDescriptorSupplier("GetPackage"))
                  .build();
          }
        }
     }
     return getGetPackageMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest,
      com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse> getGetPackageStatusMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetPackageStatus",
      requestType = com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest.class,
      responseType = com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest,
      com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse> getGetPackageStatusMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest, com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse> getGetPackageStatusMethod;
    if ((getGetPackageStatusMethod = PackageServiceGrpc.getGetPackageStatusMethod) == null) {
      synchronized (PackageServiceGrpc.class) {
        if ((getGetPackageStatusMethod = PackageServiceGrpc.getGetPackageStatusMethod) == null) {
          PackageServiceGrpc.getGetPackageStatusMethod = getGetPackageStatusMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest, com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.PackageService", "GetPackageStatus"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new PackageServiceMethodDescriptorSupplier("GetPackageStatus"))
                  .build();
          }
        }
     }
     return getGetPackageStatusMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PackageServiceStub newStub(io.grpc.Channel channel) {
    return new PackageServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PackageServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new PackageServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PackageServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new PackageServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Allows clients to query the Daml-LF packages that are supported by the server.
   * </pre>
   */
  public static abstract class PackageServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Returns the identifiers of all supported packages.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * </pre>
     */
    public void listPackages(com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListPackagesMethod(), responseObserver);
    }

    /**
     * <pre>
     * Returns the contents of a single package.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the requested package is unknown
     * </pre>
     */
    public void getPackage(com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetPackageMethod(), responseObserver);
    }

    /**
     * <pre>
     * Returns the status of a single package.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the requested package is unknown
     * </pre>
     */
    public void getPackageStatus(com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetPackageStatusMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getListPackagesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest,
                com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse>(
                  this, METHODID_LIST_PACKAGES)))
          .addMethod(
            getGetPackageMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest,
                com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse>(
                  this, METHODID_GET_PACKAGE)))
          .addMethod(
            getGetPackageStatusMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest,
                com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse>(
                  this, METHODID_GET_PACKAGE_STATUS)))
          .build();
    }
  }

  /**
   * <pre>
   * Allows clients to query the Daml-LF packages that are supported by the server.
   * </pre>
   */
  public static final class PackageServiceStub extends io.grpc.stub.AbstractStub<PackageServiceStub> {
    private PackageServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PackageServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PackageServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PackageServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the identifiers of all supported packages.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * </pre>
     */
    public void listPackages(com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListPackagesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Returns the contents of a single package.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the requested package is unknown
     * </pre>
     */
    public void getPackage(com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetPackageMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Returns the status of a single package.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the requested package is unknown
     * </pre>
     */
    public void getPackageStatus(com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetPackageStatusMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Allows clients to query the Daml-LF packages that are supported by the server.
   * </pre>
   */
  public static final class PackageServiceBlockingStub extends io.grpc.stub.AbstractStub<PackageServiceBlockingStub> {
    private PackageServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PackageServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PackageServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PackageServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the identifiers of all supported packages.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * </pre>
     */
    public com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse listPackages(com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest request) {
      return blockingUnaryCall(
          getChannel(), getListPackagesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Returns the contents of a single package.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the requested package is unknown
     * </pre>
     */
    public com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse getPackage(com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetPackageMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Returns the status of a single package.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the requested package is unknown
     * </pre>
     */
    public com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse getPackageStatus(com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetPackageStatusMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Allows clients to query the Daml-LF packages that are supported by the server.
   * </pre>
   */
  public static final class PackageServiceFutureStub extends io.grpc.stub.AbstractStub<PackageServiceFutureStub> {
    private PackageServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PackageServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PackageServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PackageServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the identifiers of all supported packages.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse> listPackages(
        com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListPackagesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Returns the contents of a single package.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the requested package is unknown
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse> getPackage(
        com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetPackageMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Returns the status of a single package.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the requested package is unknown
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse> getPackageStatus(
        com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetPackageStatusMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LIST_PACKAGES = 0;
  private static final int METHODID_GET_PACKAGE = 1;
  private static final int METHODID_GET_PACKAGE_STATUS = 2;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final PackageServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(PackageServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LIST_PACKAGES:
          serviceImpl.listPackages((com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.PackageServiceOuterClass.ListPackagesResponse>) responseObserver);
          break;
        case METHODID_GET_PACKAGE:
          serviceImpl.getPackage((com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageResponse>) responseObserver);
          break;
        case METHODID_GET_PACKAGE_STATUS:
          serviceImpl.getPackageStatus((com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.PackageServiceOuterClass.GetPackageStatusResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class PackageServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PackageServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.PackageServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("PackageService");
    }
  }

  private static final class PackageServiceFileDescriptorSupplier
      extends PackageServiceBaseDescriptorSupplier {
    PackageServiceFileDescriptorSupplier() {}
  }

  private static final class PackageServiceMethodDescriptorSupplier
      extends PackageServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PackageServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PackageServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PackageServiceFileDescriptorSupplier())
              .addMethod(getListPackagesMethod())
              .addMethod(getGetPackageMethod())
              .addMethod(getGetPackageStatusMethod())
              .build();
        }
      }
    }
    return result;
  }
}
