/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.androidanimations.library;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.animation.Interpolator;

public abstract class BaseViewAnimator {
    public static final long DURATION = 1000L;
    private AnimatorSet mAnimatorSet = new AnimatorSet();
    private long mDuration = 1000L;
    private int mRepeatTimes = 0;
    private int mRepeatMode = 1;

    protected abstract void prepare(View var1);

    public BaseViewAnimator setTarget(View target) {
        this.reset(target);
        this.prepare(target);
        return this;
    }

    public void animate() {
        this.start();
    }

    public void restart() {
        this.mAnimatorSet = this.mAnimatorSet.clone();
        this.start();
    }

    public void reset(View target) {
        ViewCompat.setAlpha((View)target, (float)1.0f);
        ViewCompat.setScaleX((View)target, (float)1.0f);
        ViewCompat.setScaleY((View)target, (float)1.0f);
        ViewCompat.setTranslationX((View)target, (float)0.0f);
        ViewCompat.setTranslationY((View)target, (float)0.0f);
        ViewCompat.setRotation((View)target, (float)0.0f);
        ViewCompat.setRotationY((View)target, (float)0.0f);
        ViewCompat.setRotationX((View)target, (float)0.0f);
    }

    public void start() {
        for (Animator animator : this.mAnimatorSet.getChildAnimations()) {
            if (!(animator instanceof ValueAnimator)) continue;
            ((ValueAnimator)animator).setRepeatCount(this.mRepeatTimes);
            ((ValueAnimator)animator).setRepeatMode(this.mRepeatMode);
        }
        this.mAnimatorSet.setDuration(this.mDuration);
        this.mAnimatorSet.start();
    }

    public BaseViewAnimator setDuration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public BaseViewAnimator setStartDelay(long delay) {
        this.getAnimatorAgent().setStartDelay(delay);
        return this;
    }

    public long getStartDelay() {
        return this.mAnimatorSet.getStartDelay();
    }

    public BaseViewAnimator addAnimatorListener(Animator.AnimatorListener l) {
        this.mAnimatorSet.addListener(l);
        return this;
    }

    public void cancel() {
        this.mAnimatorSet.cancel();
    }

    public boolean isRunning() {
        return this.mAnimatorSet.isRunning();
    }

    public boolean isStarted() {
        return this.mAnimatorSet.isStarted();
    }

    public void removeAnimatorListener(Animator.AnimatorListener l) {
        this.mAnimatorSet.removeListener(l);
    }

    public void removeAllListener() {
        this.mAnimatorSet.removeAllListeners();
    }

    public BaseViewAnimator setInterpolator(Interpolator interpolator) {
        this.mAnimatorSet.setInterpolator((TimeInterpolator)interpolator);
        return this;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public AnimatorSet getAnimatorAgent() {
        return this.mAnimatorSet;
    }

    public BaseViewAnimator setRepeatTimes(int repeatTimes) {
        this.mRepeatTimes = repeatTimes;
        return this;
    }

    public BaseViewAnimator setRepeatMode(int repeatMode) {
        this.mRepeatMode = repeatMode;
        return this;
    }
}

