/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.handle;

import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.handle.InitVersionProcessor;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigBaseInfo;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigClientInfo;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigUserPwdInfo;
import com.dahuatech.icc.oauth.profile.GrantType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class LoadHttpConfigInfo {
    private final Log logger = LogFactory.get();
    private volatile Properties configuration = new Properties();
    private OauthConfigBaseInfo oauthConfigBaseInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadIccSdkProperties() {
        if (this.oauthConfigBaseInfo != null) {
            return;
        }
        InputStream is = this.getClass().getResourceAsStream("/config/iccSdk.properties");
        if (is != null) {
            try {
                this.configuration.clear();
                this.configuration.load(is);
                String host = this.configuration.getProperty("icc.sdk.host");
                String httpPort = "83";
                String httpsPort = "443";
                boolean enableHttps = Boolean.parseBoolean(this.configuration.getProperty("icc.sdk.enable.https", "true"));
                if (enableHttps) {
                    if (host.contains(":")) {
                        httpsPort = host.split(":")[1];
                        host = host.split(":")[0];
                    }
                } else if (host.contains(":")) {
                    httpPort = host.split(":")[1];
                    host = host.split(":")[0];
                }
                if (GrantType.password.name().equals(this.configuration.getProperty("icc.sdk.grantType"))) {
                    String pwdClientId = this.configuration.getProperty("icc.sdk.pwdClientId");
                    String pwdClientSecret = this.configuration.getProperty("icc.sdk.pwdClientSecret");
                    String username = this.configuration.getProperty("icc.sdk.username");
                    String password = this.configuration.getProperty("icc.sdk.password");
                    this.oauthConfigBaseInfo = new OauthConfigUserPwdInfo(host, pwdClientId, pwdClientSecret, username, password, !enableHttps, httpsPort, httpPort);
                } else {
                    String clientId = this.configuration.getProperty("icc.sdk.clientId");
                    String clientSecret = this.configuration.getProperty("icc.sdk.clientSecret");
                    String userId = this.configuration.getProperty("icc.sdk.config.client.userId", "1");
                    this.oauthConfigBaseInfo = new OauthConfigClientInfo(host, clientId, clientSecret, userId, !enableHttps, httpsPort, httpPort);
                }
                InitVersionProcessor.getInstance().initSystemVersion(this.oauthConfigBaseInfo.getHttpConfigInfo());
                this.logger.info("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5b8c\u6210", new Object[0]);
            }
            catch (ClientException | IOException throwable) {
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        } else {
            this.logger.info("can not load [classpath:resources/config/iccSdk.properties] , use DefaultClient constructor instead ", new Object[0]);
        }
    }

    public OauthConfigBaseInfo getOauthConfigBaseInfo() {
        return this.oauthConfigBaseInfo;
    }

    public void setOauthConfigBaseInfo(OauthConfigBaseInfo oauthConfigBaseInfo) {
        this.oauthConfigBaseInfo = oauthConfigBaseInfo;
    }

    public static synchronized LoadHttpConfigInfo getInstance() {
        return SingleHolder.INSTANCE;
    }

    private static class SingleHolder {
        public static final LoadHttpConfigInfo INSTANCE = new LoadHttpConfigInfo();

        private SingleHolder() {
        }
    }
}

