/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.http;

import com.dahuatech.hutool.core.util.StrUtil;
import java.nio.charset.Charset;

public enum ContentType {
    FORM_URLENCODED("application/x-www-form-urlencoded"),
    MULTIPART("multipart/form-data"),
    JSON("application/json"),
    XML("application/xml"),
    TEXT_XML("text/xml");

    private String value;

    private ContentType(String value) {
        this.value = value;
    }

    public static boolean isDefault(String contentType) {
        return null == contentType || ContentType.isFormUrlEncoed(contentType);
    }

    public static boolean isFormUrlEncoed(String contentType) {
        return StrUtil.startWithIgnoreCase(contentType, FORM_URLENCODED.toString());
    }

    public static ContentType get(String body) {
        ContentType contentType = null;
        if (StrUtil.isNotBlank(body)) {
            char firstChar = body.charAt(0);
            switch (firstChar) {
                case '[': 
                case '{': {
                    contentType = JSON;
                    break;
                }
                case '<': {
                    contentType = XML;
                    break;
                }
            }
        }
        return contentType;
    }

    public static String build(String contentType, Charset charset) {
        return StrUtil.format((CharSequence)"{};charset={}", contentType, charset.name());
    }

    public String toString() {
        return this.value;
    }

    public String toString(Charset charset) {
        return ContentType.build(this.value, charset);
    }
}

