/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.joda;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class InstantCodec
extends TypeCodec<Instant> {
    public static final InstantCodec instance = new InstantCodec();
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateOptionalTimeParser().getParser()).appendOptional(new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toParser()).toFormatter().withZoneUTC();
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ").withZoneUTC();

    private InstantCodec() {
        super(DataType.timestamp(), Instant.class);
    }

    @Override
    public ByteBuffer serialize(Instant value, ProtocolVersion protocolVersion) {
        return value == null ? null : InstantCodec.bigint().serializeNoBoxing(value.getMillis(), protocolVersion);
    }

    @Override
    public Instant deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        long millis = InstantCodec.bigint().deserializeNoBoxing(bytes, protocolVersion);
        return new Instant(millis);
    }

    @Override
    public String format(Instant value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote(FORMATTER.print((ReadableInstant)value));
    }

    @Override
    public Instant parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted(value)) {
            value = ParseUtils.unquote(value);
        }
        if (ParseUtils.isLongLiteral(value)) {
            try {
                return new Instant(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value));
            }
        }
        try {
            return new Instant(PARSER.parseMillis(value));
        }
        catch (RuntimeException e) {
            throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value));
        }
    }
}

