/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.examples.mongodb;

import com.d0x7.utils.database.Repository;
import com.d0x7.utils.examples.mongodb.ExampleMongoRepository;
import com.d0x7.utils.mongodb.MongoDB;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import org.bson.Document;

public class MongoDBExample {
    public static void main(String[] args) {
        Futures.addCallback(MongoDB.setup(), new FutureCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean success) {
                if (!success.booleanValue()) {
                    throw new RuntimeException("Failed to connect to MongoDB");
                }
                ExampleMongoRepository repo = new ExampleMongoRepository();
                Futures.addCallback(repo.findSomething(), new FutureCallback<Document>(){

                    @Override
                    public void onSuccess(Document document) {
                        if (document != null) {
                            System.out.println("We found a awesome document!");
                            System.out.println(document);
                        } else {
                            System.out.println("We couldn't find a document! :(");
                        }
                    }

                    @Override
                    public void onFailure(Throwable throwable) {
                        throwable.printStackTrace();
                        System.out.println("ffs, something dumb happened!");
                    }
                });
                Repository.getRepository(ExampleMongoRepository.class);
                Document document = (Document)MongoDB.getDatabase().getCollection("my_awesome_collection").find().first();
                if (document != null) {
                    System.out.println("We found a awesome document!");
                    System.out.println(document);
                } else {
                    System.out.println("We couldn't find a document! :(");
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                throwable.printStackTrace();
                System.exit(1);
            }
        });
    }
}

