/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ClientException;
import com.cybersource.ws.client.Connection;
import com.cybersource.ws.client.ConnectionHelper;
import com.cybersource.ws.client.IdleConnectionMonitorThread;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.LoggerWrapper;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;

public class PoolingHttpClientConnection
extends Connection {
    private HttpPost httpPost = null;
    private HttpClientContext httpContext = null;
    private CloseableHttpResponse httpResponse = null;
    private static CloseableHttpClient httpClient = null;
    private static IdleConnectionMonitorThread staleMonitorThread;
    private static final String STALE_CONNECTION_MONITOR_THREAD_NAME = "http-stale-connection-cleaner-thread";
    private static PoolingHttpClientConnectionManager connectionManager;

    PoolingHttpClientConnection(MerchantConfig mc, DocumentBuilder builder, LoggerWrapper logger) throws ClientException {
        super(mc, builder, logger);
        this.initializeConnectionManager(mc);
        logger.log("INFO     ", "Using PoolingHttpClient for connections.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeConnectionManager(MerchantConfig merchantConfig) throws ClientException {
        if (connectionManager != null) return;
        Class<PoolingHttpClientConnection> clazz = PoolingHttpClientConnection.class;
        synchronized (PoolingHttpClientConnection.class) {
            if (connectionManager != null) return;
            String url = merchantConfig.getEffectiveServerURL();
            try {
                URI uri = new URI(url);
                String hostname = uri.getHost();
                connectionManager = new PoolingHttpClientConnectionManager();
                connectionManager.setDefaultMaxPerRoute(merchantConfig.getDefaultMaxConnectionsPerRoute());
                connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(true).setSoTimeout(merchantConfig.getSocketTimeoutMs()).build());
                connectionManager.setMaxTotal(merchantConfig.getMaxConnections());
                connectionManager.setValidateAfterInactivity(merchantConfig.getValidateAfterInactivityMs());
                HttpHost httpHost = new HttpHost(hostname);
                connectionManager.setMaxPerRoute(new HttpRoute(httpHost), merchantConfig.getMaxConnectionsPerRoute());
                this.initHttpClient(merchantConfig, connectionManager);
                this.startStaleConnectionMonitorThread(merchantConfig, connectionManager);
                if (!merchantConfig.isShutdownHookEnabled()) return;
                this.addShutdownHook();
            }
            catch (Exception e) {
                this.logger.log("FAULT    ", "invalid server url");
                throw new ClientException(e, (Logger)this.logger);
            }
            return;
        }
    }

    protected void initHttpClient(MerchantConfig merchantConfig, PoolingHttpClientConnectionManager poolingHttpClientConnManager) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setSocketTimeout(merchantConfig.getSocketTimeoutMs()).setConnectionRequestTimeout(merchantConfig.getConnectionRequestTimeoutMs()).setStaleConnectionCheckEnabled(merchantConfig.isStaleConnectionCheckEnabled()).setConnectTimeout(merchantConfig.getConnectionTimeoutMs());
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnManager);
        if (merchantConfig.isAllowRetry()) {
            httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new CustomRetryHandler());
        }
        ConnectionHelper.setProxy(httpClientBuilder, requestConfigBuilder, merchantConfig);
        httpClient = httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build()).build();
    }

    private void startStaleConnectionMonitorThread(MerchantConfig merchantConfig, PoolingHttpClientConnectionManager poolingHttpClientConnManager) {
        staleMonitorThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)poolingHttpClientConnManager, merchantConfig.getEvictThreadSleepTimeMs(), merchantConfig.getMaxKeepAliveTimeMs());
        staleMonitorThread.setName(STALE_CONNECTION_MONITOR_THREAD_NAME);
        staleMonitorThread.setDaemon(true);
        staleMonitorThread.start();
    }

    @Override
    void postDocument(Document request, long startTime) throws IOException, TransformerException {
        String serverURL = this.mc.getEffectiveServerURL();
        this.httpPost = new HttpPost(serverURL);
        String requestString = this.documentToString(request);
        StringEntity stringEntity = new StringEntity(requestString, "UTF-8");
        this.httpPost.setEntity((HttpEntity)stringEntity);
        this.httpPost.setHeader("v-c-client-computetime", String.valueOf(System.currentTimeMillis() - startTime));
        this.httpPost.setHeader("v-c-client-iat", String.valueOf(System.currentTimeMillis()));
        this.logRequestHeaders();
        this.httpContext = HttpClientContext.create();
        this.logger.log("INFO     ", "Sending " + requestString.length() + " bytes to " + serverURL);
        this.httpResponse = httpClient.execute((HttpUriRequest)this.httpPost, (HttpContext)this.httpContext);
    }

    @Override
    public boolean isRequestSent() {
        return this.httpContext != null && this.httpContext.isRequestSent();
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.createShutdownHookThread());
    }

    private Thread createShutdownHookThread() {
        return new Thread(){

            @Override
            public void run() {
                try {
                    PoolingHttpClientConnection.onShutdown();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public static void onShutdown() throws IOException {
        if (httpClient != null) {
            httpClient.close();
        }
        if (connectionManager != null) {
            connectionManager.close();
        }
        if (staleMonitorThread != null && staleMonitorThread.isAlive()) {
            staleMonitorThread.shutdown();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException var4) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void release() throws ClientException {
        try {
            if (this.httpResponse != null) {
                EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                this.httpResponse.close();
            }
        }
        catch (IOException e) {
            throw new ClientException(e, (Logger)this.logger);
        }
    }

    @Override
    int getHttpResponseCode() {
        return this.httpResponse != null ? this.httpResponse.getStatusLine().getStatusCode() : -1;
    }

    @Override
    InputStream getResponseStream() throws IOException {
        return this.httpResponse != null ? this.httpResponse.getEntity().getContent() : null;
    }

    @Override
    InputStream getResponseErrorStream() throws IOException {
        return this.getResponseStream();
    }

    @Override
    public void logRequestHeaders() {
        if (this.mc.getEnableLog() && this.httpPost != null) {
            List<Header> reqHeaders = Arrays.asList(this.httpPost.getAllHeaders());
            this.logger.log("INFO     ", "Request Headers: " + reqHeaders);
        }
    }

    @Override
    public void logResponseHeaders() {
        if (this.mc.getEnableLog() && this.httpResponse != null) {
            long resIAT;
            Header responseTimeHeader = this.httpResponse.getFirstHeader("v-c-response-time");
            if (responseTimeHeader != null && StringUtils.isNotBlank((CharSequence)responseTimeHeader.getValue()) && (resIAT = Utility.getResponseIssuedAtTime(responseTimeHeader.getValue())) > 0L) {
                this.logger.log("INFO     ", "responseTransitTimeSec : " + Utility.getResponseTransitTime(resIAT));
            }
            List<Header> respHeaders = Arrays.asList(this.httpResponse.getAllHeaders());
            this.logger.log("INFO     ", "Response Headers: " + respHeaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String documentToString(Document request) throws IOException, TransformerException {
        ByteArrayOutputStream baos = null;
        try {
            baos = PoolingHttpClientConnection.makeStream(request);
            String string = baos.toString("utf-8");
            return string;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
        }
    }

    private void retryAfter(long millis, int executionCount, String reason) {
        try {
            Thread.sleep(millis);
            this.logger.log("INFO     ", "Retrying Request due to " + reason + "-- Retry Count -- " + executionCount);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    static {
        connectionManager = null;
    }

    private class CustomRetryHandler
    implements HttpRequestRetryHandler {
        long retryWaitInterval;
        int maxRetries;

        private CustomRetryHandler() {
            this.retryWaitInterval = PoolingHttpClientConnection.this.mc.getRetryInterval();
            this.maxRetries = PoolingHttpClientConnection.this.mc.getNumberOfRetries();
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext httpContext) {
            HttpClientContext httpClientContext;
            if (executionCount > this.maxRetries) {
                return false;
            }
            if (exception instanceof ConnectTimeoutException || exception instanceof HttpHostConnectException) {
                PoolingHttpClientConnection.this.retryAfter(this.retryWaitInterval, executionCount, exception.getMessage());
                return true;
            }
            if (PoolingHttpClientConnection.this.mc.retryIfMTIFieldExistEnabled()) {
                if (exception instanceof NoHttpResponseException) {
                    PoolingHttpClientConnection.this.retryAfter(this.retryWaitInterval, executionCount, exception.getMessage());
                    return true;
                }
                if (exception instanceof SocketException || exception instanceof SSLException) {
                    String errMessage = exception.getMessage();
                    if (StringUtils.isBlank((CharSequence)errMessage)) {
                        errMessage = exception.getLocalizedMessage();
                    }
                    if (StringUtils.isNotBlank((CharSequence)errMessage) && (errMessage.equalsIgnoreCase("Connection reset") || errMessage.contains("Connection reset"))) {
                        PoolingHttpClientConnection.this.retryAfter(this.retryWaitInterval, executionCount, errMessage);
                        return true;
                    }
                }
            }
            if (!(httpClientContext = HttpClientContext.adapt((HttpContext)httpContext)).isRequestSent()) {
                PoolingHttpClientConnection.this.retryAfter(this.retryWaitInterval, executionCount, "request_not_sent");
                return true;
            }
            return false;
        }
    }
}

