/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.ConnectionHelper;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class MerchantConfig {
    private final String SYSPROP_PREFIX = "cybs.";
    private static final int DEFAULT_TIMEOUT = 130;
    private static final int DEFAULT_PROXY_PORT = 8080;
    private final Properties props;
    private final String merchantID;
    private String keysDirectory;
    private String keyAlias;
    private String keyPassword;
    private boolean sendToProduction;
    private boolean sendToAkamai;
    private String targetAPIVersion;
    private String keyFilename;
    private String serverURL;
    private String namespaceURI;
    private String password;
    private boolean useHttpClientWithConnectionPool;
    private int maxConnections;
    private int defaultMaxConnectionsPerRoute;
    private int maxConnectionsPerRoute;
    private int connectionRequestTimeoutMs;
    private int connectionTimeoutMs;
    private int socketTimeoutMs;
    private int evictThreadSleepTimeMs;
    private int maxKeepAliveTimeMs;
    private int validateAfterInactivityMs;
    private boolean staleConnectionCheckEnabled;
    private boolean shutdownHookEnabled;
    private boolean retryIfMTIFieldExist;
    private boolean useHttpClient;
    private boolean allowRetry;
    private int numberOfRetries = 0;
    private long retryInterval = 0L;
    @Deprecated
    private int timeout;
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private boolean enableJdkCert;
    private boolean enableCacert;
    private boolean enableLog;
    private boolean logSignedData;
    private String logDirectory;
    private String logFilename;
    private int logMaximumSize;
    private String cacertPassword;
    private String customHttpClass;
    private boolean customHttpClassEnabled;
    private boolean certificateCacheEnabled;
    private boolean useSignAndEncrypted;
    private boolean merchantConfigCacheEnabled;
    private String effectiveServerURL;
    private String effectiveNamespaceURI;
    private String effectivePassword;

    public MerchantConfig(Properties _props, String _merchantID) throws ConfigException {
        this.props = _props;
        String string = this.merchantID = _merchantID != null ? _merchantID : this.getProperty(null, "merchantID");
        if (this.merchantID == null) {
            throw new ConfigException("merchantID is required.");
        }
        this.keysDirectory = this.getProperty(this.merchantID, "keysDirectory");
        this.keyAlias = this.getProperty(this.merchantID, "keyAlias");
        this.keyPassword = this.getProperty(this.merchantID, "keyPassword");
        this.sendToProduction = this.getBooleanProperty(this.merchantID, "sendToProduction", false);
        this.sendToAkamai = this.getBooleanProperty(this.merchantID, "sendToAkamai", false);
        this.targetAPIVersion = this.getProperty(this.merchantID, "targetAPIVersion");
        this.keyFilename = this.getProperty(this.merchantID, "keyFilename");
        this.serverURL = this.getProperty(this.merchantID, "serverURL");
        this.namespaceURI = this.getProperty(this.merchantID, "namespaceURI");
        this.password = this.getProperty(this.merchantID, "password");
        this.enableLog = this.getBooleanProperty(this.merchantID, "enableLog", false);
        this.logSignedData = this.getBooleanProperty(this.merchantID, "logNonPCICompliantSignedData", false);
        this.logDirectory = this.getProperty(this.merchantID, "logDirectory");
        this.logFilename = this.getProperty(this.merchantID, "logFilename");
        this.logMaximumSize = this.getIntegerProperty(this.merchantID, "logMaximumSize", 10);
        this.useHttpClient = this.getBooleanProperty(this.merchantID, "useHttpClient", ConnectionHelper.getDefaultUseHttpClient());
        this.useHttpClientWithConnectionPool = this.getBooleanProperty(this.merchantID, "useHttpClientWithConnectionPool", false);
        this.customHttpClass = this.getProperty(this.merchantID, "customHttpClass");
        this.timeout = this.getIntegerProperty(this.merchantID, "timeout", 130);
        this.proxyHost = this.getProperty(this.merchantID, "proxyHost");
        this.proxyPort = this.getIntegerProperty(this.merchantID, "proxyPort", 8080);
        this.proxyUser = this.getProperty(this.merchantID, "proxyUser");
        this.proxyPassword = this.getProperty(this.merchantID, "proxyPassword");
        this.enableJdkCert = this.getBooleanProperty(this.merchantID, "enableJdkCert", false);
        this.enableCacert = this.getBooleanProperty(this.merchantID, "enableCacert", false);
        this.cacertPassword = this.getProperty(this.merchantID, "cacertPassword", "changeit");
        this.customHttpClassEnabled = this.getBooleanProperty(this.merchantID, "customHttpClassEnabled", false);
        this.certificateCacheEnabled = this.getBooleanProperty(this.merchantID, "certificateCacheEnabled", true);
        this.merchantConfigCacheEnabled = this.getBooleanProperty(this.merchantID, "merchantConfigCacheEnabled", false);
        if (this.namespaceURI == null && this.targetAPIVersion == null) {
            throw new ConfigException("namespaceURI or targetAPIVersion must be supplied.");
        }
        String string2 = this.effectiveNamespaceURI = this.namespaceURI != null ? this.namespaceURI : "urn:schemas-cybersource-com:transaction-data-" + this.targetAPIVersion;
        if (this.serverURL == null && this.targetAPIVersion == null) {
            throw new ConfigException("serverURL or targetAPIVersion must be supplied.");
        }
        if (this.serverURL != null) {
            this.effectiveServerURL = this.serverURL;
        } else {
            int dotPos = this.targetAPIVersion.indexOf(46);
            String majorVersion = dotPos >= 0 ? this.targetAPIVersion.substring(0, dotPos) : this.targetAPIVersion;
            Object[] arguments = new Object[]{majorVersion};
            this.effectiveServerURL = MessageFormat.format(this.sendToAkamai ? (this.sendToProduction ? "https://ics2wsa.ic3.com/commerce/{0}.x/transactionProcessor" : "https://ics2wstesta.ic3.com/commerce/{0}.x/transactionProcessor") : (this.sendToProduction ? "https://ics2ws.ic3.com/commerce/{0}.x/transactionProcessor" : "https://ics2wstest.ic3.com/commerce/{0}.x/transactionProcessor"), arguments);
        }
        this.effectivePassword = this.password != null ? this.password : this.merchantID;
        this.useSignAndEncrypted = this.getBooleanProperty(this.merchantID, "useSignAndEncrypted", false);
        if (this.useHttpClientWithConnectionPool) {
            if (StringUtils.isEmpty((CharSequence)this.getProperty(this.merchantID, "maxConnections"))) {
                throw new ConfigException("maxConnections property is empty");
            }
            this.maxConnections = this.getIntegerProperty(this.merchantID, "maxConnections");
            if (this.maxConnections <= 0) {
                throw new ConfigException("maxConnections property can't be 0 or negative");
            }
            if (StringUtils.isEmpty((CharSequence)this.getProperty(this.merchantID, "defaultMaxConnectionsPerRoute"))) {
                throw new ConfigException("defaultMaxConnectionsPerRoute property is empty");
            }
            this.defaultMaxConnectionsPerRoute = this.getIntegerProperty(this.merchantID, "defaultMaxConnectionsPerRoute");
            if (this.defaultMaxConnectionsPerRoute <= 0) {
                throw new ConfigException("defaultMaxConnectionsPerRoute property can't be 0 or negative");
            }
            if (StringUtils.isEmpty((CharSequence)this.getProperty(this.merchantID, "maxConnectionsPerRoute"))) {
                throw new ConfigException("maxConnectionsPerRoute property is empty");
            }
            this.maxConnectionsPerRoute = this.getIntegerProperty(this.merchantID, "maxConnectionsPerRoute");
            if (this.maxConnectionsPerRoute <= 0) {
                throw new ConfigException("maxConnectionsPerRoute property can't be 0 or negative");
            }
            if (StringUtils.isEmpty((CharSequence)this.getProperty(this.merchantID, "connectionRequestTimeoutMs"))) {
                throw new ConfigException("connectionRequestTimeoutMs property is empty");
            }
            this.connectionRequestTimeoutMs = this.getIntegerProperty(this.merchantID, "connectionRequestTimeoutMs");
            if (this.connectionRequestTimeoutMs <= 0) {
                throw new ConfigException("connectionRequestTimeoutMs property can't be 0 or negative");
            }
            if (StringUtils.isEmpty((CharSequence)this.getProperty(this.merchantID, "connectionTimeoutMs"))) {
                throw new ConfigException("connectionTimeoutMs property is empty");
            }
            this.connectionTimeoutMs = this.getIntegerProperty(this.merchantID, "connectionTimeoutMs");
            if (this.connectionTimeoutMs <= 0) {
                throw new ConfigException("connectionTimeoutMs property can't be 0 or negative");
            }
            if (StringUtils.isEmpty((CharSequence)this.getProperty(this.merchantID, "socketTimeoutMs"))) {
                throw new ConfigException("socketTimeoutMs property is empty");
            }
            this.socketTimeoutMs = this.getIntegerProperty(this.merchantID, "socketTimeoutMs");
            if (this.socketTimeoutMs <= 0) {
                throw new ConfigException("socketTimeoutMs property can't be 0 or negative");
            }
            if (StringUtils.isEmpty((CharSequence)this.getProperty(this.merchantID, "evictThreadSleepTimeMs"))) {
                throw new ConfigException("evictThreadSleepTimeMs property is empty");
            }
            this.evictThreadSleepTimeMs = this.getIntegerProperty(this.merchantID, "evictThreadSleepTimeMs");
            if (this.evictThreadSleepTimeMs <= 0) {
                throw new ConfigException("evictThreadSleepTimeMs property can't be 0 or negative");
            }
            if (StringUtils.isEmpty((CharSequence)this.getProperty(this.merchantID, "maxKeepAliveTimeMs"))) {
                throw new ConfigException("maxKeepAliveTimeMs property is empty");
            }
            this.maxKeepAliveTimeMs = this.getIntegerProperty(this.merchantID, "maxKeepAliveTimeMs");
            if (this.maxKeepAliveTimeMs <= 0) {
                throw new ConfigException("maxKeepAliveTimeMs property can't be 0 or negative");
            }
            this.validateAfterInactivityMs = this.getIntegerProperty(this.merchantID, "validateAfterInactivityMs", 0);
            this.staleConnectionCheckEnabled = this.getBooleanProperty(this.merchantID, "staleConnectionCheckEnabled", true);
            this.shutdownHookEnabled = this.getBooleanProperty(this.merchantID, "enabledShutdownHook", true);
            this.retryIfMTIFieldExist = this.getBooleanProperty(this.merchantID, "retryIfMTIFieldExist", true);
        } else {
            if (StringUtils.isEmpty((CharSequence)this.getProperty(this.merchantID, "connectionTimeoutMs"))) {
                this.connectionTimeoutMs = this.timeout * 1000;
            } else {
                this.connectionTimeoutMs = this.getIntegerProperty(this.merchantID, "connectionTimeoutMs");
                if (this.connectionTimeoutMs <= 0) {
                    throw new ConfigException("connectionTimeoutMs property can't be 0 or negative");
                }
            }
            if (StringUtils.isEmpty((CharSequence)this.getProperty(this.merchantID, "socketTimeoutMs"))) {
                this.socketTimeoutMs = this.timeout * 1000;
            } else {
                this.socketTimeoutMs = this.getIntegerProperty(this.merchantID, "socketTimeoutMs");
                if (this.socketTimeoutMs <= 0) {
                    throw new ConfigException("socketTimeoutMs property can't be 0 or negative");
                }
            }
        }
        if (this.useHttpClient || this.useHttpClientWithConnectionPool) {
            this.allowRetry = this.getBooleanProperty(this.merchantID, "allowRetry", true);
            if (this.allowRetry) {
                this.numberOfRetries = this.getIntegerProperty(this.merchantID, "numberOfRetries", 3);
                if (this.numberOfRetries > 0) {
                    this.retryInterval = this.getIntegerProperty(this.merchantID, "retryInterval", 1000);
                }
                if (this.numberOfRetries < 1 || this.numberOfRetries > 5 || this.retryInterval <= 1L) {
                    throw new ConfigException("Invalid value of numberOfRetries and/or retryInterval(in ms)");
                }
            }
        }
        if (this.isCacertEnabled()) {
            if (StringUtils.isBlank((CharSequence)this.keysDirectory)) {
                this.keysDirectory = System.getProperty("java.home") + "/lib/security".replace('/', File.separatorChar);
            }
            if (StringUtils.isBlank((CharSequence)this.keyFilename)) {
                this.keyFilename = "cacerts";
            }
        }
    }

    public boolean getUseSignAndEncrypted() {
        return this.useSignAndEncrypted;
    }

    public String getMerchantID() {
        return this.merchantID;
    }

    public String getKeysDirectory() {
        return this.keysDirectory;
    }

    public String getKeyAlias() {
        if (this.keyAlias != null) {
            return this.keyAlias;
        }
        return this.getMerchantID();
    }

    public String getKeyPassword() {
        if (this.keyPassword != null) {
            return this.keyPassword;
        }
        return this.getMerchantID();
    }

    public boolean getSendToProduction() {
        return this.sendToProduction;
    }

    public boolean getSendToAkamai() {
        return this.sendToAkamai;
    }

    public String getTargetAPIVersion() {
        return this.targetAPIVersion;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getEnableLog() {
        return this.enableLog;
    }

    public boolean getLogSignedData() {
        return this.logSignedData;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public int getLogMaximumSize() {
        return this.logMaximumSize;
    }

    public boolean retryIfMTIFieldExistEnabled() {
        return this.retryIfMTIFieldExist;
    }

    public boolean getUseHttpClient() {
        return this.useHttpClient;
    }

    public boolean getUseHttpClientWithConnectionPool() {
        return this.useHttpClientWithConnectionPool;
    }

    @Deprecated
    public int getTimeout() {
        return this.timeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getDefaultMaxConnectionsPerRoute() {
        return this.defaultMaxConnectionsPerRoute;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public int getConnectionRequestTimeoutMs() {
        return this.connectionRequestTimeoutMs;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public int getEvictThreadSleepTimeMs() {
        return this.evictThreadSleepTimeMs;
    }

    public int getMaxKeepAliveTimeMs() {
        return this.maxKeepAliveTimeMs;
    }

    public int getValidateAfterInactivityMs() {
        return this.validateAfterInactivityMs;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword != null ? this.proxyPassword : "";
    }

    public boolean isCertificateCacheEnabled() {
        return this.certificateCacheEnabled;
    }

    public boolean isMerchantConfigCacheEnabled() {
        return this.merchantConfigCacheEnabled;
    }

    public boolean isStaleConnectionCheckEnabled() {
        return this.staleConnectionCheckEnabled;
    }

    public boolean isShutdownHookEnabled() {
        return this.shutdownHookEnabled;
    }

    public String getEffectiveServerURL() {
        return this.effectiveServerURL;
    }

    public String getEffectiveNamespaceURI() {
        return this.effectiveNamespaceURI;
    }

    public String getEffectivePassword() {
        return this.effectivePassword;
    }

    public File getKeyFile() throws ConfigException {
        File file = StringUtils.isBlank((CharSequence)this.keyFilename) ? new File(this.keysDirectory, this.merchantID + ".p12") : new File(this.keysDirectory, this.keyFilename);
        String fullPath = file.getAbsolutePath();
        if (!file.isFile()) {
            throw new ConfigException("The file \"" + fullPath + "\" is missing or is not a file.");
        }
        if (!file.canRead()) {
            throw new ConfigException("This application does not have permission to read the file \"" + fullPath + "\".");
        }
        return file;
    }

    public File getLogFile() throws ConfigException {
        File dir = new File(this.logDirectory);
        String fullPath = dir.getAbsolutePath();
        if (!dir.isDirectory()) {
            throw new ConfigException("The log directory \"" + fullPath + "\" is missing or is not a directory.");
        }
        return new File(this.logDirectory, this.logFilename != null ? this.logFilename : "cybs.log");
    }

    public String getProperty(String merchantID, String prop) {
        return this.getProperty(merchantID, prop, null);
    }

    public String getProperty(String merchantID, String prop, String defaultVal) {
        String merchantSpecificProp;
        String val = null;
        String string = merchantSpecificProp = merchantID != null ? merchantID + "." + prop : null;
        if (this.props != null && merchantSpecificProp != null) {
            val = this.props.getProperty(merchantSpecificProp);
        }
        if (this.props != null && val == null) {
            val = this.props.getProperty(prop);
        }
        if (val == null && merchantSpecificProp != null) {
            val = System.getProperty("cybs." + merchantSpecificProp);
        }
        if (val == null) {
            val = System.getProperty("cybs." + prop);
        }
        if (val == null) {
            val = defaultVal;
        }
        return val;
    }

    public String getLogString() {
        StringBuffer sb = new StringBuffer();
        MerchantConfig.appendPair(sb, "merchantID", this.merchantID);
        MerchantConfig.appendPair(sb, "keysDirectory", this.keysDirectory);
        MerchantConfig.appendPair(sb, "keyAlias", this.keyAlias);
        MerchantConfig.appendPair(sb, "keyPassword", this.keyPassword != null ? "(masked)" : null);
        MerchantConfig.appendPair(sb, "sendToProduction", this.sendToProduction);
        MerchantConfig.appendPair(sb, "sendToAkamai", this.sendToAkamai);
        MerchantConfig.appendPair(sb, "targetAPIVersion", this.targetAPIVersion);
        MerchantConfig.appendPair(sb, "keyFilename", this.keyFilename);
        MerchantConfig.appendPair(sb, "serverURL", this.serverURL);
        MerchantConfig.appendPair(sb, "namespaceURI", this.namespaceURI);
        MerchantConfig.appendPair(sb, "enableLog", this.enableLog);
        MerchantConfig.appendPair(sb, "logDirectory", this.logDirectory);
        MerchantConfig.appendPair(sb, "logFilename", this.logFilename);
        MerchantConfig.appendPair(sb, "logMaximumSize", this.logMaximumSize);
        MerchantConfig.appendPair(sb, "customHttpClass", this.customHttpClass);
        MerchantConfig.appendPair(sb, "customHttpClassEnabled", this.customHttpClassEnabled);
        MerchantConfig.appendPair(sb, "useHttpClient", this.useHttpClient);
        MerchantConfig.appendPair(sb, "useHttpClientWithConnectionPool", this.useHttpClientWithConnectionPool);
        MerchantConfig.appendPair(sb, "enableJdkCert", this.enableJdkCert);
        MerchantConfig.appendPair(sb, "enableCacert", this.enableCacert);
        if (this.useHttpClient || this.useHttpClientWithConnectionPool) {
            MerchantConfig.appendPair(sb, "allowRetry", this.allowRetry);
            MerchantConfig.appendPair(sb, "retryCount", this.numberOfRetries);
            this.appendPair(sb, "retryInterval", this.retryInterval);
        }
        if (this.useHttpClientWithConnectionPool) {
            MerchantConfig.appendPair(sb, "maxConnections", this.maxConnections);
            MerchantConfig.appendPair(sb, "defaultMaxConnectionsPerRoute", this.defaultMaxConnectionsPerRoute);
            MerchantConfig.appendPair(sb, "maxConnectionsPerRoute", this.maxConnectionsPerRoute);
            MerchantConfig.appendPair(sb, "connectionRequestTimeoutMs", this.connectionRequestTimeoutMs);
            MerchantConfig.appendPair(sb, "connectionTimeoutMs", this.connectionTimeoutMs);
            MerchantConfig.appendPair(sb, "maxKeepAliveTimeMs", this.maxKeepAliveTimeMs);
            MerchantConfig.appendPair(sb, "validateAfterInactivityMs", this.validateAfterInactivityMs);
            MerchantConfig.appendPair(sb, "staleConnectionCheckEnabled", this.staleConnectionCheckEnabled);
            MerchantConfig.appendPair(sb, "enabledShutdownHook", this.shutdownHookEnabled);
            MerchantConfig.appendPair(sb, "retryIfMTIFieldExist", this.retryIfMTIFieldExist);
        }
        MerchantConfig.appendPair(sb, "timeout", this.timeout);
        MerchantConfig.appendPair(sb, "socketTimeoutMs", this.socketTimeoutMs);
        MerchantConfig.appendPair(sb, "evictThreadSleepTimeMs", this.evictThreadSleepTimeMs);
        if (this.proxyHost != null) {
            MerchantConfig.appendPair(sb, "proxyHost", this.proxyHost);
            MerchantConfig.appendPair(sb, "proxyPort", this.proxyPort);
            if (this.proxyUser != null) {
                MerchantConfig.appendPair(sb, "proxyUser", this.proxyUser);
                MerchantConfig.appendPair(sb, "proxyPassword", this.proxyPassword != null ? "(masked)" : null);
            }
        }
        MerchantConfig.appendPair(sb, "useSignAndEncrypted", this.useSignAndEncrypted);
        MerchantConfig.appendPair(sb, "certificateCacheEnabled", this.certificateCacheEnabled);
        MerchantConfig.appendPair(sb, "merchantConfigCacheEnabled", this.merchantConfigCacheEnabled);
        return sb.toString();
    }

    private void appendPair(StringBuffer sb, String key, long retryInterval2) {
        MerchantConfig.appendPair(sb, key, String.valueOf(retryInterval2));
    }

    private static void appendPair(StringBuffer sb, String key, boolean value) {
        MerchantConfig.appendPair(sb, key, String.valueOf(value));
    }

    private static void appendPair(StringBuffer sb, String key, int value) {
        MerchantConfig.appendPair(sb, key, String.valueOf(value));
    }

    private static void appendPair(StringBuffer sb, String key, String value) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(key + "=");
        sb.append(value != null ? value : "(null)");
    }

    private boolean getBooleanProperty(String merchantID, String prop, boolean defaultVal) throws ConfigException {
        String strValue = this.getProperty(merchantID, prop);
        if (strValue == null) {
            return defaultVal;
        }
        if ("1".equals(strValue) || "true".equalsIgnoreCase(strValue)) {
            return true;
        }
        if ("0".equals(strValue) || "false".equalsIgnoreCase(strValue)) {
            return false;
        }
        throw new ConfigException(prop + " has an invalid value.");
    }

    private int getIntegerProperty(String merchantID, String prop, int defaultVal) throws ConfigException {
        String strValue = this.getProperty(merchantID, prop);
        if (strValue == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigException(prop + " has an invalid value.", nfe);
        }
    }

    private int getIntegerProperty(String merchantID, String prop) throws ConfigException {
        String strValue = this.getProperty(merchantID, prop);
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigException(prop + " has an invalid value.", nfe);
        }
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public boolean isAllowRetry() {
        return this.allowRetry;
    }

    public void setAllowRetry(boolean allowRetry) {
        this.allowRetry = allowRetry;
    }

    public boolean isCacertEnabled() {
        return this.enableCacert;
    }

    public boolean isJdkCertEnabled() {
        return this.enableJdkCert;
    }

    public String getCacertPassword() {
        return this.cacertPassword;
    }

    public String getCustomHttpClass() {
        return this.customHttpClass;
    }

    public boolean isCustomHttpClassEnabled() {
        return this.customHttpClassEnabled;
    }
}

