/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.MerchantConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoggerImpl
implements Logger {
    private static final int MB = 0x100000;
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private final MerchantConfig mc;

    public LoggerImpl(MerchantConfig _mc) {
        this.mc = _mc;
    }

    @Override
    public synchronized void prepare() throws ConfigException {
        File file = this.mc.getLogFile();
        long size = file.length();
        if (size > (long)(this.mc.getLogMaximumSize() * 0x100000)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
            String newName = file.getAbsolutePath() + "." + sdf.format(new Date());
            File newFile = new File(newName);
            file.renameTo(newFile);
        } else if (size > 0L) {
            return;
        }
        this.log("FILESTART", "CYBERSOURCE LOG FILE");
    }

    @Override
    public synchronized void logTransactionStart() {
        this.log("TRANSTART", "=======================================");
        this.log("MERCHCFG ", this.mc.getLogString());
        String proxyCfg = LoggerImpl.getProxyConfig();
        if (proxyCfg != null) {
            this.log("PROXYCFG ", proxyCfg);
        }
    }

    @Override
    public synchronized void log(String type, String text) {
        if (text == null) {
            text = "(null)";
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.mc.getLogFile().getAbsolutePath(), true);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd' 'HH':'mm':'ss'.'SSS");
            Object[] arguments = new Object[]{"TRANSTART".equalsIgnoreCase(type) ? NEWLINE : "", sdf.format(new Date()), Thread.currentThread().getName(), type};
            String intro = MessageFormat.format("{0}{1} {2} {3}> ", arguments);
            byte[] introBytes = LoggerImpl.getBytes(intro);
            fos.write(introBytes);
            byte[] newlineBytes = LoggerImpl.getBytes(NEWLINE);
            if (text.indexOf(NEWLINE) >= 0) {
                fos.write(newlineBytes);
            }
            byte[] textBytes = LoggerImpl.getBytes(text);
            fos.write(textBytes);
            fos.write(newlineBytes);
            fos.close();
        }
        catch (IOException ioe) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    private static byte[] getBytes(String str) throws UnsupportedEncodingException {
        return str.getBytes("UTF-8");
    }

    private static String getProxyConfig() {
        if (System.getProperty("https.proxyHost") != null) {
            StringBuffer sb = new StringBuffer();
            LoggerImpl.appendPair(sb, "https.proxyHost");
            LoggerImpl.appendPair(sb, "https.proxyPort");
            LoggerImpl.appendPair(sb, "https.proxyUser");
            LoggerImpl.appendPair(sb, "https.proxyPassword");
            return sb.toString();
        }
        return null;
    }

    private static void appendPair(StringBuffer sb, String sysProp) {
        String propValue = System.getProperty(sysProp);
        if ("https.proxyPassword".equalsIgnoreCase(sysProp) && propValue != null && propValue.length() > 0) {
            propValue = "(hidden)";
        }
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(sysProp + "=");
        sb.append(propValue != null ? propValue : "(null)");
    }
}

