/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class IdleConnectionMonitorThread
extends Thread {
    private final HttpClientConnectionManager connMgr;
    private volatile boolean shutdown;
    private long sleepTime;
    private long idleTime;

    public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr, long sleepTime, long idleTime) {
        this.connMgr = connMgr;
        this.sleepTime = sleepTime;
        this.idleTime = idleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    long idleTime = this.getIdleTime();
                    this.wait(this.getSleepTime());
                    PoolingHttpClientConnectionManager poolConnMgr = (PoolingHttpClientConnectionManager)this.connMgr;
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(idleTime, TimeUnit.MILLISECONDS);
                }
            }
            return;
        }
        catch (InterruptedException ex) {
            this.shutdown();
        }
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        IdleConnectionMonitorThread idleConnectionMonitorThread = this;
        synchronized (idleConnectionMonitorThread) {
            this.notifyAll();
        }
    }
}

