/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.SignException;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Identity {
    private String name;
    private String keyAlias;
    private String serialNumber;
    private X509Certificate x509Cert;
    private PrivateKey privateKey;
    private MerchantConfig merchantConfig;
    private long lastModifiedDate;
    private char[] pswd;

    public Identity(MerchantConfig merchantConfig, X509Certificate x509Certificate) throws SignException {
        this.merchantConfig = merchantConfig;
        this.x509Cert = x509Certificate;
        if (merchantConfig.isJdkCertEnabled() || merchantConfig.isCacertEnabled()) {
            this.setupJdkServerCerts();
        } else {
            this.setUpServer();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupJdkServerCerts() throws SignException {
        if (this.x509Cert == null) return;
        String subjectDN = this.x509Cert.getSubjectDN().getName();
        if (subjectDN == null) throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
        String[] subjectDNArray = subjectDN.split("SERIALNUMBER=");
        if (subjectDNArray.length == 1 && subjectDNArray[0].toLowerCase().contains("CyberSourceCertAuth".toLowerCase())) {
            this.name = this.keyAlias = subjectDNArray[0].split("=")[1];
            return;
        } else {
            if (subjectDNArray.length != 2 || !subjectDNArray[1].toLowerCase().contains("CyberSource_SJC_US".toLowerCase())) throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
            this.name = subjectDNArray[1].split("=")[1];
            this.serialNumber = subjectDNArray[1].split(",")[0];
            this.keyAlias = "serialNumber=" + this.serialNumber + ",CN=" + this.name;
        }
    }

    public Identity(MerchantConfig merchantConfig, X509Certificate x509Certificate, PrivateKey privateKey, Logger logger) throws SignException {
        this.merchantConfig = merchantConfig;
        this.x509Cert = x509Certificate;
        this.privateKey = privateKey;
        try {
            this.lastModifiedDate = merchantConfig.getKeyFile().lastModified();
        }
        catch (ConfigException e) {
            logger.log("EXCEPTION", "Identity object ,cannot instantiate with key file lastModifiedDate. " + e.getMessage());
            throw new SignException("Exception While initializing the merchant identity constructor with keyfile last modified date" + e.getMessage());
        }
        this.setUpMerchant();
    }

    public boolean isValid(File keyFile, Logger logger) {
        boolean changeKeyFileStatus;
        boolean bl = changeKeyFileStatus = this.lastModifiedDate == keyFile.lastModified();
        if (!changeKeyFileStatus) {
            logger.log("INFO     ", "Key file changed");
            logger.log("INFO     ", "Timestamp of current key file:" + keyFile.lastModified());
        }
        return changeKeyFileStatus;
    }

    private void setUpMerchant() throws SignException {
        if (this.serialNumber == null && this.x509Cert != null) {
            String subjectDN = this.x509Cert.getSubjectDN().getName();
            if (subjectDN != null) {
                String[] subjectDNrray = subjectDN.split("SERIALNUMBER=");
                if (subjectDNrray.length != 2) {
                    throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
                }
                this.name = this.merchantConfig.getMerchantID();
                this.pswd = this.merchantConfig.getKeyPassword().toCharArray();
                this.serialNumber = subjectDNrray[1];
                this.keyAlias = this.merchantConfig.getKeyAlias();
            } else {
                throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setUpServer() throws SignException {
        if (this.serialNumber != null || this.x509Cert == null) return;
        String subjectDN = this.x509Cert.getSubjectDN().getName();
        if (subjectDN == null) throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
        String[] subjectDNArray = subjectDN.split("SERIALNUMBER=");
        if (subjectDNArray.length == 1 && subjectDNArray[0].toLowerCase().contains("CyberSourceCertAuth".toLowerCase())) {
            this.name = this.keyAlias = subjectDNArray[0].split("=")[1];
            return;
        } else {
            if (subjectDNArray.length != 2 || !subjectDNArray[0].toLowerCase().contains("CyberSource_SJC_US".toLowerCase())) throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
            String subjectDName = subjectDNArray[0].split("=")[1];
            this.name = subjectDName.substring(0, subjectDName.length() - 1);
            this.serialNumber = subjectDNArray[1];
            this.keyAlias = "serialNumber=" + this.serialNumber + ",CN=" + this.name;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public char[] getPswd() {
        return this.pswd;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public X509Certificate getX509Cert() {
        return this.x509Cert;
    }

    public void setX509Cert(X509Certificate x509Cert) {
        this.x509Cert = x509Cert;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String toString() {
        int certLen = 0;
        Date date = null;
        String expireStr = null;
        if (this.x509Cert != null) {
            try {
                certLen = this.x509Cert.getEncoded().length;
            }
            catch (CertificateEncodingException e) {
                certLen = 0;
            }
            date = this.x509Cert.getNotAfter();
        }
        this.serialNumber = this.getSerialNumber();
        int privateKeyLen = this.privateKey != null ? this.privateKey.getEncoded().length : 0;
        if (date != null) {
            TimeZone usPacificTimeZone = TimeZone.getTimeZone("America/Los_Angeles");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            formatter.setTimeZone(usPacificTimeZone);
            expireStr = formatter.format(date);
        }
        privateKeyLen = this.privateKey != null ? this.privateKey.getEncoded().length : 0;
        return "{" + this.getName() + ",privatekey=" + privateKeyLen + ",cert=" + certLen + ",serial=" + this.serialNumber + ",expiration=" + expireStr + " }";
    }
}

