/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.Connection;
import com.cybersource.ws.client.ConnectionHelper;
import com.cybersource.ws.client.LoggerWrapper;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.w3c.dom.Document;

public class HttpClientConnection
extends Connection {
    private HttpPost httpPost = null;
    private HttpClientContext httpContext = null;
    private CloseableHttpClient httpClient = null;
    private CloseableHttpResponse httpResponse = null;

    HttpClientConnection(MerchantConfig mc, DocumentBuilder builder, LoggerWrapper logger) {
        super(mc, builder, logger);
        this.initHttpClient(mc);
        logger.log("INFO     ", "Using HttpClient for connections.");
    }

    @Override
    void postDocument(Document request, long startTime) throws IOException, TransformerException {
        String serverURL = this.mc.getEffectiveServerURL();
        this.httpPost = new HttpPost(serverURL);
        String requestString = HttpClientConnection.documentToString(request);
        StringEntity stringEntity = new StringEntity(requestString, "UTF-8");
        this.httpPost.setEntity((HttpEntity)stringEntity);
        this.httpPost.setHeader("v-c-client-computetime", String.valueOf(System.currentTimeMillis() - startTime));
        this.httpPost.setHeader("v-c-client-iat", String.valueOf(System.currentTimeMillis()));
        this.logRequestHeaders();
        this.httpContext = HttpClientContext.create();
        this.logger.log("INFO     ", "Sending " + requestString.length() + " bytes to " + serverURL);
        this.httpResponse = this.httpClient.execute((HttpUriRequest)this.httpPost, (HttpContext)this.httpContext);
    }

    @Override
    public boolean isRequestSent() {
        return this.httpContext != null && this.httpContext.isRequestSent();
    }

    @Override
    public void release() {
        if (this.httpPost != null) {
            this.httpPost.releaseConnection();
            this.httpPost = null;
        }
    }

    @Override
    int getHttpResponseCode() {
        return this.httpResponse != null ? this.httpResponse.getStatusLine().getStatusCode() : -1;
    }

    @Override
    InputStream getResponseStream() throws IOException {
        return this.httpResponse != null ? this.httpResponse.getEntity().getContent() : null;
    }

    @Override
    InputStream getResponseErrorStream() throws IOException {
        return this.getResponseStream();
    }

    protected void initHttpClient(MerchantConfig mc) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setSocketTimeout(mc.getSocketTimeoutMs()).setConnectTimeout(mc.getConnectionTimeoutMs());
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (mc.isAllowRetry()) {
            httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new MyRetryHandler());
        }
        ConnectionHelper.setProxy(httpClientBuilder, requestConfigBuilder, mc);
        this.httpClient = httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build()).build();
    }

    private static String documentToString(Document doc) throws TransformerConfigurationException, TransformerException, IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = HttpClientConnection.makeStream(doc);
            String string = baos.toString("utf-8");
            return string;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
        }
    }

    @Override
    public void logRequestHeaders() {
        if (this.mc.getEnableLog() && this.httpPost != null) {
            List<Header> reqheaders = Arrays.asList(this.httpPost.getAllHeaders());
            this.logger.log("INFO     ", "Request Headers: " + reqheaders);
        }
    }

    @Override
    public void logResponseHeaders() {
        if (this.mc.getEnableLog() && this.httpResponse != null) {
            long resIAT;
            Header responseTimeHeader = this.httpResponse.getFirstHeader("v-c-response-time");
            if (responseTimeHeader != null && StringUtils.isNotBlank((CharSequence)responseTimeHeader.getValue()) && (resIAT = Utility.getResponseIssuedAtTime(responseTimeHeader.getValue())) > 0L) {
                this.logger.log("INFO     ", "responseTransitTimeSec : " + Utility.getResponseTransitTime(resIAT));
            }
            List<Header> respheaders = Arrays.asList(this.httpResponse.getAllHeaders());
            this.logger.log("INFO     ", "Response Headers" + respheaders);
        }
    }

    private class MyRetryHandler
    implements HttpRequestRetryHandler {
        long retryWaitInterval;
        int maxRetries;

        private MyRetryHandler() {
            this.retryWaitInterval = HttpClientConnection.this.mc.getRetryInterval();
            this.maxRetries = HttpClientConnection.this.mc.getNumberOfRetries();
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext httpContext) {
            if (executionCount > this.maxRetries) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return false;
            }
            HttpClientContext httpClientContext = HttpClientContext.adapt((HttpContext)httpContext);
            if (!httpClientContext.isRequestSent()) {
                try {
                    Thread.sleep(this.retryWaitInterval);
                    HttpClientConnection.this.logger.log("INFO     ", " Retrying Request -- " + HttpClientConnection.this.logger.getUniqueKey() + " Retry Count -- " + executionCount);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }
            return false;
        }
    }
}

