/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ClientException;
import com.cybersource.ws.client.FaultException;
import com.cybersource.ws.client.HttpClientConnection;
import com.cybersource.ws.client.JDKHttpURLConnection;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.LoggerWrapper;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.PoolingHttpClientConnection;
import com.cybersource.ws.client.Utility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class Connection {
    final MerchantConfig mc;
    private final DocumentBuilder builder;
    final LoggerWrapper logger;

    protected Connection(MerchantConfig mc, DocumentBuilder builder, LoggerWrapper logger) {
        this.mc = mc;
        this.builder = builder;
        this.logger = logger;
    }

    public static Connection getInstance(MerchantConfig mc, DocumentBuilder builder, LoggerWrapper logger) throws ClientException {
        if (mc.getUseHttpClientWithConnectionPool()) {
            return new PoolingHttpClientConnection(mc, builder, logger);
        }
        if (mc.getUseHttpClient()) {
            return new HttpClientConnection(mc, builder, logger);
        }
        return new JDKHttpURLConnection(mc, builder, logger);
    }

    public abstract boolean isRequestSent();

    public abstract void release() throws ClientException;

    abstract void postDocument(Document var1, long var2) throws IOException, TransformerConfigurationException, TransformerException, MalformedURLException, ProtocolException;

    abstract int getHttpResponseCode() throws IOException;

    abstract InputStream getResponseStream() throws IOException;

    abstract InputStream getResponseErrorStream() throws IOException;

    public Document post(Document request, long startTime) throws ClientException, FaultException {
        try {
            this.postDocument(request, startTime);
            this.checkForFault();
            return this.parseReceivedDocument();
        }
        catch (IOException e) {
            throw new ClientException(e, this.isRequestSent(), (Logger)this.logger);
        }
        catch (TransformerConfigurationException e) {
            throw new ClientException(e, this.isRequestSent(), (Logger)this.logger);
        }
        catch (TransformerException e) {
            throw new ClientException(e, this.isRequestSent(), (Logger)this.logger);
        }
        catch (SAXException e) {
            throw new ClientException(e, this.isRequestSent(), (Logger)this.logger);
        }
        catch (RuntimeException e) {
            throw new ClientException(e, this.isRequestSent(), (Logger)this.logger);
        }
    }

    private void checkForFault() throws FaultException, ClientException {
        try {
            byte[] errorBytes;
            this.logger.log("INFO     ", "waiting for response...");
            int responseCode = this.getHttpResponseCode();
            this.logResponseHeaders();
            if (responseCode == 200) {
                return;
            }
            InputStream errorStream = this.getResponseErrorStream();
            if (errorStream == null) {
                throw new ClientException(responseCode, (Logger)this.logger);
            }
            try {
                errorBytes = Utility.read(errorStream);
                errorStream.close();
            }
            catch (IOException ioe) {
                throw new ClientException(responseCode, "Failed to read additional HTTP error", true, this.logger);
            }
            if (responseCode == 500) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(errorBytes);
                    Document faultDoc = this.builder.parse(bais);
                    bais.close();
                    throw new FaultException(faultDoc, this.mc.getEffectiveNamespaceURI(), this.logger);
                }
                catch (IOException ioe) {
                    String text = new String(errorBytes);
                    throw new ClientException(responseCode, text, true, this.logger);
                }
                catch (SAXException ioe) {
                    String text = new String(errorBytes);
                    throw new ClientException(responseCode, text, (Logger)this.logger);
                }
            }
            String text = new String(errorBytes);
            throw new ClientException(responseCode, text, (Logger)this.logger);
        }
        catch (IOException e) {
            throw new ClientException(e, true, (Logger)this.logger);
        }
    }

    private Document parseReceivedDocument() throws IOException, SAXException {
        this.logger.log("INFO     ", "Parsing response...");
        Document document = this.builder.parse(this.getResponseStream());
        return document;
    }

    static ByteArrayOutputStream makeStream(Document doc) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(doc), new StreamResult(baos));
        return baos;
    }

    public abstract void logRequestHeaders();

    public abstract void logResponseHeaders();
}

