/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import java.util.Arrays;
import Model.TmsEmbeddedInstrumentIdentifierTokenizedCardCard;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * TmsEmbeddedInstrumentIdentifierTokenizedCard
 */

public class TmsEmbeddedInstrumentIdentifierTokenizedCard {
  @SerializedName("type")
  private String type = null;

  @SerializedName("source")
  private String source = null;

  @SerializedName("state")
  private String state = null;

  @SerializedName("enrollmentId")
  private String enrollmentId = null;

  @SerializedName("tokenReferenceId")
  private String tokenReferenceId = null;

  @SerializedName("reason")
  private String reason = null;

  @SerializedName("number")
  private String number = null;

  @SerializedName("expirationMonth")
  private String expirationMonth = null;

  @SerializedName("expirationYear")
  private String expirationYear = null;

  @SerializedName("cryptogram")
  private String cryptogram = null;

  @SerializedName("card")
  private TmsEmbeddedInstrumentIdentifierTokenizedCardCard card = null;

   /**
   * The network token card association brand Possible Values: - visa - mastercard - americanexpress 
   * @return type
  **/
  @ApiModelProperty(example = "visa", value = "The network token card association brand Possible Values: - visa - mastercard - americanexpress ")
  public String getType() {
    return type;
  }

   /**
   * This enumeration value indicates the origin of the payment instrument (PAN) and the technique employed to supply the payment instrument data. Possible Values: - TOKEN - ISSUER - ONFILE 
   * @return source
  **/
  @ApiModelProperty(example = "ONFILE", value = "This enumeration value indicates the origin of the payment instrument (PAN) and the technique employed to supply the payment instrument data. Possible Values: - TOKEN - ISSUER - ONFILE ")
  public String getSource() {
    return source;
  }

   /**
   * State of the network token or network token provision Possible Values: - ACTIVE : Network token is active. - SUSPENDED : Network token is suspended. This state can change back to ACTIVE. - DELETED : This is a final state for a network token instance. - UNPROVISIONED : A previous network token provision was unsuccessful. 
   * @return state
  **/
  @ApiModelProperty(example = "ACTIVE", value = "State of the network token or network token provision Possible Values: - ACTIVE : Network token is active. - SUSPENDED : Network token is suspended. This state can change back to ACTIVE. - DELETED : This is a final state for a network token instance. - UNPROVISIONED : A previous network token provision was unsuccessful. ")
  public String getState() {
    return state;
  }

   /**
   * Unique Identifier for the enrolled PAN. This Id is provided by the card association when a network token is provisioned successfully. 
   * @return enrollmentId
  **/
  @ApiModelProperty(value = "Unique Identifier for the enrolled PAN. This Id is provided by the card association when a network token is provisioned successfully. ")
  public String getEnrollmentId() {
    return enrollmentId;
  }

   /**
   * Unique Identifier for the network token. This Id is provided by the card association when a network token is provisioned successfully. 
   * @return tokenReferenceId
  **/
  @ApiModelProperty(value = "Unique Identifier for the network token. This Id is provided by the card association when a network token is provisioned successfully. ")
  public String getTokenReferenceId() {
    return tokenReferenceId;
  }

   /**
   * Issuers state for the network token Possible Values: - INVALID_REQUEST : The network token provision request contained invalid data. - CARD_VERIFICATION_FAILED : The network token provision request contained data that could not be verified. - CARD_NOT_ELIGIBLE : Card can currently not be used with issuer for tokenization. - CARD_NOT_ALLOWED : Card can currently not be used with card association for tokenization. - DECLINED : Card can currently not be used with issuer for tokenization. - SERVICE_UNAVAILABLE : The network token service was unavailable or timed out. - SYSTEM_ERROR : An unexpected error occurred with network token service, check configuration. 
   * @return reason
  **/
  @ApiModelProperty(example = "ACTIVE", value = "Issuers state for the network token Possible Values: - INVALID_REQUEST : The network token provision request contained invalid data. - CARD_VERIFICATION_FAILED : The network token provision request contained data that could not be verified. - CARD_NOT_ELIGIBLE : Card can currently not be used with issuer for tokenization. - CARD_NOT_ALLOWED : Card can currently not be used with card association for tokenization. - DECLINED : Card can currently not be used with issuer for tokenization. - SERVICE_UNAVAILABLE : The network token service was unavailable or timed out. - SYSTEM_ERROR : An unexpected error occurred with network token service, check configuration. ")
  public String getReason() {
    return reason;
  }

   /**
   * The token requestors network token 
   * @return number
  **/
  @ApiModelProperty(value = "The token requestors network token ")
  public String getNumber() {
    return number;
  }

   /**
   * Two-digit month in which the network token expires.  Format: &#x60;MM&#x60;.  Possible Values: &#x60;01&#x60; through &#x60;12&#x60;. 
   * @return expirationMonth
  **/
  @ApiModelProperty(value = "Two-digit month in which the network token expires.  Format: `MM`.  Possible Values: `01` through `12`. ")
  public String getExpirationMonth() {
    return expirationMonth;
  }

   /**
   * Four-digit year in which the network token expires.  Format: &#x60;YYYY&#x60;. 
   * @return expirationYear
  **/
  @ApiModelProperty(value = "Four-digit year in which the network token expires.  Format: `YYYY`. ")
  public String getExpirationYear() {
    return expirationYear;
  }

   /**
   * Generated value used in conjunction with the network token for making a payment. 
   * @return cryptogram
  **/
  @ApiModelProperty(example = "CgAFRFYFPTFOfg5rj2ais9wQAAAAAM=", value = "Generated value used in conjunction with the network token for making a payment. ")
  public String getCryptogram() {
    return cryptogram;
  }

  public TmsEmbeddedInstrumentIdentifierTokenizedCard card(TmsEmbeddedInstrumentIdentifierTokenizedCardCard card) {
    this.card = card;
    return this;
  }

   /**
   * Get card
   * @return card
  **/
  @ApiModelProperty(value = "")
  public TmsEmbeddedInstrumentIdentifierTokenizedCardCard getCard() {
    return card;
  }

  public void setCard(TmsEmbeddedInstrumentIdentifierTokenizedCardCard card) {
    this.card = card;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TmsEmbeddedInstrumentIdentifierTokenizedCard tmsEmbeddedInstrumentIdentifierTokenizedCard = (TmsEmbeddedInstrumentIdentifierTokenizedCard) o;
    return Objects.equals(this.type, tmsEmbeddedInstrumentIdentifierTokenizedCard.type) &&
        Objects.equals(this.source, tmsEmbeddedInstrumentIdentifierTokenizedCard.source) &&
        Objects.equals(this.state, tmsEmbeddedInstrumentIdentifierTokenizedCard.state) &&
        Objects.equals(this.enrollmentId, tmsEmbeddedInstrumentIdentifierTokenizedCard.enrollmentId) &&
        Objects.equals(this.tokenReferenceId, tmsEmbeddedInstrumentIdentifierTokenizedCard.tokenReferenceId) &&
        Objects.equals(this.reason, tmsEmbeddedInstrumentIdentifierTokenizedCard.reason) &&
        Objects.equals(this.number, tmsEmbeddedInstrumentIdentifierTokenizedCard.number) &&
        Objects.equals(this.expirationMonth, tmsEmbeddedInstrumentIdentifierTokenizedCard.expirationMonth) &&
        Objects.equals(this.expirationYear, tmsEmbeddedInstrumentIdentifierTokenizedCard.expirationYear) &&
        Objects.equals(this.cryptogram, tmsEmbeddedInstrumentIdentifierTokenizedCard.cryptogram) &&
        Objects.equals(this.card, tmsEmbeddedInstrumentIdentifierTokenizedCard.card);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, source, state, enrollmentId, tokenReferenceId, reason, number, expirationMonth, expirationYear, cryptogram, card);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TmsEmbeddedInstrumentIdentifierTokenizedCard {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    enrollmentId: ").append(toIndentedString(enrollmentId)).append("\n");
    sb.append("    tokenReferenceId: ").append(toIndentedString(tokenReferenceId)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    expirationMonth: ").append(toIndentedString(expirationMonth)).append("\n");
    sb.append("    expirationYear: ").append(toIndentedString(expirationYear)).append("\n");
    sb.append("    cryptogram: ").append(toIndentedString(cryptogram)).append("\n");
    sb.append("    card: ").append(toIndentedString(card)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

