/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import java.util.Arrays;
import Model.Ptsv2paymentsOrderInformationPassenger;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Riskv1authenticationsOrderInformationLineItems
 */

public class Riskv1authenticationsOrderInformationLineItems {
  @SerializedName("totalAmount")
  private String totalAmount = null;

  @SerializedName("unitPrice")
  private String unitPrice = null;

  @SerializedName("quantity")
  private Integer quantity = null;

  @SerializedName("giftCardCurrency")
  private Integer giftCardCurrency = null;

  @SerializedName("productSKU")
  private String productSKU = null;

  @SerializedName("productDescription")
  private String productDescription = null;

  @SerializedName("productName")
  private String productName = null;

  @SerializedName("passenger")
  private Ptsv2paymentsOrderInformationPassenger passenger = null;

  @SerializedName("shippingDestinationTypes")
  private String shippingDestinationTypes = null;

  @SerializedName("taxAmount")
  private String taxAmount = null;

  @SerializedName("shippingAddress1")
  private String shippingAddress1 = null;

  @SerializedName("shippingAddress2")
  private String shippingAddress2 = null;

  @SerializedName("shippingCity")
  private String shippingCity = null;

  @SerializedName("shippingCountryCode")
  private String shippingCountryCode = null;

  @SerializedName("shippingFirstName")
  private String shippingFirstName = null;

  @SerializedName("shippingLastName")
  private String shippingLastName = null;

  @SerializedName("shippingMiddleName")
  private String shippingMiddleName = null;

  @SerializedName("shippingPhone")
  private Integer shippingPhone = null;

  @SerializedName("shippingPostalCode")
  private Integer shippingPostalCode = null;

  @SerializedName("shippingState")
  private String shippingState = null;

  public Riskv1authenticationsOrderInformationLineItems totalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * Total amount for the item. Normally calculated as the unit price times quantity.  When &#x60;orderInformation.lineItems[].productCode&#x60; is \&quot;gift_card\&quot;, this is the purchase amount total for prepaid gift cards in major units.  Example: 123.45 USD &#x3D; 123 
   * @return totalAmount
  **/
  @ApiModelProperty(value = "Total amount for the item. Normally calculated as the unit price times quantity.  When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the purchase amount total for prepaid gift cards in major units.  Example: 123.45 USD = 123 ")
  public String getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
  }

  public Riskv1authenticationsOrderInformationLineItems unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * Per-item price of the product. This value for this field cannot be negative.  You must include either this field or the request-level field &#x60;orderInformation.amountDetails.totalAmount&#x60; in your request.  You can include a decimal point (.), but you cannot include any other special characters. The value is truncated to the correct number of decimal places.  #### DCC with a Third-Party Provider Set this field to the converted amount that was returned by the DCC provider. You must include either the 1st line item in the order and this field, or the request-level field &#x60;orderInformation.amountDetails.totalAmount&#x60; in your request.  #### FDMS South If you accept IDR or CLP currencies, see the entry for FDMS South in the [Merchant Descriptors Using the SCMP API Guide.] (https://apps.cybersource.com/library/documentation/dev_guides/Merchant_Descriptors_SCMP_API/html/)  #### Tax Calculation Required field for U.S., Canadian, international and value added taxes.  #### Zero Amount Authorizations If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen.  #### Maximum Field Lengths For GPN and JCN Gateway: Decimal (10) All other processors: Decimal (15) 
   * @return unitPrice
  **/
  @ApiModelProperty(required = true, value = "Per-item price of the product. This value for this field cannot be negative.  You must include either this field or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  You can include a decimal point (.), but you cannot include any other special characters. The value is truncated to the correct number of decimal places.  #### DCC with a Third-Party Provider Set this field to the converted amount that was returned by the DCC provider. You must include either the 1st line item in the order and this field, or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  #### FDMS South If you accept IDR or CLP currencies, see the entry for FDMS South in the [Merchant Descriptors Using the SCMP API Guide.] (https://apps.cybersource.com/library/documentation/dev_guides/Merchant_Descriptors_SCMP_API/html/)  #### Tax Calculation Required field for U.S., Canadian, international and value added taxes.  #### Zero Amount Authorizations If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen.  #### Maximum Field Lengths For GPN and JCN Gateway: Decimal (10) All other processors: Decimal (15) ")
  public String getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  public Riskv1authenticationsOrderInformationLineItems quantity(Integer quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * Number of units for this order. Must be a non-negative integer.  The default is &#x60;1&#x60;. For an authorization or capture transaction (&#x60;processingOptions.capture&#x60; is set to &#x60;true&#x60; or &#x60;false&#x60;), this field is required when &#x60;orderInformation.lineItems[].productCode&#x60; is not &#x60;default&#x60; or one of the other values related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. 
   * minimum: 1
   * maximum: 999999999
   * @return quantity
  **/
  @ApiModelProperty(value = "Number of units for this order. Must be a non-negative integer.  The default is `1`. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. ")
  public Integer getQuantity() {
    return quantity;
  }

  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }

  public Riskv1authenticationsOrderInformationLineItems giftCardCurrency(Integer giftCardCurrency) {
    this.giftCardCurrency = giftCardCurrency;
    return this;
  }

   /**
   * When &#x60;orderInformation.lineItems[].productCode&#x60; is \&quot;gift_card\&quot;, this is the currency used for the gift card purchase.  For details, see &#x60;pa_gift_card_currency&#x60; field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/Payer_Authentication_SCMP_API.pdf)  For the possible values, see the [ISO Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf) 
   * @return giftCardCurrency
  **/
  @ApiModelProperty(value = "When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the currency used for the gift card purchase.  For details, see `pa_gift_card_currency` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/Payer_Authentication_SCMP_API.pdf)  For the possible values, see the [ISO Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf) ")
  public Integer getGiftCardCurrency() {
    return giftCardCurrency;
  }

  public void setGiftCardCurrency(Integer giftCardCurrency) {
    this.giftCardCurrency = giftCardCurrency;
  }

  public Riskv1authenticationsOrderInformationLineItems productSKU(String productSKU) {
    this.productSKU = productSKU;
    return this;
  }

   /**
   * Product identifier code. Also known as the Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (&#x60;processingOptions.capture&#x60; is set to &#x60;true&#x60; or &#x60;false&#x60;), this field is required when &#x60;orderInformation.lineItems[].productCode&#x60; is not set to **default** or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S. and Canadian taxes. Not applicable to international and value added taxes. For an authorization or capture transaction (&#x60;processingOptions.capture&#x60; is set to &#x60;true&#x60; or &#x60;false&#x60;), this field is required when &#x60;orderInformation.lineItems[].productCode&#x60; is not &#x60;default&#x60; or one of the values related to shipping and/or handling. 
   * @return productSKU
  **/
  @ApiModelProperty(value = "Product identifier code. Also known as the Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to **default** or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S. and Canadian taxes. Not applicable to international and value added taxes. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the values related to shipping and/or handling. ")
  public String getProductSKU() {
    return productSKU;
  }

  public void setProductSKU(String productSKU) {
    this.productSKU = productSKU;
  }

  public Riskv1authenticationsOrderInformationLineItems productDescription(String productDescription) {
    this.productDescription = productDescription;
    return this;
  }

   /**
   * Brief description of item.
   * @return productDescription
  **/
  @ApiModelProperty(value = "Brief description of item.")
  public String getProductDescription() {
    return productDescription;
  }

  public void setProductDescription(String productDescription) {
    this.productDescription = productDescription;
  }

  public Riskv1authenticationsOrderInformationLineItems productName(String productName) {
    this.productName = productName;
    return this;
  }

   /**
   * For an authorization or capture transaction (&#x60;processingOptions.capture&#x60; is &#x60;true&#x60; or &#x60;false&#x60;), this field is required when &#x60;orderInformation.lineItems[].productCode&#x60; is not &#x60;default&#x60; or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. 
   * @return productName
  **/
  @ApiModelProperty(value = "For an authorization or capture transaction (`processingOptions.capture` is `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. ")
  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public Riskv1authenticationsOrderInformationLineItems passenger(Ptsv2paymentsOrderInformationPassenger passenger) {
    this.passenger = passenger;
    return this;
  }

   /**
   * Get passenger
   * @return passenger
  **/
  @ApiModelProperty(value = "")
  public Ptsv2paymentsOrderInformationPassenger getPassenger() {
    return passenger;
  }

  public void setPassenger(Ptsv2paymentsOrderInformationPassenger passenger) {
    this.passenger = passenger;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingDestinationTypes(String shippingDestinationTypes) {
    this.shippingDestinationTypes = shippingDestinationTypes;
    return this;
  }

   /**
   * Destination to where the item will be shipped. Example: Commercial, Residential, Store 
   * @return shippingDestinationTypes
  **/
  @ApiModelProperty(value = "Destination to where the item will be shipped. Example: Commercial, Residential, Store ")
  public String getShippingDestinationTypes() {
    return shippingDestinationTypes;
  }

  public void setShippingDestinationTypes(String shippingDestinationTypes) {
    this.shippingDestinationTypes = shippingDestinationTypes;
  }

  public Riskv1authenticationsOrderInformationLineItems taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * Total tax to apply to the product. This value cannot be negative. The tax amount and the offer amount must be in the same currency. The tax amount field is additive.  The following example uses a two-exponent currency such as USD:   1. You include each line item in your request.  ..- 1st line item has amount&#x3D;10.00, quantity&#x3D;1, and taxAmount&#x3D;0.80  ..- 2nd line item has amount&#x3D;20.00, quantity&#x3D;1, and taxAmount&#x3D;1.60  2. The total amount authorized will be 32.40, not 30.00 with 2.40 of tax included.  Optional field.  #### Airlines processing Tax portion of the order amount. This value cannot exceed 99999999999999 (fourteen 9s). Format: English characters only. Optional request field for a line item.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  Note if you send this field in your tax request, the value in the field will override the tax engine 
   * @return taxAmount
  **/
  @ApiModelProperty(value = "Total tax to apply to the product. This value cannot be negative. The tax amount and the offer amount must be in the same currency. The tax amount field is additive.  The following example uses a two-exponent currency such as USD:   1. You include each line item in your request.  ..- 1st line item has amount=10.00, quantity=1, and taxAmount=0.80  ..- 2nd line item has amount=20.00, quantity=1, and taxAmount=1.60  2. The total amount authorized will be 32.40, not 30.00 with 2.40 of tax included.  Optional field.  #### Airlines processing Tax portion of the order amount. This value cannot exceed 99999999999999 (fourteen 9s). Format: English characters only. Optional request field for a line item.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  Note if you send this field in your tax request, the value in the field will override the tax engine ")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingAddress1(String shippingAddress1) {
    this.shippingAddress1 = shippingAddress1;
    return this;
  }

   /**
   * Address where item will be shipped
   * @return shippingAddress1
  **/
  @ApiModelProperty(value = "Address where item will be shipped")
  public String getShippingAddress1() {
    return shippingAddress1;
  }

  public void setShippingAddress1(String shippingAddress1) {
    this.shippingAddress1 = shippingAddress1;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingAddress2(String shippingAddress2) {
    this.shippingAddress2 = shippingAddress2;
    return this;
  }

   /**
   * Address where item will be shipped
   * @return shippingAddress2
  **/
  @ApiModelProperty(value = "Address where item will be shipped")
  public String getShippingAddress2() {
    return shippingAddress2;
  }

  public void setShippingAddress2(String shippingAddress2) {
    this.shippingAddress2 = shippingAddress2;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingCity(String shippingCity) {
    this.shippingCity = shippingCity;
    return this;
  }

   /**
   * City where item will be shipped
   * @return shippingCity
  **/
  @ApiModelProperty(value = "City where item will be shipped")
  public String getShippingCity() {
    return shippingCity;
  }

  public void setShippingCity(String shippingCity) {
    this.shippingCity = shippingCity;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingCountryCode(String shippingCountryCode) {
    this.shippingCountryCode = shippingCountryCode;
    return this;
  }

   /**
   * Country where item will be shipped
   * @return shippingCountryCode
  **/
  @ApiModelProperty(value = "Country where item will be shipped")
  public String getShippingCountryCode() {
    return shippingCountryCode;
  }

  public void setShippingCountryCode(String shippingCountryCode) {
    this.shippingCountryCode = shippingCountryCode;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingFirstName(String shippingFirstName) {
    this.shippingFirstName = shippingFirstName;
    return this;
  }

   /**
   * Customer&#39;s first name
   * @return shippingFirstName
  **/
  @ApiModelProperty(value = "Customer's first name")
  public String getShippingFirstName() {
    return shippingFirstName;
  }

  public void setShippingFirstName(String shippingFirstName) {
    this.shippingFirstName = shippingFirstName;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingLastName(String shippingLastName) {
    this.shippingLastName = shippingLastName;
    return this;
  }

   /**
   * Customer&#39;s last name
   * @return shippingLastName
  **/
  @ApiModelProperty(value = "Customer's last name")
  public String getShippingLastName() {
    return shippingLastName;
  }

  public void setShippingLastName(String shippingLastName) {
    this.shippingLastName = shippingLastName;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingMiddleName(String shippingMiddleName) {
    this.shippingMiddleName = shippingMiddleName;
    return this;
  }

   /**
   * Customer&#39;s middle name
   * @return shippingMiddleName
  **/
  @ApiModelProperty(value = "Customer's middle name")
  public String getShippingMiddleName() {
    return shippingMiddleName;
  }

  public void setShippingMiddleName(String shippingMiddleName) {
    this.shippingMiddleName = shippingMiddleName;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingPhone(Integer shippingPhone) {
    this.shippingPhone = shippingPhone;
    return this;
  }

   /**
   * Phone number where item will be shipped
   * @return shippingPhone
  **/
  @ApiModelProperty(value = "Phone number where item will be shipped")
  public Integer getShippingPhone() {
    return shippingPhone;
  }

  public void setShippingPhone(Integer shippingPhone) {
    this.shippingPhone = shippingPhone;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingPostalCode(Integer shippingPostalCode) {
    this.shippingPostalCode = shippingPostalCode;
    return this;
  }

   /**
   * Postal code where item will be shipped
   * @return shippingPostalCode
  **/
  @ApiModelProperty(value = "Postal code where item will be shipped")
  public Integer getShippingPostalCode() {
    return shippingPostalCode;
  }

  public void setShippingPostalCode(Integer shippingPostalCode) {
    this.shippingPostalCode = shippingPostalCode;
  }

  public Riskv1authenticationsOrderInformationLineItems shippingState(String shippingState) {
    this.shippingState = shippingState;
    return this;
  }

   /**
   * State where item will be shipped
   * @return shippingState
  **/
  @ApiModelProperty(value = "State where item will be shipped")
  public String getShippingState() {
    return shippingState;
  }

  public void setShippingState(String shippingState) {
    this.shippingState = shippingState;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Riskv1authenticationsOrderInformationLineItems riskv1authenticationsOrderInformationLineItems = (Riskv1authenticationsOrderInformationLineItems) o;
    return Objects.equals(this.totalAmount, riskv1authenticationsOrderInformationLineItems.totalAmount) &&
        Objects.equals(this.unitPrice, riskv1authenticationsOrderInformationLineItems.unitPrice) &&
        Objects.equals(this.quantity, riskv1authenticationsOrderInformationLineItems.quantity) &&
        Objects.equals(this.giftCardCurrency, riskv1authenticationsOrderInformationLineItems.giftCardCurrency) &&
        Objects.equals(this.productSKU, riskv1authenticationsOrderInformationLineItems.productSKU) &&
        Objects.equals(this.productDescription, riskv1authenticationsOrderInformationLineItems.productDescription) &&
        Objects.equals(this.productName, riskv1authenticationsOrderInformationLineItems.productName) &&
        Objects.equals(this.passenger, riskv1authenticationsOrderInformationLineItems.passenger) &&
        Objects.equals(this.shippingDestinationTypes, riskv1authenticationsOrderInformationLineItems.shippingDestinationTypes) &&
        Objects.equals(this.taxAmount, riskv1authenticationsOrderInformationLineItems.taxAmount) &&
        Objects.equals(this.shippingAddress1, riskv1authenticationsOrderInformationLineItems.shippingAddress1) &&
        Objects.equals(this.shippingAddress2, riskv1authenticationsOrderInformationLineItems.shippingAddress2) &&
        Objects.equals(this.shippingCity, riskv1authenticationsOrderInformationLineItems.shippingCity) &&
        Objects.equals(this.shippingCountryCode, riskv1authenticationsOrderInformationLineItems.shippingCountryCode) &&
        Objects.equals(this.shippingFirstName, riskv1authenticationsOrderInformationLineItems.shippingFirstName) &&
        Objects.equals(this.shippingLastName, riskv1authenticationsOrderInformationLineItems.shippingLastName) &&
        Objects.equals(this.shippingMiddleName, riskv1authenticationsOrderInformationLineItems.shippingMiddleName) &&
        Objects.equals(this.shippingPhone, riskv1authenticationsOrderInformationLineItems.shippingPhone) &&
        Objects.equals(this.shippingPostalCode, riskv1authenticationsOrderInformationLineItems.shippingPostalCode) &&
        Objects.equals(this.shippingState, riskv1authenticationsOrderInformationLineItems.shippingState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalAmount, unitPrice, quantity, giftCardCurrency, productSKU, productDescription, productName, passenger, shippingDestinationTypes, taxAmount, shippingAddress1, shippingAddress2, shippingCity, shippingCountryCode, shippingFirstName, shippingLastName, shippingMiddleName, shippingPhone, shippingPostalCode, shippingState);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Riskv1authenticationsOrderInformationLineItems {\n");
    
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    giftCardCurrency: ").append(toIndentedString(giftCardCurrency)).append("\n");
    sb.append("    productSKU: ").append(toIndentedString(productSKU)).append("\n");
    sb.append("    productDescription: ").append(toIndentedString(productDescription)).append("\n");
    sb.append("    productName: ").append(toIndentedString(productName)).append("\n");
    sb.append("    passenger: ").append(toIndentedString(passenger)).append("\n");
    sb.append("    shippingDestinationTypes: ").append(toIndentedString(shippingDestinationTypes)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    shippingAddress1: ").append(toIndentedString(shippingAddress1)).append("\n");
    sb.append("    shippingAddress2: ").append(toIndentedString(shippingAddress2)).append("\n");
    sb.append("    shippingCity: ").append(toIndentedString(shippingCity)).append("\n");
    sb.append("    shippingCountryCode: ").append(toIndentedString(shippingCountryCode)).append("\n");
    sb.append("    shippingFirstName: ").append(toIndentedString(shippingFirstName)).append("\n");
    sb.append("    shippingLastName: ").append(toIndentedString(shippingLastName)).append("\n");
    sb.append("    shippingMiddleName: ").append(toIndentedString(shippingMiddleName)).append("\n");
    sb.append("    shippingPhone: ").append(toIndentedString(shippingPhone)).append("\n");
    sb.append("    shippingPostalCode: ").append(toIndentedString(shippingPostalCode)).append("\n");
    sb.append("    shippingState: ").append(toIndentedString(shippingState)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

