/*
 * Decompiled with CFR 0.152.
 */
package Model;

import Model.Microformv2sessionsCheckoutApiInitialization;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This is a server-to-server API request to generate the capture context that can be used to initiate instance of microform on a acceptance page.   The capture context is a digitally signed JWT that provides authentication, one-time keys, and the target origin to the Microform Integration application. ")
public class GenerateCaptureContextRequest {
    @SerializedName(value="targetOrigins")
    private List<String> targetOrigins = null;
    @SerializedName(value="allowedCardNetworks")
    private List<String> allowedCardNetworks = null;
    @SerializedName(value="clientVersion")
    private String clientVersion = null;
    @SerializedName(value="checkoutApiInitialization")
    private Microformv2sessionsCheckoutApiInitialization checkoutApiInitialization = null;

    public GenerateCaptureContextRequest targetOrigins(List<String> targetOrigins) {
        this.targetOrigins = targetOrigins;
        return this;
    }

    public GenerateCaptureContextRequest addTargetOriginsItem(String targetOriginsItem) {
        if (this.targetOrigins == null) {
            this.targetOrigins = new ArrayList<String>();
        }
        this.targetOrigins.add(targetOriginsItem);
        return this;
    }

    @ApiModelProperty(value="The merchant origin domain (e.g. https://example.com) used to initiate microform Integration. Required to comply with CORS and CSP standards.")
    public List<String> getTargetOrigins() {
        return this.targetOrigins;
    }

    public void setTargetOrigins(List<String> targetOrigins) {
        this.targetOrigins = targetOrigins;
    }

    public GenerateCaptureContextRequest allowedCardNetworks(List<String> allowedCardNetworks) {
        this.allowedCardNetworks = allowedCardNetworks;
        return this;
    }

    public GenerateCaptureContextRequest addAllowedCardNetworksItem(String allowedCardNetworksItem) {
        if (this.allowedCardNetworks == null) {
            this.allowedCardNetworks = new ArrayList<String>();
        }
        this.allowedCardNetworks.add(allowedCardNetworksItem);
        return this;
    }

    @ApiModelProperty(example="[\"VISA\",\"MAESTRO\",\"MASTERCARD\",\"AMEX\",\"DISCOVER\",\"DINERSCLUB\",\"JCB\",\"CUP\",\"CARTESBANCAIRES\"]", value="")
    public List<String> getAllowedCardNetworks() {
        return this.allowedCardNetworks;
    }

    public void setAllowedCardNetworks(List<String> allowedCardNetworks) {
        this.allowedCardNetworks = allowedCardNetworks;
    }

    public GenerateCaptureContextRequest clientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        return this;
    }

    @ApiModelProperty(example="v2.0", value="")
    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public GenerateCaptureContextRequest checkoutApiInitialization(Microformv2sessionsCheckoutApiInitialization checkoutApiInitialization) {
        this.checkoutApiInitialization = checkoutApiInitialization;
        return this;
    }

    @ApiModelProperty(value="")
    public Microformv2sessionsCheckoutApiInitialization getCheckoutApiInitialization() {
        return this.checkoutApiInitialization;
    }

    public void setCheckoutApiInitialization(Microformv2sessionsCheckoutApiInitialization checkoutApiInitialization) {
        this.checkoutApiInitialization = checkoutApiInitialization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateCaptureContextRequest generateCaptureContextRequest = (GenerateCaptureContextRequest)o;
        return Objects.equals(this.targetOrigins, generateCaptureContextRequest.targetOrigins) && Objects.equals(this.allowedCardNetworks, generateCaptureContextRequest.allowedCardNetworks) && Objects.equals(this.clientVersion, generateCaptureContextRequest.clientVersion) && Objects.equals(this.checkoutApiInitialization, generateCaptureContextRequest.checkoutApiInitialization);
    }

    public int hashCode() {
        return Objects.hash(this.targetOrigins, this.allowedCardNetworks, this.clientVersion, this.checkoutApiInitialization);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenerateCaptureContextRequest {\n");
        sb.append("    targetOrigins: ").append(this.toIndentedString(this.targetOrigins)).append("\n");
        sb.append("    allowedCardNetworks: ").append(this.toIndentedString(this.allowedCardNetworks)).append("\n");
        sb.append("    clientVersion: ").append(this.toIndentedString(this.clientVersion)).append("\n");
        sb.append("    checkoutApiInitialization: ").append(this.toIndentedString(this.checkoutApiInitialization)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

