/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.CreateP12KeysRequest;
import Model.DeleteBulkP12KeysRequest;
import Model.KmsV2KeysAsymDeletesPost200Response;
import Model.KmsV2KeysAsymGet200Response;
import Model.KmsV2KeysAsymPost201Response;
import Model.UpdateAsymKeysRequest;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class AsymmetricKeyManagementApi {
    private static Logger logger = LogManager.getLogger(AsymmetricKeyManagementApi.class);
    private ApiClient apiClient;

    public AsymmetricKeyManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AsymmetricKeyManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createP12KeysCall(CreateP12KeysRequest createP12KeysRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(createP12KeysRequest, CreateP12KeysRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment());
        String localVarPath = "/kms/v2/keys-asym";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createP12KeysValidateBeforeCall(CreateP12KeysRequest createP12KeysRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createP12KeysRequest == null) {
            logger.error("Missing the required parameter 'createP12KeysRequest' when calling createP12Keys(Async)");
            throw new ApiException("Missing the required parameter 'createP12KeysRequest' when calling createP12Keys(Async)");
        }
        Call call = this.createP12KeysCall(createP12KeysRequest, progressListener, progressRequestListener);
        return call;
    }

    public KmsV2KeysAsymPost201Response createP12Keys(CreateP12KeysRequest createP12KeysRequest) throws ApiException {
        logger.info("CALL TO METHOD 'createP12Keys' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<KmsV2KeysAsymPost201Response> resp = this.createP12KeysWithHttpInfo(createP12KeysRequest);
        logger.info("CALL TO METHOD 'createP12Keys' ENDED");
        return resp.getData();
    }

    public ApiResponse<KmsV2KeysAsymPost201Response> createP12KeysWithHttpInfo(CreateP12KeysRequest createP12KeysRequest) throws ApiException {
        Call call = this.createP12KeysValidateBeforeCall(createP12KeysRequest, null, null);
        Type localVarReturnType = new TypeToken<KmsV2KeysAsymPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createP12KeysAsync(CreateP12KeysRequest createP12KeysRequest, final ApiCallback<KmsV2KeysAsymPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createP12KeysValidateBeforeCall(createP12KeysRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KmsV2KeysAsymPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteBulkP12KeysCall(DeleteBulkP12KeysRequest deleteBulkP12KeysRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(deleteBulkP12KeysRequest, DeleteBulkP12KeysRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment());
        String localVarPath = "/kms/v2/keys-asym/deletes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteBulkP12KeysValidateBeforeCall(DeleteBulkP12KeysRequest deleteBulkP12KeysRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deleteBulkP12KeysRequest == null) {
            logger.error("Missing the required parameter 'deleteBulkP12KeysRequest' when calling deleteBulkP12Keys(Async)");
            throw new ApiException("Missing the required parameter 'deleteBulkP12KeysRequest' when calling deleteBulkP12Keys(Async)");
        }
        Call call = this.deleteBulkP12KeysCall(deleteBulkP12KeysRequest, progressListener, progressRequestListener);
        return call;
    }

    public KmsV2KeysAsymDeletesPost200Response deleteBulkP12Keys(DeleteBulkP12KeysRequest deleteBulkP12KeysRequest) throws ApiException {
        logger.info("CALL TO METHOD 'deleteBulkP12Keys' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<KmsV2KeysAsymDeletesPost200Response> resp = this.deleteBulkP12KeysWithHttpInfo(deleteBulkP12KeysRequest);
        logger.info("CALL TO METHOD 'deleteBulkP12Keys' ENDED");
        return resp.getData();
    }

    public ApiResponse<KmsV2KeysAsymDeletesPost200Response> deleteBulkP12KeysWithHttpInfo(DeleteBulkP12KeysRequest deleteBulkP12KeysRequest) throws ApiException {
        Call call = this.deleteBulkP12KeysValidateBeforeCall(deleteBulkP12KeysRequest, null, null);
        Type localVarReturnType = new TypeToken<KmsV2KeysAsymDeletesPost200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteBulkP12KeysAsync(DeleteBulkP12KeysRequest deleteBulkP12KeysRequest, final ApiCallback<KmsV2KeysAsymDeletesPost200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteBulkP12KeysValidateBeforeCall(deleteBulkP12KeysRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KmsV2KeysAsymDeletesPost200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getP12KeyDetailsCall(String keyId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/kms/v2/keys-asym/{keyId}".replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getP12KeyDetailsValidateBeforeCall(String keyId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (keyId == null) {
            logger.error("Missing the required parameter 'keyId' when calling getP12KeyDetails(Async)");
            throw new ApiException("Missing the required parameter 'keyId' when calling getP12KeyDetails(Async)");
        }
        Call call = this.getP12KeyDetailsCall(keyId, progressListener, progressRequestListener);
        return call;
    }

    public KmsV2KeysAsymGet200Response getP12KeyDetails(String keyId) throws ApiException {
        logger.info("CALL TO METHOD 'getP12KeyDetails' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<KmsV2KeysAsymGet200Response> resp = this.getP12KeyDetailsWithHttpInfo(keyId);
        logger.info("CALL TO METHOD 'getP12KeyDetails' ENDED");
        return resp.getData();
    }

    public ApiResponse<KmsV2KeysAsymGet200Response> getP12KeyDetailsWithHttpInfo(String keyId) throws ApiException {
        Call call = this.getP12KeyDetailsValidateBeforeCall(keyId, null, null);
        Type localVarReturnType = new TypeToken<KmsV2KeysAsymGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getP12KeyDetailsAsync(String keyId, final ApiCallback<KmsV2KeysAsymGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getP12KeyDetailsValidateBeforeCall(keyId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KmsV2KeysAsymGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateAsymKeyCall(String keyId, UpdateAsymKeysRequest updateAsymKeysRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(updateAsymKeysRequest, UpdateAsymKeysRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment());
        String localVarPath = "/kms/v2/keys-asym/{keyId}".replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAsymKeyValidateBeforeCall(String keyId, UpdateAsymKeysRequest updateAsymKeysRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (keyId == null) {
            logger.error("Missing the required parameter 'keyId' when calling updateAsymKey(Async)");
            throw new ApiException("Missing the required parameter 'keyId' when calling updateAsymKey(Async)");
        }
        if (updateAsymKeysRequest == null) {
            logger.error("Missing the required parameter 'updateAsymKeysRequest' when calling updateAsymKey(Async)");
            throw new ApiException("Missing the required parameter 'updateAsymKeysRequest' when calling updateAsymKey(Async)");
        }
        Call call = this.updateAsymKeyCall(keyId, updateAsymKeysRequest, progressListener, progressRequestListener);
        return call;
    }

    public Object updateAsymKey(String keyId, UpdateAsymKeysRequest updateAsymKeysRequest) throws ApiException {
        logger.info("CALL TO METHOD 'updateAsymKey' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Object> resp = this.updateAsymKeyWithHttpInfo(keyId, updateAsymKeysRequest);
        logger.info("CALL TO METHOD 'updateAsymKey' ENDED");
        return resp.getData();
    }

    public ApiResponse<Object> updateAsymKeyWithHttpInfo(String keyId, UpdateAsymKeysRequest updateAsymKeysRequest) throws ApiException {
        Call call = this.updateAsymKeyValidateBeforeCall(keyId, updateAsymKeysRequest, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAsymKeyAsync(String keyId, UpdateAsymKeysRequest updateAsymKeysRequest, final ApiCallback<Object> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAsymKeyValidateBeforeCall(keyId, updateAsymKeysRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

