/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import Model.PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonAcquirer;
import Model.PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonCurrencies1;
import Model.PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonPaymentTypes;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors
 */

public class PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors {
  @SerializedName("batchGroup")
  private String batchGroup = null;

  @SerializedName("businessApplicationId")
  private String businessApplicationId = null;

  @SerializedName("merchantVerificationValue")
  private String merchantVerificationValue = null;

  @SerializedName("abaNumber")
  private String abaNumber = null;

  @SerializedName("acquirer")
  private PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonAcquirer acquirer = null;

  @SerializedName("merchantId")
  private String merchantId = null;

  @SerializedName("terminalId")
  private String terminalId = null;

  @SerializedName("paymentTypes")
  private Map<String, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonPaymentTypes> paymentTypes = null;

  @SerializedName("currencies")
  private Map<String, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonCurrencies1> currencies = null;

  @SerializedName("sicCode")
  private String sicCode = null;

  @SerializedName("allowMultipleBills")
  private Boolean allowMultipleBills = null;

  @SerializedName("allowMerchantDescriptorOverride")
  private Boolean allowMerchantDescriptorOverride = null;

  @SerializedName("enhancedData")
  private String enhancedData = null;

  @SerializedName("fireSafetyIndicator")
  private Boolean fireSafetyIndicator = null;

  @SerializedName("quasiCash")
  private Boolean quasiCash = null;

  @SerializedName("acquirerMerchantId")
  private String acquirerMerchantId = null;

  @SerializedName("avsFormat")
  private String avsFormat = null;

  @SerializedName("enableLongTransRefNo")
  private Boolean enableLongTransRefNo = null;

  @SerializedName("enableLevel2")
  private Boolean enableLevel2 = null;

  @SerializedName("enableMultipleTransactionAdviceAddendum")
  private Boolean enableMultipleTransactionAdviceAddendum = null;

  @SerializedName("amexTransactionAdviceAddendum1")
  private String amexTransactionAdviceAddendum1 = null;

  @SerializedName("enableMultiLineItems")
  private Boolean enableMultiLineItems = null;

  @SerializedName("enableTransactionReferenceNumber")
  private Boolean enableTransactionReferenceNumber = null;

  @SerializedName("enableAutoAuthReversalAfterVoid")
  private Boolean enableAutoAuthReversalAfterVoid = null;

  @SerializedName("enableExpresspayPanTranslation")
  private Boolean enableExpresspayPanTranslation = null;

  @SerializedName("enableCreditAuth")
  private Boolean enableCreditAuth = null;

  /**
   * Field used to identify the industry type of the merchant submitting the authorization request.  Valid values: &#x60;0&#x60; – unknown or unsure &#x60;A&#x60; – auto rental (EMV supported) &#x60;B&#x60; – bank/financial institution (EMV supported) &#x60;D&#x60; – direct marketing &#x60;F&#x60; – food/restaurant (EMV supported) &#x60;G&#x60; – grocery store/super market (EMV supported) &#x60;H&#x60; – hotel (EMV supported) &#x60;L&#x60; – limited amount terminal (EMV supported) &#x60;O&#x60; – oil company/automated fueling system (EMV supported) &#x60;P&#x60; – passenger transport (EMV supported) &#x60;R&#x60; – retail (EMV supported) Applicable for TSYS (tsys), RUPAY and Elavon Americas (elavonamericas) processors. 
   */
  @JsonAdapter(IndustryCodeEnum.Adapter.class)
  public enum IndustryCodeEnum {
    _0("0"),
    
    A("A"),
    
    B("B"),
    
    D("D"),
    
    F("F"),
    
    G("G"),
    
    H("H"),
    
    L("L"),
    
    O("O"),
    
    P("P"),
    
    R("R");

    private String value;

    IndustryCodeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static IndustryCodeEnum fromValue(String text) {
      for (IndustryCodeEnum b : IndustryCodeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<IndustryCodeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final IndustryCodeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public IndustryCodeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return IndustryCodeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("industryCode")
  private IndustryCodeEnum industryCode = null;

  @SerializedName("sendAmexLevel2Data")
  private Boolean sendAmexLevel2Data = null;

  @SerializedName("softDescriptorType")
  private String softDescriptorType = null;

  @SerializedName("vitalNumber")
  private String vitalNumber = null;

  @SerializedName("bankNumber")
  private String bankNumber = null;

  @SerializedName("chainNumber")
  private String chainNumber = null;

  @SerializedName("merchantBinNumber")
  private String merchantBinNumber = null;

  @SerializedName("merchantLocationNumber")
  private String merchantLocationNumber = null;

  @SerializedName("storeID")
  private String storeID = null;

  @SerializedName("travelAgencyCode")
  private String travelAgencyCode = null;

  @SerializedName("travelAgencyName")
  private String travelAgencyName = null;

  @SerializedName("settlementCurrency")
  private String settlementCurrency = null;

  @SerializedName("enableLeastCostRouting")
  private Boolean enableLeastCostRouting = null;

  @SerializedName("enableCVVResponseIndicator")
  private Boolean enableCVVResponseIndicator = null;

  @SerializedName("enableMultiCurrencyProcessing")
  private String enableMultiCurrencyProcessing = null;

  @SerializedName("enablePosNetworkSwitching")
  private Boolean enablePosNetworkSwitching = null;

  @SerializedName("enableDynamicCurrencyConversion")
  private Boolean enableDynamicCurrencyConversion = null;

  @SerializedName("merchantTier")
  private String merchantTier = null;

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors batchGroup(String batchGroup) {
    this.batchGroup = batchGroup;
    return this;
  }

   /**
   * Determines the batching group that separates merchants for special batching times. Batching groups can separate merchant batches by the following criteria:  * Timezone * Merchant deadlines * Large merchants (top 10) * Merchants with Service-Level Agreements  Applicable for Chase Paymentech Salem (chasepaymentechsalem), Streamline (streamline2), Six (six), Barclays (barclays2), Paymentech Tampa (paymentechtampa), CMCIC (cmcic), FDC Nashville (smartfdc), RUPAY, American Express Direct (amexdirect), GPN (gpn), VPC, GPX (gpx), CB2A, Barclays HISO (barclayshiso), TSYS (tsys) and FDI Global (fdiglobal) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;Barclays&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;/tr&gt; &lt;tr&gt;&lt;td&gt;Barclays HISO&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;/tr&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return batchGroup
  **/
  @ApiModelProperty(value = "Determines the batching group that separates merchants for special batching times. Batching groups can separate merchant batches by the following criteria:  * Timezone * Merchant deadlines * Large merchants (top 10) * Merchants with Service-Level Agreements  Applicable for Chase Paymentech Salem (chasepaymentechsalem), Streamline (streamline2), Six (six), Barclays (barclays2), Paymentech Tampa (paymentechtampa), CMCIC (cmcic), FDC Nashville (smartfdc), RUPAY, American Express Direct (amexdirect), GPN (gpn), VPC, GPX (gpx), CB2A, Barclays HISO (barclayshiso), TSYS (tsys) and FDI Global (fdiglobal) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>Yes</td></tr> <tr><td>Barclays HISO</td><td>cnp, cp, hybrid</td><td>Yes</td></tr> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td></tr> </table> ")
  public String getBatchGroup() {
    return batchGroup;
  }

  public void setBatchGroup(String batchGroup) {
    this.batchGroup = batchGroup;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors businessApplicationId(String businessApplicationId) {
    this.businessApplicationId = businessApplicationId;
    return this;
  }

   /**
   * Indicates the type of money transfer used in the transaction. Applicable for VPC and GPX (gpx) processors.
   * @return businessApplicationId
  **/
  @ApiModelProperty(value = "Indicates the type of money transfer used in the transaction. Applicable for VPC and GPX (gpx) processors.")
  public String getBusinessApplicationId() {
    return businessApplicationId;
  }

  public void setBusinessApplicationId(String businessApplicationId) {
    this.businessApplicationId = businessApplicationId;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors merchantVerificationValue(String merchantVerificationValue) {
    this.merchantVerificationValue = merchantVerificationValue;
    return this;
  }

   /**
   * Identify merchants that participate in Select Merchant Fee (SMF) programs. Unique to the merchant. Applicable for GPX (gpx) and VPC processors.
   * @return merchantVerificationValue
  **/
  @ApiModelProperty(value = "Identify merchants that participate in Select Merchant Fee (SMF) programs. Unique to the merchant. Applicable for GPX (gpx) and VPC processors.")
  public String getMerchantVerificationValue() {
    return merchantVerificationValue;
  }

  public void setMerchantVerificationValue(String merchantVerificationValue) {
    this.merchantVerificationValue = merchantVerificationValue;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors abaNumber(String abaNumber) {
    this.abaNumber = abaNumber;
    return this;
  }

   /**
   * Routing Number to identify banks within the United States. Applicable for GPX (gpx) processors.
   * @return abaNumber
  **/
  @ApiModelProperty(value = "Routing Number to identify banks within the United States. Applicable for GPX (gpx) processors.")
  public String getAbaNumber() {
    return abaNumber;
  }

  public void setAbaNumber(String abaNumber) {
    this.abaNumber = abaNumber;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors acquirer(PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonAcquirer acquirer) {
    this.acquirer = acquirer;
    return this;
  }

   /**
   * Get acquirer
   * @return acquirer
  **/
  @ApiModelProperty(value = "")
  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonAcquirer getAcquirer() {
    return acquirer;
  }

  public void setAcquirer(PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonAcquirer acquirer) {
    this.acquirer = acquirer;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors merchantId(String merchantId) {
    this.merchantId = merchantId;
    return this;
  }

   /**
   * Merchant ID assigned by an acquirer or a processor. Should not be overriden by any other party.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Min. Length&lt;/th&gt;&lt;th&gt;Max. Length&lt;/th&gt;&lt;th&gt;Regex&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;Barclays HISO&lt;/td&gt;&lt;td&gt;cp, cnp, hybrid&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;td&gt;1&lt;/td&gt;&lt;td&gt;15&lt;/td&gt;&lt;td&gt;^[0-9a-zA-Z]+$&lt;/td&gt;&lt;/tr&gt; &lt;tr&gt;&lt;td&gt;Barclays&lt;/td&gt;&lt;td&gt;cp, cnp, hybrid&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;td&gt;1&lt;/td&gt;&lt;td&gt;11&lt;/td&gt;&lt;td&gt;^[0-9a-zA-Z]+$&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return merchantId
  **/
  @ApiModelProperty(required = true, value = "Merchant ID assigned by an acquirer or a processor. Should not be overriden by any other party.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays HISO</td><td>cp, cnp, hybrid</td><td>Yes</td><td>1</td><td>15</td><td>^[0-9a-zA-Z]+$</td></tr> <tr><td>Barclays</td><td>cp, cnp, hybrid</td><td>Yes</td><td>1</td><td>11</td><td>^[0-9a-zA-Z]+$</td></tr> </table> ")
  public String getMerchantId() {
    return merchantId;
  }

  public void setMerchantId(String merchantId) {
    this.merchantId = merchantId;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors terminalId(String terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * The &#39;Terminal Id&#39; aka TID, is an identifier used for with your payments processor. Depending on the processor and payment acceptance type this may also be the default Terminal ID used for Card Present and Virtual Terminal transactions.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Min. Length&lt;/th&gt;&lt;th&gt;Max. Length&lt;/th&gt;&lt;th&gt;Regex&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;Barclays HISO&lt;/td&gt;&lt;td&gt;cnp, hybrid&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;td&gt;1&lt;/td&gt;&lt;td&gt;16&lt;/td&gt;&lt;td&gt;^[0-9a-zA-Z]+$&lt;/td&gt;&lt;/tr&gt; &lt;tr&gt;&lt;td&gt;Barclays HISO&lt;/td&gt;&lt;td&gt;cp&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;1&lt;/td&gt;&lt;td&gt;16&lt;/td&gt;&lt;td&gt;^[0-9a-zA-Z]+$&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return terminalId
  **/
  @ApiModelProperty(value = "The 'Terminal Id' aka TID, is an identifier used for with your payments processor. Depending on the processor and payment acceptance type this may also be the default Terminal ID used for Card Present and Virtual Terminal transactions.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays HISO</td><td>cnp, hybrid</td><td>Yes</td><td>1</td><td>16</td><td>^[0-9a-zA-Z]+$</td></tr> <tr><td>Barclays HISO</td><td>cp</td><td>No</td><td>1</td><td>16</td><td>^[0-9a-zA-Z]+$</td></tr> </table> ")
  public String getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(String terminalId) {
    this.terminalId = terminalId;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors paymentTypes(Map<String, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonPaymentTypes> paymentTypes) {
    this.paymentTypes = paymentTypes;
    return this;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors putPaymentTypesItem(String key, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonPaymentTypes paymentTypesItem) {
    if (this.paymentTypes == null) {
      this.paymentTypes = new HashMap<String, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonPaymentTypes>();
    }
    this.paymentTypes.put(key, paymentTypesItem);
    return this;
  }

   /**
   * Valid values are: * VISA * MASTERCARD * AMERICAN_EXPRESS * CUP * EFTPOS * DINERS_CLUB * DISCOVER * JCB 
   * @return paymentTypes
  **/
  @ApiModelProperty(value = "Valid values are: * VISA * MASTERCARD * AMERICAN_EXPRESS * CUP * EFTPOS * DINERS_CLUB * DISCOVER * JCB ")
  public Map<String, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonPaymentTypes> getPaymentTypes() {
    return paymentTypes;
  }

  public void setPaymentTypes(Map<String, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonPaymentTypes> paymentTypes) {
    this.paymentTypes = paymentTypes;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors currencies(Map<String, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonCurrencies1> currencies) {
    this.currencies = currencies;
    return this;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors putCurrenciesItem(String key, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonCurrencies1 currenciesItem) {
    if (this.currencies == null) {
      this.currencies = new HashMap<String, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonCurrencies1>();
    }
    this.currencies.put(key, currenciesItem);
    return this;
  }

   /**
   * Three-character [ISO 4217 ALPHA-3 Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)
   * @return currencies
  **/
  @ApiModelProperty(value = "Three-character [ISO 4217 ALPHA-3 Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)")
  public Map<String, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonCurrencies1> getCurrencies() {
    return currencies;
  }

  public void setCurrencies(Map<String, PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonCurrencies1> currencies) {
    this.currencies = currencies;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors sicCode(String sicCode) {
    this.sicCode = sicCode;
    return this;
  }

   /**
   * The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.
   * @return sicCode
  **/
  @ApiModelProperty(value = "The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.")
  public String getSicCode() {
    return sicCode;
  }

  public void setSicCode(String sicCode) {
    this.sicCode = sicCode;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors allowMultipleBills(Boolean allowMultipleBills) {
    this.allowMultipleBills = allowMultipleBills;
    return this;
  }

   /**
   * Allows multiple captures for a single authorization transaction. Applicable for Paymentech Tampa (paymentechtampa), VPC, American Express Direct (amexdirect) and GPX (gpx) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cp, hybrid&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cnp&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return allowMultipleBills
  **/
  @ApiModelProperty(value = "Allows multiple captures for a single authorization transaction. Applicable for Paymentech Tampa (paymentechtampa), VPC, American Express Direct (amexdirect) and GPX (gpx) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, hybrid</td><td>Yes</td><td>No</td></tr> <tr><td>American Express Direct</td><td>cnp</td><td>No</td><td>No</td></tr> </table> ")
  public Boolean getAllowMultipleBills() {
    return allowMultipleBills;
  }

  public void setAllowMultipleBills(Boolean allowMultipleBills) {
    this.allowMultipleBills = allowMultipleBills;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors allowMerchantDescriptorOverride(Boolean allowMerchantDescriptorOverride) {
    this.allowMerchantDescriptorOverride = allowMerchantDescriptorOverride;
    return this;
  }

   /**
   * Enables partner to enable/disable merchant descriptors values. Applicable for VPC, EFTPOS and CUP processors.
   * @return allowMerchantDescriptorOverride
  **/
  @ApiModelProperty(value = "Enables partner to enable/disable merchant descriptors values. Applicable for VPC, EFTPOS and CUP processors.")
  public Boolean getAllowMerchantDescriptorOverride() {
    return allowMerchantDescriptorOverride;
  }

  public void setAllowMerchantDescriptorOverride(Boolean allowMerchantDescriptorOverride) {
    this.allowMerchantDescriptorOverride = allowMerchantDescriptorOverride;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enhancedData(String enhancedData) {
    this.enhancedData = enhancedData;
    return this;
  }

   /**
   * To enable airline transactions. Applicable for TSYS (tsys), VPC, Elavon Americas (elavonamericas), FDI Global (fdiglobal), GPX (gpx), Barclays (barclays2) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;Barclays&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cp, cnp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return enhancedData
  **/
  @ApiModelProperty(value = "To enable airline transactions. Applicable for TSYS (tsys), VPC, Elavon Americas (elavonamericas), FDI Global (fdiglobal), GPX (gpx), Barclays (barclays2) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td></tr> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td></tr> </table> ")
  public String getEnhancedData() {
    return enhancedData;
  }

  public void setEnhancedData(String enhancedData) {
    this.enhancedData = enhancedData;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors fireSafetyIndicator(Boolean fireSafetyIndicator) {
    this.fireSafetyIndicator = fireSafetyIndicator;
    return this;
  }

   /**
   * Indicates whether the merchant is compliant with Hotel and Motel Fire Safety Act of 1990. Applicable for GPX (gpx) and VPC processors.
   * @return fireSafetyIndicator
  **/
  @ApiModelProperty(value = "Indicates whether the merchant is compliant with Hotel and Motel Fire Safety Act of 1990. Applicable for GPX (gpx) and VPC processors.")
  public Boolean getFireSafetyIndicator() {
    return fireSafetyIndicator;
  }

  public void setFireSafetyIndicator(Boolean fireSafetyIndicator) {
    this.fireSafetyIndicator = fireSafetyIndicator;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors quasiCash(Boolean quasiCash) {
    this.quasiCash = quasiCash;
    return this;
  }

   /**
   * To enable quasi-cash transactions. A quasi-cash transaction is a cash-like transaction for the sale of items that are directly convertible to cash, such as:- Casino gaming chips, Money orders, Wire transfers.  Applicable for GPX (gpx), TSYS (tsys), Barclays (barclays2) and VPC processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;Barclays&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return quasiCash
  **/
  @ApiModelProperty(value = "To enable quasi-cash transactions. A quasi-cash transaction is a cash-like transaction for the sale of items that are directly convertible to cash, such as:- Casino gaming chips, Money orders, Wire transfers.  Applicable for GPX (gpx), TSYS (tsys), Barclays (barclays2) and VPC processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
  public Boolean getQuasiCash() {
    return quasiCash;
  }

  public void setQuasiCash(Boolean quasiCash) {
    this.quasiCash = quasiCash;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors acquirerMerchantId(String acquirerMerchantId) {
    this.acquirerMerchantId = acquirerMerchantId;
    return this;
  }

   /**
   * Identifier assigned by the acquirer. Applicable for RUPAY, VPC and Six (six) processors.
   * @return acquirerMerchantId
  **/
  @ApiModelProperty(value = "Identifier assigned by the acquirer. Applicable for RUPAY, VPC and Six (six) processors.")
  public String getAcquirerMerchantId() {
    return acquirerMerchantId;
  }

  public void setAcquirerMerchantId(String acquirerMerchantId) {
    this.acquirerMerchantId = acquirerMerchantId;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors avsFormat(String avsFormat) {
    this.avsFormat = avsFormat;
    return this;
  }

   /**
   * Enables Enhanced AVS/Automated Address Verification Plus (AAV+).  Valid values: \&quot;basic\&quot; - Standard address verification system.   When a processor supports AVS for a transaction’s card type, the issuing bank uses AVS to confirm that the customer has provided the correct billing address.   When a customer provides incorrect information, the transaction might be fraudulent. \&quot;basic + name\&quot; - Enhanced address verification system.   Consists of the standard AVS functionality plus verification of some additional fields.   The additional fields that are verified for Enhanced AVS are:   - customer_firstname   - customer_lastname \&quot;basic + name + shipto\&quot; - Automated address verification plus.   Consists of the Enhanced AVS functionality plus verification of some additional fields.   AAV+ intended for merchants who deliver physical goods to a different address than the billing address.   AAV+ verifies the additional fields only when the standard and Enhanced AVS tests pass first.   For information about Enhanced AVS - The additional fields that are verified for AAV+ are:   - ship_to_firstname   - ship_to_lastname   - ship_to_address1   - ship_to_country   - ship_to_zip   - ship_to_phone   - customer_phone(American Express Direct only)  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;td&gt;basic&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return avsFormat
  **/
  @ApiModelProperty(value = "Enables Enhanced AVS/Automated Address Verification Plus (AAV+).  Valid values: \"basic\" - Standard address verification system.   When a processor supports AVS for a transaction’s card type, the issuing bank uses AVS to confirm that the customer has provided the correct billing address.   When a customer provides incorrect information, the transaction might be fraudulent. \"basic + name\" - Enhanced address verification system.   Consists of the standard AVS functionality plus verification of some additional fields.   The additional fields that are verified for Enhanced AVS are:   - customer_firstname   - customer_lastname \"basic + name + shipto\" - Automated address verification plus.   Consists of the Enhanced AVS functionality plus verification of some additional fields.   AAV+ intended for merchants who deliver physical goods to a different address than the billing address.   AAV+ verifies the additional fields only when the standard and Enhanced AVS tests pass first.   For information about Enhanced AVS - The additional fields that are verified for AAV+ are:   - ship_to_firstname   - ship_to_lastname   - ship_to_address1   - ship_to_country   - ship_to_zip   - ship_to_phone   - customer_phone(American Express Direct only)  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>basic</td></tr> </table> ")
  public String getAvsFormat() {
    return avsFormat;
  }

  public void setAvsFormat(String avsFormat) {
    this.avsFormat = avsFormat;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableLongTransRefNo(Boolean enableLongTransRefNo) {
    this.enableLongTransRefNo = enableLongTransRefNo;
    return this;
  }

   /**
   * Amex Direct specific merchant config value which determines what length (either 9 or Unique 12-char reference number) of reference number will be CYBS generated if the merchant does not pass in a trans_ref_no. Can be any combination of alpha, numeric and special characters, and/or binary data in hexadecimal.  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cp, cnp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return enableLongTransRefNo
  **/
  @ApiModelProperty(value = "Amex Direct specific merchant config value which determines what length (either 9 or Unique 12-char reference number) of reference number will be CYBS generated if the merchant does not pass in a trans_ref_no. Can be any combination of alpha, numeric and special characters, and/or binary data in hexadecimal.  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
  public Boolean getEnableLongTransRefNo() {
    return enableLongTransRefNo;
  }

  public void setEnableLongTransRefNo(Boolean enableLongTransRefNo) {
    this.enableLongTransRefNo = enableLongTransRefNo;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableLevel2(Boolean enableLevel2) {
    this.enableLevel2 = enableLevel2;
    return this;
  }

   /**
   * Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cp, cnp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return enableLevel2
  **/
  @ApiModelProperty(value = "Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
  public Boolean getEnableLevel2() {
    return enableLevel2;
  }

  public void setEnableLevel2(Boolean enableLevel2) {
    this.enableLevel2 = enableLevel2;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableMultipleTransactionAdviceAddendum(Boolean enableMultipleTransactionAdviceAddendum) {
    this.enableMultipleTransactionAdviceAddendum = enableMultipleTransactionAdviceAddendum;
    return this;
  }

   /**
   * This flag related to multiple transaction advice addendum field. It is used to display descriptive information about a transaction on customer’s American Express card statement. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cp, cnp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return enableMultipleTransactionAdviceAddendum
  **/
  @ApiModelProperty(value = "This flag related to multiple transaction advice addendum field. It is used to display descriptive information about a transaction on customer’s American Express card statement. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
  public Boolean getEnableMultipleTransactionAdviceAddendum() {
    return enableMultipleTransactionAdviceAddendum;
  }

  public void setEnableMultipleTransactionAdviceAddendum(Boolean enableMultipleTransactionAdviceAddendum) {
    this.enableMultipleTransactionAdviceAddendum = enableMultipleTransactionAdviceAddendum;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors amexTransactionAdviceAddendum1(String amexTransactionAdviceAddendum1) {
    this.amexTransactionAdviceAddendum1 = amexTransactionAdviceAddendum1;
    return this;
  }

   /**
   * Advice addendum field. It is used to display descriptive information about a transaction on customer’s American Express card statement. Applicable for TSYS (tsys), FDI Global (fdiglobal) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Min. Length&lt;/th&gt;&lt;th&gt;Max. Length&lt;/th&gt;&lt;th&gt;Regex&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;1&lt;/td&gt;&lt;td&gt;40&lt;/td&gt;&lt;td&gt;^[0-9a-zA-Z&amp;#92;-\\s.]+$&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return amexTransactionAdviceAddendum1
  **/
  @ApiModelProperty(value = "Advice addendum field. It is used to display descriptive information about a transaction on customer’s American Express card statement. Applicable for TSYS (tsys), FDI Global (fdiglobal) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>40</td><td>^[0-9a-zA-Z&#92;-\\s.]+$</td></tr> </table> ")
  public String getAmexTransactionAdviceAddendum1() {
    return amexTransactionAdviceAddendum1;
  }

  public void setAmexTransactionAdviceAddendum1(String amexTransactionAdviceAddendum1) {
    this.amexTransactionAdviceAddendum1 = amexTransactionAdviceAddendum1;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableMultiLineItems(Boolean enableMultiLineItems) {
    this.enableMultiLineItems = enableMultiLineItems;
    return this;
  }

   /**
   * This flag is related to offer/line item details to be included instead of sending one line item, and a grand total. Example, offer0, offer 1...offer n. Applicable for American Express Direct (amexdirect) and Elavon Americas (elavonamericas) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cp, cnp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return enableMultiLineItems
  **/
  @ApiModelProperty(value = "This flag is related to offer/line item details to be included instead of sending one line item, and a grand total. Example, offer0, offer 1...offer n. Applicable for American Express Direct (amexdirect) and Elavon Americas (elavonamericas) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
  public Boolean getEnableMultiLineItems() {
    return enableMultiLineItems;
  }

  public void setEnableMultiLineItems(Boolean enableMultiLineItems) {
    this.enableMultiLineItems = enableMultiLineItems;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableTransactionReferenceNumber(Boolean enableTransactionReferenceNumber) {
    this.enableTransactionReferenceNumber = enableTransactionReferenceNumber;
    return this;
  }

   /**
   * To enable merchant to send in transaction reference number (unique reconciliation ID). Applicable for VPC, Vero (vero), FDI Global (fdiglobal), Six (six), CB2A, CUP, VPC, Chase Paymentech Salem (chasepaymentechsalem), Fiserv (fiserv), Elavon Americas (elavonamericas) and EFTPOS processors.
   * @return enableTransactionReferenceNumber
  **/
  @ApiModelProperty(value = "To enable merchant to send in transaction reference number (unique reconciliation ID). Applicable for VPC, Vero (vero), FDI Global (fdiglobal), Six (six), CB2A, CUP, VPC, Chase Paymentech Salem (chasepaymentechsalem), Fiserv (fiserv), Elavon Americas (elavonamericas) and EFTPOS processors.")
  public Boolean getEnableTransactionReferenceNumber() {
    return enableTransactionReferenceNumber;
  }

  public void setEnableTransactionReferenceNumber(Boolean enableTransactionReferenceNumber) {
    this.enableTransactionReferenceNumber = enableTransactionReferenceNumber;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableAutoAuthReversalAfterVoid(Boolean enableAutoAuthReversalAfterVoid) {
    this.enableAutoAuthReversalAfterVoid = enableAutoAuthReversalAfterVoid;
    return this;
  }

   /**
   * Enables to meet the Visa mandate requirements to reverse unused authorizations, benefitting the customer by releasing the hold on unused credit card funds. Applicable for CB2A, Elavon Americas (elavonamericas), Six (six), VPC and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cp, cnp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return enableAutoAuthReversalAfterVoid
  **/
  @ApiModelProperty(value = "Enables to meet the Visa mandate requirements to reverse unused authorizations, benefitting the customer by releasing the hold on unused credit card funds. Applicable for CB2A, Elavon Americas (elavonamericas), Six (six), VPC and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
  public Boolean getEnableAutoAuthReversalAfterVoid() {
    return enableAutoAuthReversalAfterVoid;
  }

  public void setEnableAutoAuthReversalAfterVoid(Boolean enableAutoAuthReversalAfterVoid) {
    this.enableAutoAuthReversalAfterVoid = enableAutoAuthReversalAfterVoid;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableExpresspayPanTranslation(Boolean enableExpresspayPanTranslation) {
    this.enableExpresspayPanTranslation = enableExpresspayPanTranslation;
    return this;
  }

   /**
   * When this is enabled, authorization responses from American Express expresspay transactions include the Primary Account Number (PAN) and expiration date of the card. Applicable for American Express Direct (amexdirect) processor.
   * @return enableExpresspayPanTranslation
  **/
  @ApiModelProperty(value = "When this is enabled, authorization responses from American Express expresspay transactions include the Primary Account Number (PAN) and expiration date of the card. Applicable for American Express Direct (amexdirect) processor.")
  public Boolean getEnableExpresspayPanTranslation() {
    return enableExpresspayPanTranslation;
  }

  public void setEnableExpresspayPanTranslation(Boolean enableExpresspayPanTranslation) {
    this.enableExpresspayPanTranslation = enableExpresspayPanTranslation;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableCreditAuth(Boolean enableCreditAuth) {
    this.enableCreditAuth = enableCreditAuth;
    return this;
  }

   /**
   * Authorizes a credit. Reduces refund chargebacks and prevents customers from seeing the online update for credits which are otherwise offline settlements.
   * @return enableCreditAuth
  **/
  @ApiModelProperty(value = "Authorizes a credit. Reduces refund chargebacks and prevents customers from seeing the online update for credits which are otherwise offline settlements.")
  public Boolean getEnableCreditAuth() {
    return enableCreditAuth;
  }

  public void setEnableCreditAuth(Boolean enableCreditAuth) {
    this.enableCreditAuth = enableCreditAuth;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors industryCode(IndustryCodeEnum industryCode) {
    this.industryCode = industryCode;
    return this;
  }

   /**
   * Field used to identify the industry type of the merchant submitting the authorization request.  Valid values: &#x60;0&#x60; – unknown or unsure &#x60;A&#x60; – auto rental (EMV supported) &#x60;B&#x60; – bank/financial institution (EMV supported) &#x60;D&#x60; – direct marketing &#x60;F&#x60; – food/restaurant (EMV supported) &#x60;G&#x60; – grocery store/super market (EMV supported) &#x60;H&#x60; – hotel (EMV supported) &#x60;L&#x60; – limited amount terminal (EMV supported) &#x60;O&#x60; – oil company/automated fueling system (EMV supported) &#x60;P&#x60; – passenger transport (EMV supported) &#x60;R&#x60; – retail (EMV supported) Applicable for TSYS (tsys), RUPAY and Elavon Americas (elavonamericas) processors. 
   * @return industryCode
  **/
  @ApiModelProperty(value = "Field used to identify the industry type of the merchant submitting the authorization request.  Valid values: `0` – unknown or unsure `A` – auto rental (EMV supported) `B` – bank/financial institution (EMV supported) `D` – direct marketing `F` – food/restaurant (EMV supported) `G` – grocery store/super market (EMV supported) `H` – hotel (EMV supported) `L` – limited amount terminal (EMV supported) `O` – oil company/automated fueling system (EMV supported) `P` – passenger transport (EMV supported) `R` – retail (EMV supported) Applicable for TSYS (tsys), RUPAY and Elavon Americas (elavonamericas) processors. ")
  public IndustryCodeEnum getIndustryCode() {
    return industryCode;
  }

  public void setIndustryCode(IndustryCodeEnum industryCode) {
    this.industryCode = industryCode;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors sendAmexLevel2Data(Boolean sendAmexLevel2Data) {
    this.sendAmexLevel2Data = sendAmexLevel2Data;
    return this;
  }

   /**
   * Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for TSYS (tsys) processor.
   * @return sendAmexLevel2Data
  **/
  @ApiModelProperty(value = "Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for TSYS (tsys) processor.")
  public Boolean getSendAmexLevel2Data() {
    return sendAmexLevel2Data;
  }

  public void setSendAmexLevel2Data(Boolean sendAmexLevel2Data) {
    this.sendAmexLevel2Data = sendAmexLevel2Data;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors softDescriptorType(String softDescriptorType) {
    this.softDescriptorType = softDescriptorType;
    return this;
  }

   /**
   * A soft descriptor is a text, rendered on a cardholder’s statement, describing a particular product or service, purchased by the cardholder. Descriptors are intended to help the cardholder identify the products or services purchased. Valid values: &#x60;1&#x60; - trans_ref_no &#x60;2&#x60; - merchant_descriptor &#x60;3&#x60; - trans_ref_no and merchant_descriptor Applicable for TSYS (tsys) processor. 
   * @return softDescriptorType
  **/
  @ApiModelProperty(value = "A soft descriptor is a text, rendered on a cardholder’s statement, describing a particular product or service, purchased by the cardholder. Descriptors are intended to help the cardholder identify the products or services purchased. Valid values: `1` - trans_ref_no `2` - merchant_descriptor `3` - trans_ref_no and merchant_descriptor Applicable for TSYS (tsys) processor. ")
  public String getSoftDescriptorType() {
    return softDescriptorType;
  }

  public void setSoftDescriptorType(String softDescriptorType) {
    this.softDescriptorType = softDescriptorType;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors vitalNumber(String vitalNumber) {
    this.vitalNumber = vitalNumber;
    return this;
  }

   /**
   * V-number provided by TSYS info. The leading &#x60;V&#x60; must be replaced by a &#x60;7&#x60;. For example, replace &#x60;V1234567&#x60; with &#x60;71234567&#x60;. Applicable for TSYS (tsys) processor.
   * @return vitalNumber
  **/
  @ApiModelProperty(value = "V-number provided by TSYS info. The leading `V` must be replaced by a `7`. For example, replace `V1234567` with `71234567`. Applicable for TSYS (tsys) processor.")
  public String getVitalNumber() {
    return vitalNumber;
  }

  public void setVitalNumber(String vitalNumber) {
    this.vitalNumber = vitalNumber;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors bankNumber(String bankNumber) {
    this.bankNumber = bankNumber;
    return this;
  }

   /**
   * 6 digit agent bank number provided by acquirer. Applicable for TSYS (tsys) processor.
   * @return bankNumber
  **/
  @ApiModelProperty(value = "6 digit agent bank number provided by acquirer. Applicable for TSYS (tsys) processor.")
  public String getBankNumber() {
    return bankNumber;
  }

  public void setBankNumber(String bankNumber) {
    this.bankNumber = bankNumber;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors chainNumber(String chainNumber) {
    this.chainNumber = chainNumber;
    return this;
  }

   /**
   * 6 digit chain number provided by acquirer. Applicable for TSYS (tsys) processor.
   * @return chainNumber
  **/
  @ApiModelProperty(value = "6 digit chain number provided by acquirer. Applicable for TSYS (tsys) processor.")
  public String getChainNumber() {
    return chainNumber;
  }

  public void setChainNumber(String chainNumber) {
    this.chainNumber = chainNumber;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors merchantBinNumber(String merchantBinNumber) {
    this.merchantBinNumber = merchantBinNumber;
    return this;
  }

   /**
   * 6 digits acquirer bank identification number. Applicable for TSYS (tsys) processor.
   * @return merchantBinNumber
  **/
  @ApiModelProperty(value = "6 digits acquirer bank identification number. Applicable for TSYS (tsys) processor.")
  public String getMerchantBinNumber() {
    return merchantBinNumber;
  }

  public void setMerchantBinNumber(String merchantBinNumber) {
    this.merchantBinNumber = merchantBinNumber;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors merchantLocationNumber(String merchantLocationNumber) {
    this.merchantLocationNumber = merchantLocationNumber;
    return this;
  }

   /**
   * 5 digit merchant location number. Unless otherwise specified by merchant’s bank or processor, this field should default to 00001. Applicable for TSYS (tsys) processor.
   * @return merchantLocationNumber
  **/
  @ApiModelProperty(value = "5 digit merchant location number. Unless otherwise specified by merchant’s bank or processor, this field should default to 00001. Applicable for TSYS (tsys) processor.")
  public String getMerchantLocationNumber() {
    return merchantLocationNumber;
  }

  public void setMerchantLocationNumber(String merchantLocationNumber) {
    this.merchantLocationNumber = merchantLocationNumber;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors storeID(String storeID) {
    this.storeID = storeID;
    return this;
  }

   /**
   * 4 digits number used to identify a specific merchant store location within the member systems. Applicable for TSYS (tsys) processor.
   * @return storeID
  **/
  @ApiModelProperty(value = "4 digits number used to identify a specific merchant store location within the member systems. Applicable for TSYS (tsys) processor.")
  public String getStoreID() {
    return storeID;
  }

  public void setStoreID(String storeID) {
    this.storeID = storeID;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors travelAgencyCode(String travelAgencyCode) {
    this.travelAgencyCode = travelAgencyCode;
    return this;
  }

   /**
   * Contains travel agency code if airline ticket was issued by a travel agency. Applicable for TSYS (tsys) processor.
   * @return travelAgencyCode
  **/
  @ApiModelProperty(value = "Contains travel agency code if airline ticket was issued by a travel agency. Applicable for TSYS (tsys) processor.")
  public String getTravelAgencyCode() {
    return travelAgencyCode;
  }

  public void setTravelAgencyCode(String travelAgencyCode) {
    this.travelAgencyCode = travelAgencyCode;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors travelAgencyName(String travelAgencyName) {
    this.travelAgencyName = travelAgencyName;
    return this;
  }

   /**
   * Contains travel agency name if airline ticket was issued by travel agency. Applicable for TSYS (tsys) processor.
   * @return travelAgencyName
  **/
  @ApiModelProperty(value = "Contains travel agency name if airline ticket was issued by travel agency. Applicable for TSYS (tsys) processor.")
  public String getTravelAgencyName() {
    return travelAgencyName;
  }

  public void setTravelAgencyName(String travelAgencyName) {
    this.travelAgencyName = travelAgencyName;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors settlementCurrency(String settlementCurrency) {
    this.settlementCurrency = settlementCurrency;
    return this;
  }

   /**
   * This field is used to indicate Merchant&#39;s settlement currency. [ISO 4217 ALPHA-3 Standard Currency Codes] Applicable for TSYS (tsys) and Streamline (streamline2) processors.
   * @return settlementCurrency
  **/
  @ApiModelProperty(value = "This field is used to indicate Merchant's settlement currency. [ISO 4217 ALPHA-3 Standard Currency Codes] Applicable for TSYS (tsys) and Streamline (streamline2) processors.")
  public String getSettlementCurrency() {
    return settlementCurrency;
  }

  public void setSettlementCurrency(String settlementCurrency) {
    this.settlementCurrency = settlementCurrency;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableLeastCostRouting(Boolean enableLeastCostRouting) {
    this.enableLeastCostRouting = enableLeastCostRouting;
    return this;
  }

   /**
   * Indicates whether Least Cost Routing is enabled. Applicable for EFTPOS and CUP processors.
   * @return enableLeastCostRouting
  **/
  @ApiModelProperty(value = "Indicates whether Least Cost Routing is enabled. Applicable for EFTPOS and CUP processors.")
  public Boolean getEnableLeastCostRouting() {
    return enableLeastCostRouting;
  }

  public void setEnableLeastCostRouting(Boolean enableLeastCostRouting) {
    this.enableLeastCostRouting = enableLeastCostRouting;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableCVVResponseIndicator(Boolean enableCVVResponseIndicator) {
    this.enableCVVResponseIndicator = enableCVVResponseIndicator;
    return this;
  }

   /**
   * This field denotes EFTPOS Merchant&#39;s choice of receiving CVV Processing Response in return. Applicable for EFTPOS processors.
   * @return enableCVVResponseIndicator
  **/
  @ApiModelProperty(value = "This field denotes EFTPOS Merchant's choice of receiving CVV Processing Response in return. Applicable for EFTPOS processors.")
  public Boolean getEnableCVVResponseIndicator() {
    return enableCVVResponseIndicator;
  }

  public void setEnableCVVResponseIndicator(Boolean enableCVVResponseIndicator) {
    this.enableCVVResponseIndicator = enableCVVResponseIndicator;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableMultiCurrencyProcessing(String enableMultiCurrencyProcessing) {
    this.enableMultiCurrencyProcessing = enableMultiCurrencyProcessing;
    return this;
  }

   /**
   * Applicable for Barclays (barclays2) processor.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;Barclays&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return enableMultiCurrencyProcessing
  **/
  @ApiModelProperty(value = "Applicable for Barclays (barclays2) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>Yes</td></tr> </table> ")
  public String getEnableMultiCurrencyProcessing() {
    return enableMultiCurrencyProcessing;
  }

  public void setEnableMultiCurrencyProcessing(String enableMultiCurrencyProcessing) {
    this.enableMultiCurrencyProcessing = enableMultiCurrencyProcessing;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enablePosNetworkSwitching(Boolean enablePosNetworkSwitching) {
    this.enablePosNetworkSwitching = enablePosNetworkSwitching;
    return this;
  }

   /**
   * ‘POS Network Switching’ or ‘Alternate Routing’ means merchant can process PIN Debit transactions without a PIN. Set the value to ‘Yes’ if it is supported. Applicable for FDI Global (fdiglobal) processor.
   * @return enablePosNetworkSwitching
  **/
  @ApiModelProperty(value = "‘POS Network Switching’ or ‘Alternate Routing’ means merchant can process PIN Debit transactions without a PIN. Set the value to ‘Yes’ if it is supported. Applicable for FDI Global (fdiglobal) processor.")
  public Boolean getEnablePosNetworkSwitching() {
    return enablePosNetworkSwitching;
  }

  public void setEnablePosNetworkSwitching(Boolean enablePosNetworkSwitching) {
    this.enablePosNetworkSwitching = enablePosNetworkSwitching;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors enableDynamicCurrencyConversion(Boolean enableDynamicCurrencyConversion) {
    this.enableDynamicCurrencyConversion = enableDynamicCurrencyConversion;
    return this;
  }

   /**
   * Enable dynamic currency conversion for a merchant.
   * @return enableDynamicCurrencyConversion
  **/
  @ApiModelProperty(value = "Enable dynamic currency conversion for a merchant.")
  public Boolean getEnableDynamicCurrencyConversion() {
    return enableDynamicCurrencyConversion;
  }

  public void setEnableDynamicCurrencyConversion(Boolean enableDynamicCurrencyConversion) {
    this.enableDynamicCurrencyConversion = enableDynamicCurrencyConversion;
  }

  public PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors merchantTier(String merchantTier) {
    this.merchantTier = merchantTier;
    return this;
  }

   /**
   * Merchant Tier defines the type of merchant, the numeric Merchant Tier value is allocated by EFTPOS. Applicable for EFTPOS processors.
   * @return merchantTier
  **/
  @ApiModelProperty(value = "Merchant Tier defines the type of merchant, the numeric Merchant Tier value is allocated by EFTPOS. Applicable for EFTPOS processors.")
  public String getMerchantTier() {
    return merchantTier;
  }

  public void setMerchantTier(String merchantTier) {
    this.merchantTier = merchantTier;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors = (PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors) o;
    return Objects.equals(this.batchGroup, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.batchGroup) &&
        Objects.equals(this.businessApplicationId, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.businessApplicationId) &&
        Objects.equals(this.merchantVerificationValue, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.merchantVerificationValue) &&
        Objects.equals(this.abaNumber, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.abaNumber) &&
        Objects.equals(this.acquirer, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.acquirer) &&
        Objects.equals(this.merchantId, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.merchantId) &&
        Objects.equals(this.terminalId, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.terminalId) &&
        Objects.equals(this.paymentTypes, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.paymentTypes) &&
        Objects.equals(this.currencies, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.currencies) &&
        Objects.equals(this.sicCode, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.sicCode) &&
        Objects.equals(this.allowMultipleBills, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.allowMultipleBills) &&
        Objects.equals(this.allowMerchantDescriptorOverride, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.allowMerchantDescriptorOverride) &&
        Objects.equals(this.enhancedData, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enhancedData) &&
        Objects.equals(this.fireSafetyIndicator, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.fireSafetyIndicator) &&
        Objects.equals(this.quasiCash, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.quasiCash) &&
        Objects.equals(this.acquirerMerchantId, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.acquirerMerchantId) &&
        Objects.equals(this.avsFormat, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.avsFormat) &&
        Objects.equals(this.enableLongTransRefNo, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableLongTransRefNo) &&
        Objects.equals(this.enableLevel2, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableLevel2) &&
        Objects.equals(this.enableMultipleTransactionAdviceAddendum, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableMultipleTransactionAdviceAddendum) &&
        Objects.equals(this.amexTransactionAdviceAddendum1, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.amexTransactionAdviceAddendum1) &&
        Objects.equals(this.enableMultiLineItems, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableMultiLineItems) &&
        Objects.equals(this.enableTransactionReferenceNumber, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableTransactionReferenceNumber) &&
        Objects.equals(this.enableAutoAuthReversalAfterVoid, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableAutoAuthReversalAfterVoid) &&
        Objects.equals(this.enableExpresspayPanTranslation, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableExpresspayPanTranslation) &&
        Objects.equals(this.enableCreditAuth, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableCreditAuth) &&
        Objects.equals(this.industryCode, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.industryCode) &&
        Objects.equals(this.sendAmexLevel2Data, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.sendAmexLevel2Data) &&
        Objects.equals(this.softDescriptorType, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.softDescriptorType) &&
        Objects.equals(this.vitalNumber, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.vitalNumber) &&
        Objects.equals(this.bankNumber, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.bankNumber) &&
        Objects.equals(this.chainNumber, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.chainNumber) &&
        Objects.equals(this.merchantBinNumber, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.merchantBinNumber) &&
        Objects.equals(this.merchantLocationNumber, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.merchantLocationNumber) &&
        Objects.equals(this.storeID, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.storeID) &&
        Objects.equals(this.travelAgencyCode, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.travelAgencyCode) &&
        Objects.equals(this.travelAgencyName, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.travelAgencyName) &&
        Objects.equals(this.settlementCurrency, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.settlementCurrency) &&
        Objects.equals(this.enableLeastCostRouting, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableLeastCostRouting) &&
        Objects.equals(this.enableCVVResponseIndicator, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableCVVResponseIndicator) &&
        Objects.equals(this.enableMultiCurrencyProcessing, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableMultiCurrencyProcessing) &&
        Objects.equals(this.enablePosNetworkSwitching, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enablePosNetworkSwitching) &&
        Objects.equals(this.enableDynamicCurrencyConversion, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.enableDynamicCurrencyConversion) &&
        Objects.equals(this.merchantTier, paymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors.merchantTier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(batchGroup, businessApplicationId, merchantVerificationValue, abaNumber, acquirer, merchantId, terminalId, paymentTypes, currencies, sicCode, allowMultipleBills, allowMerchantDescriptorOverride, enhancedData, fireSafetyIndicator, quasiCash, acquirerMerchantId, avsFormat, enableLongTransRefNo, enableLevel2, enableMultipleTransactionAdviceAddendum, amexTransactionAdviceAddendum1, enableMultiLineItems, enableTransactionReferenceNumber, enableAutoAuthReversalAfterVoid, enableExpresspayPanTranslation, enableCreditAuth, industryCode, sendAmexLevel2Data, softDescriptorType, vitalNumber, bankNumber, chainNumber, merchantBinNumber, merchantLocationNumber, storeID, travelAgencyCode, travelAgencyName, settlementCurrency, enableLeastCostRouting, enableCVVResponseIndicator, enableMultiCurrencyProcessing, enablePosNetworkSwitching, enableDynamicCurrencyConversion, merchantTier);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentProductsCardProcessingConfigurationInformationConfigurationsCommonProcessors {\n");
    
    sb.append("    batchGroup: ").append(toIndentedString(batchGroup)).append("\n");
    sb.append("    businessApplicationId: ").append(toIndentedString(businessApplicationId)).append("\n");
    sb.append("    merchantVerificationValue: ").append(toIndentedString(merchantVerificationValue)).append("\n");
    sb.append("    abaNumber: ").append(toIndentedString(abaNumber)).append("\n");
    sb.append("    acquirer: ").append(toIndentedString(acquirer)).append("\n");
    sb.append("    merchantId: ").append(toIndentedString(merchantId)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    paymentTypes: ").append(toIndentedString(paymentTypes)).append("\n");
    sb.append("    currencies: ").append(toIndentedString(currencies)).append("\n");
    sb.append("    sicCode: ").append(toIndentedString(sicCode)).append("\n");
    sb.append("    allowMultipleBills: ").append(toIndentedString(allowMultipleBills)).append("\n");
    sb.append("    allowMerchantDescriptorOverride: ").append(toIndentedString(allowMerchantDescriptorOverride)).append("\n");
    sb.append("    enhancedData: ").append(toIndentedString(enhancedData)).append("\n");
    sb.append("    fireSafetyIndicator: ").append(toIndentedString(fireSafetyIndicator)).append("\n");
    sb.append("    quasiCash: ").append(toIndentedString(quasiCash)).append("\n");
    sb.append("    acquirerMerchantId: ").append(toIndentedString(acquirerMerchantId)).append("\n");
    sb.append("    avsFormat: ").append(toIndentedString(avsFormat)).append("\n");
    sb.append("    enableLongTransRefNo: ").append(toIndentedString(enableLongTransRefNo)).append("\n");
    sb.append("    enableLevel2: ").append(toIndentedString(enableLevel2)).append("\n");
    sb.append("    enableMultipleTransactionAdviceAddendum: ").append(toIndentedString(enableMultipleTransactionAdviceAddendum)).append("\n");
    sb.append("    amexTransactionAdviceAddendum1: ").append(toIndentedString(amexTransactionAdviceAddendum1)).append("\n");
    sb.append("    enableMultiLineItems: ").append(toIndentedString(enableMultiLineItems)).append("\n");
    sb.append("    enableTransactionReferenceNumber: ").append(toIndentedString(enableTransactionReferenceNumber)).append("\n");
    sb.append("    enableAutoAuthReversalAfterVoid: ").append(toIndentedString(enableAutoAuthReversalAfterVoid)).append("\n");
    sb.append("    enableExpresspayPanTranslation: ").append(toIndentedString(enableExpresspayPanTranslation)).append("\n");
    sb.append("    enableCreditAuth: ").append(toIndentedString(enableCreditAuth)).append("\n");
    sb.append("    industryCode: ").append(toIndentedString(industryCode)).append("\n");
    sb.append("    sendAmexLevel2Data: ").append(toIndentedString(sendAmexLevel2Data)).append("\n");
    sb.append("    softDescriptorType: ").append(toIndentedString(softDescriptorType)).append("\n");
    sb.append("    vitalNumber: ").append(toIndentedString(vitalNumber)).append("\n");
    sb.append("    bankNumber: ").append(toIndentedString(bankNumber)).append("\n");
    sb.append("    chainNumber: ").append(toIndentedString(chainNumber)).append("\n");
    sb.append("    merchantBinNumber: ").append(toIndentedString(merchantBinNumber)).append("\n");
    sb.append("    merchantLocationNumber: ").append(toIndentedString(merchantLocationNumber)).append("\n");
    sb.append("    storeID: ").append(toIndentedString(storeID)).append("\n");
    sb.append("    travelAgencyCode: ").append(toIndentedString(travelAgencyCode)).append("\n");
    sb.append("    travelAgencyName: ").append(toIndentedString(travelAgencyName)).append("\n");
    sb.append("    settlementCurrency: ").append(toIndentedString(settlementCurrency)).append("\n");
    sb.append("    enableLeastCostRouting: ").append(toIndentedString(enableLeastCostRouting)).append("\n");
    sb.append("    enableCVVResponseIndicator: ").append(toIndentedString(enableCVVResponseIndicator)).append("\n");
    sb.append("    enableMultiCurrencyProcessing: ").append(toIndentedString(enableMultiCurrencyProcessing)).append("\n");
    sb.append("    enablePosNetworkSwitching: ").append(toIndentedString(enablePosNetworkSwitching)).append("\n");
    sb.append("    enableDynamicCurrencyConversion: ").append(toIndentedString(enableDynamicCurrencyConversion)).append("\n");
    sb.append("    merchantTier: ").append(toIndentedString(merchantTier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

