/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * CreateAccessTokenRequest
 */

public class CreateAccessTokenRequest {
    @SerializedName("grant_type")
    private String grantType = null;

    @SerializedName("code")
    private String code = null;

    @SerializedName("client_id")
    private String clientId = null;

    @SerializedName("client_secret")
    private String clientSecret = null;

    @SerializedName("refresh_token")
    private String refreshToken = null;


    public CreateAccessTokenRequest grantType(String grantType) {
        this.grantType = grantType;
        return this;
    }

    /**
     * Possible values - authorization_code if creating access_token by authorization_code, refresh_token if creating access_token by refresh_token
     * @return grantType
     **/
    @ApiModelProperty(value = "authorization_code if creating access_token by authorization_code, refresh_token if creating access_token by refresh_token")
    public String getGrantType() {
        return grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public CreateAccessTokenRequest code(String code) {
        this.code = code;
        return this;
    }

    /**
     * Active Authentication code, required if grant_type is authorization_code
     * @return code
     **/
    @ApiModelProperty(value = "Active Authentication code, required if grant_type is authorization_code")
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public CreateAccessTokenRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Indicate the client making the request for creating access token
     * @return clientId
     **/
    @ApiModelProperty(value = "Indicate the client making the request for creating access token")
    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreateAccessTokenRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     *  Guid, generated internally during Confidential client registration, required for Confidential client
     * @return clientSecret
     **/
    @ApiModelProperty(value = "Guid, generated internally during Confidential client registration, required for Confidential client")
    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public CreateAccessTokenRequest refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    /**
     * Should be active refresh_token, required if grantType is refresh_token
     * @return refreshToken
     **/
    @ApiModelProperty(value = "Should be active refresh_token, required if grantType is refresh_token")
    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccessTokenRequest createAccessTokenRequest = (CreateAccessTokenRequest) o;
        return Objects.equals(this.clientId, createAccessTokenRequest.clientId) &&
                Objects.equals(this.code, createAccessTokenRequest.code) &&
                Objects.equals(this.refreshToken, createAccessTokenRequest.refreshToken) &&
                Objects.equals(this.grantType, createAccessTokenRequest.grantType) &&
                Objects.equals(this.clientSecret, createAccessTokenRequest.clientSecret);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, code, refreshToken, grantType, clientSecret);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAccessTokenRequest {\n");

        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    code: ").append(toIndentedString(code)).append("\n");
        sb.append("    grantType: ").append(toIndentedString(grantType)).append("\n");
        sb.append("    refreshToken: ").append(toIndentedString(refreshToken)).append("\n");
        sb.append("    clientSecret: ").append(toIndentedString(clientSecret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}

