/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;
import java.io.InputStream;


import Model.InlineResponse400;
import Model.PatchPaymentInstrumentRequest;
import Model.PostPaymentInstrumentRequest;
import Model.Tmsv2customersEmbeddedDefaultPaymentInstrument;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaymentInstrumentApi {
    private static Logger logger = LogManager.getLogger(PaymentInstrumentApi.class);
    
    private ApiClient apiClient;

    public PaymentInstrumentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentInstrumentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deletePaymentInstrument
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call deletePaymentInstrumentCall(String paymentInstrumentTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tms/v1/paymentinstruments/{paymentInstrumentTokenId}"
            .replaceAll("\\{" + "paymentInstrumentTokenId" + "\\}", apiClient.escapeString(paymentInstrumentTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call deletePaymentInstrumentValidateBeforeCall(String paymentInstrumentTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'paymentInstrumentTokenId' is set
        if (paymentInstrumentTokenId == null) {
        	logger.error("Missing the required parameter 'paymentInstrumentTokenId' when calling deletePaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentTokenId' when calling deletePaymentInstrument(Async)");
        }
        
        
        okhttp3.Call call = deletePaymentInstrumentCall(paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Delete a Payment Instrument
     * 
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deletePaymentInstrument(String paymentInstrumentTokenId, String profileId) throws ApiException {
    	logger.info("CALL TO METHOD 'deletePaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        deletePaymentInstrumentWithHttpInfo(paymentInstrumentTokenId, profileId);
    }

    /**
     * Delete a Payment Instrument
     * 
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deletePaymentInstrumentWithHttpInfo(String paymentInstrumentTokenId, String profileId) throws ApiException {
        okhttp3.Call call = deletePaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, profileId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a Payment Instrument (asynchronously)
     * 
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call deletePaymentInstrumentAsync(String paymentInstrumentTokenId, String profileId, final ApiCallback<Void> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = deletePaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getPaymentInstrument
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call getPaymentInstrumentCall(String paymentInstrumentTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tms/v1/paymentinstruments/{paymentInstrumentTokenId}"
            .replaceAll("\\{" + "paymentInstrumentTokenId" + "\\}", apiClient.escapeString(paymentInstrumentTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPaymentInstrumentValidateBeforeCall(String paymentInstrumentTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'paymentInstrumentTokenId' is set
        if (paymentInstrumentTokenId == null) {
        	logger.error("Missing the required parameter 'paymentInstrumentTokenId' when calling getPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentTokenId' when calling getPaymentInstrument(Async)");
        }
        
        
        okhttp3.Call call = getPaymentInstrumentCall(paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Retrieve a Payment Instrument
     * 
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return Tmsv2customersEmbeddedDefaultPaymentInstrument
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tmsv2customersEmbeddedDefaultPaymentInstrument getPaymentInstrument(String paymentInstrumentTokenId, String profileId) throws ApiException {
    	logger.info("CALL TO METHOD 'getPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> resp = getPaymentInstrumentWithHttpInfo(paymentInstrumentTokenId, profileId);
        logger.info("CALL TO METHOD 'getPaymentInstrument' ENDED");
        return resp.getData();
    }

    /**
     * Retrieve a Payment Instrument
     * 
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return ApiResponse&lt;Tmsv2customersEmbeddedDefaultPaymentInstrument&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> getPaymentInstrumentWithHttpInfo(String paymentInstrumentTokenId, String profileId) throws ApiException {
        okhttp3.Call call = getPaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Retrieve a Payment Instrument (asynchronously)
     * 
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call getPaymentInstrumentAsync(String paymentInstrumentTokenId, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrument> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = getPaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for patchPaymentInstrument
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param patchPaymentInstrumentRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call patchPaymentInstrumentCall(String paymentInstrumentTokenId, PatchPaymentInstrumentRequest patchPaymentInstrumentRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = patchPaymentInstrumentRequest;
        
        // create path and map variables
        String localVarPath = "/tms/v1/paymentinstruments/{paymentInstrumentTokenId}"
            .replaceAll("\\{" + "paymentInstrumentTokenId" + "\\}", apiClient.escapeString(paymentInstrumentTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));
        if (ifMatch != null)
        localVarHeaderParams.put("if-match", apiClient.parameterToString(ifMatch));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call patchPaymentInstrumentValidateBeforeCall(String paymentInstrumentTokenId, PatchPaymentInstrumentRequest patchPaymentInstrumentRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'paymentInstrumentTokenId' is set
        if (paymentInstrumentTokenId == null) {
        	logger.error("Missing the required parameter 'paymentInstrumentTokenId' when calling patchPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentTokenId' when calling patchPaymentInstrument(Async)");
        }
        
        // verify the required parameter 'patchPaymentInstrumentRequest' is set
        if (patchPaymentInstrumentRequest == null) {
        	logger.error("Missing the required parameter 'patchPaymentInstrumentRequest' when calling patchPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'patchPaymentInstrumentRequest' when calling patchPaymentInstrument(Async)");
        }
        
        
        okhttp3.Call call = patchPaymentInstrumentCall(paymentInstrumentTokenId, patchPaymentInstrumentRequest, profileId, ifMatch, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Update a Payment Instrument
     * 
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param patchPaymentInstrumentRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @return Tmsv2customersEmbeddedDefaultPaymentInstrument
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tmsv2customersEmbeddedDefaultPaymentInstrument patchPaymentInstrument(String paymentInstrumentTokenId, PatchPaymentInstrumentRequest patchPaymentInstrumentRequest, String profileId, String ifMatch) throws ApiException {
    	logger.info("CALL TO METHOD 'patchPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> resp = patchPaymentInstrumentWithHttpInfo(paymentInstrumentTokenId, patchPaymentInstrumentRequest, profileId, ifMatch);
        logger.info("CALL TO METHOD 'patchPaymentInstrument' ENDED");
        return resp.getData();
    }

    /**
     * Update a Payment Instrument
     * 
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param patchPaymentInstrumentRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @return ApiResponse&lt;Tmsv2customersEmbeddedDefaultPaymentInstrument&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> patchPaymentInstrumentWithHttpInfo(String paymentInstrumentTokenId, PatchPaymentInstrumentRequest patchPaymentInstrumentRequest, String profileId, String ifMatch) throws ApiException {
        okhttp3.Call call = patchPaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, patchPaymentInstrumentRequest, profileId, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update a Payment Instrument (asynchronously)
     * 
     * @param paymentInstrumentTokenId The TokenId of a payment instrument. (required)
     * @param patchPaymentInstrumentRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call patchPaymentInstrumentAsync(String paymentInstrumentTokenId, PatchPaymentInstrumentRequest patchPaymentInstrumentRequest, String profileId, String ifMatch, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrument> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = patchPaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, patchPaymentInstrumentRequest, profileId, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postPaymentInstrument
     * @param postPaymentInstrumentRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call postPaymentInstrumentCall(PostPaymentInstrumentRequest postPaymentInstrumentRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = postPaymentInstrumentRequest;
        
        // create path and map variables
        String localVarPath = "/tms/v1/paymentinstruments";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call postPaymentInstrumentValidateBeforeCall(PostPaymentInstrumentRequest postPaymentInstrumentRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'postPaymentInstrumentRequest' is set
        if (postPaymentInstrumentRequest == null) {
        	logger.error("Missing the required parameter 'postPaymentInstrumentRequest' when calling postPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'postPaymentInstrumentRequest' when calling postPaymentInstrument(Async)");
        }
        
        
        okhttp3.Call call = postPaymentInstrumentCall(postPaymentInstrumentRequest, profileId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Create a Payment Instrument
     * Include an existing TMS Instrument Identifier id in the request body. * An Instrument Identifier token can be created by calling: **POST *_/tms/v1/instrumentidentifiers*** 
     * @param postPaymentInstrumentRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return Tmsv2customersEmbeddedDefaultPaymentInstrument
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tmsv2customersEmbeddedDefaultPaymentInstrument postPaymentInstrument(PostPaymentInstrumentRequest postPaymentInstrumentRequest, String profileId) throws ApiException {
    	logger.info("CALL TO METHOD 'postPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> resp = postPaymentInstrumentWithHttpInfo(postPaymentInstrumentRequest, profileId);
        logger.info("CALL TO METHOD 'postPaymentInstrument' ENDED");
        return resp.getData();
    }

    /**
     * Create a Payment Instrument
     * Include an existing TMS Instrument Identifier id in the request body. * An Instrument Identifier token can be created by calling: **POST *_/tms/v1/instrumentidentifiers*** 
     * @param postPaymentInstrumentRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return ApiResponse&lt;Tmsv2customersEmbeddedDefaultPaymentInstrument&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> postPaymentInstrumentWithHttpInfo(PostPaymentInstrumentRequest postPaymentInstrumentRequest, String profileId) throws ApiException {
        okhttp3.Call call = postPaymentInstrumentValidateBeforeCall(postPaymentInstrumentRequest, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a Payment Instrument (asynchronously)
     * Include an existing TMS Instrument Identifier id in the request body. * An Instrument Identifier token can be created by calling: **POST *_/tms/v1/instrumentidentifiers*** 
     * @param postPaymentInstrumentRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call postPaymentInstrumentAsync(PostPaymentInstrumentRequest postPaymentInstrumentRequest, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrument> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = postPaymentInstrumentValidateBeforeCall(postPaymentInstrumentRequest, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
