/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;
import java.io.InputStream;


import Model.InlineResponse400;
import Model.PatchInstrumentIdentifierRequest;
import Model.PaymentInstrumentList;
import Model.PostInstrumentIdentifierEnrollmentRequest;
import Model.PostInstrumentIdentifierRequest;
import Model.Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstrumentIdentifierApi {
    private static Logger logger = LogManager.getLogger(InstrumentIdentifierApi.class);
    
    private ApiClient apiClient;

    public InstrumentIdentifierApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InstrumentIdentifierApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteInstrumentIdentifier
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call deleteInstrumentIdentifierCall(String instrumentIdentifierTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tms/v1/instrumentidentifiers/{instrumentIdentifierTokenId}"
            .replaceAll("\\{" + "instrumentIdentifierTokenId" + "\\}", apiClient.escapeString(instrumentIdentifierTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteInstrumentIdentifierValidateBeforeCall(String instrumentIdentifierTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'instrumentIdentifierTokenId' is set
        if (instrumentIdentifierTokenId == null) {
        	logger.error("Missing the required parameter 'instrumentIdentifierTokenId' when calling deleteInstrumentIdentifier(Async)");
            throw new ApiException("Missing the required parameter 'instrumentIdentifierTokenId' when calling deleteInstrumentIdentifier(Async)");
        }
        
        
        okhttp3.Call call = deleteInstrumentIdentifierCall(instrumentIdentifierTokenId, profileId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Delete an Instrument Identifier
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteInstrumentIdentifier(String instrumentIdentifierTokenId, String profileId) throws ApiException {
    	logger.info("CALL TO METHOD 'deleteInstrumentIdentifier' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        deleteInstrumentIdentifierWithHttpInfo(instrumentIdentifierTokenId, profileId);

    }

    /**
     * Delete an Instrument Identifier
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteInstrumentIdentifierWithHttpInfo(String instrumentIdentifierTokenId, String profileId) throws ApiException {
        okhttp3.Call call = deleteInstrumentIdentifierValidateBeforeCall(instrumentIdentifierTokenId, profileId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete an Instrument Identifier (asynchronously)
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call deleteInstrumentIdentifierAsync(String instrumentIdentifierTokenId, String profileId, final ApiCallback<Void> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = deleteInstrumentIdentifierValidateBeforeCall(instrumentIdentifierTokenId, profileId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getInstrumentIdentifier
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call getInstrumentIdentifierCall(String instrumentIdentifierTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tms/v1/instrumentidentifiers/{instrumentIdentifierTokenId}"
            .replaceAll("\\{" + "instrumentIdentifierTokenId" + "\\}", apiClient.escapeString(instrumentIdentifierTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInstrumentIdentifierValidateBeforeCall(String instrumentIdentifierTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'instrumentIdentifierTokenId' is set
        if (instrumentIdentifierTokenId == null) {
        	logger.error("Missing the required parameter 'instrumentIdentifierTokenId' when calling getInstrumentIdentifier(Async)");
            throw new ApiException("Missing the required parameter 'instrumentIdentifierTokenId' when calling getInstrumentIdentifier(Async)");
        }
        
        
        okhttp3.Call call = getInstrumentIdentifierCall(instrumentIdentifierTokenId, profileId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Retrieve an Instrument Identifier
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier getInstrumentIdentifier(String instrumentIdentifierTokenId, String profileId) throws ApiException {
    	logger.info("CALL TO METHOD 'getInstrumentIdentifier' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier> resp = getInstrumentIdentifierWithHttpInfo(instrumentIdentifierTokenId, profileId);
        logger.info("CALL TO METHOD 'getInstrumentIdentifier' ENDED");
        return resp.getData();
    }

    /**
     * Retrieve an Instrument Identifier
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return ApiResponse&lt;Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier> getInstrumentIdentifierWithHttpInfo(String instrumentIdentifierTokenId, String profileId) throws ApiException {
        okhttp3.Call call = getInstrumentIdentifierValidateBeforeCall(instrumentIdentifierTokenId, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Retrieve an Instrument Identifier (asynchronously)
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call getInstrumentIdentifierAsync(String instrumentIdentifierTokenId, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = getInstrumentIdentifierValidateBeforeCall(instrumentIdentifierTokenId, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getInstrumentIdentifierPaymentInstrumentsList
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call getInstrumentIdentifierPaymentInstrumentsListCall(String instrumentIdentifierTokenId, String profileId, Long offset, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tms/v1/instrumentidentifiers/{instrumentIdentifierTokenId}/paymentinstruments"
            .replaceAll("\\{" + "instrumentIdentifierTokenId" + "\\}", apiClient.escapeString(instrumentIdentifierTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInstrumentIdentifierPaymentInstrumentsListValidateBeforeCall(String instrumentIdentifierTokenId, String profileId, Long offset, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'instrumentIdentifierTokenId' is set
        if (instrumentIdentifierTokenId == null) {
        	logger.error("Missing the required parameter 'instrumentIdentifierTokenId' when calling getInstrumentIdentifierPaymentInstrumentsList(Async)");
            throw new ApiException("Missing the required parameter 'instrumentIdentifierTokenId' when calling getInstrumentIdentifierPaymentInstrumentsList(Async)");
        }
        
        
        okhttp3.Call call = getInstrumentIdentifierPaymentInstrumentsListCall(instrumentIdentifierTokenId, profileId, offset, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * List Payment Instruments for an Instrument Identifier
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @return PaymentInstrumentList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PaymentInstrumentList getInstrumentIdentifierPaymentInstrumentsList(String instrumentIdentifierTokenId, String profileId, Long offset, Long limit) throws ApiException {
    	logger.info("CALL TO METHOD 'getInstrumentIdentifierPaymentInstrumentsList' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<PaymentInstrumentList> resp = getInstrumentIdentifierPaymentInstrumentsListWithHttpInfo(instrumentIdentifierTokenId, profileId, offset, limit);
        logger.info("CALL TO METHOD 'getInstrumentIdentifierPaymentInstrumentsList' ENDED");
        return resp.getData();
    }

    /**
     * List Payment Instruments for an Instrument Identifier
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @return ApiResponse&lt;PaymentInstrumentList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PaymentInstrumentList> getInstrumentIdentifierPaymentInstrumentsListWithHttpInfo(String instrumentIdentifierTokenId, String profileId, Long offset, Long limit) throws ApiException {
        okhttp3.Call call = getInstrumentIdentifierPaymentInstrumentsListValidateBeforeCall(instrumentIdentifierTokenId, profileId, offset, limit, null, null);
        Type localVarReturnType = new TypeToken<PaymentInstrumentList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List Payment Instruments for an Instrument Identifier (asynchronously)
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call getInstrumentIdentifierPaymentInstrumentsListAsync(String instrumentIdentifierTokenId, String profileId, Long offset, Long limit, final ApiCallback<PaymentInstrumentList> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = getInstrumentIdentifierPaymentInstrumentsListValidateBeforeCall(instrumentIdentifierTokenId, profileId, offset, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PaymentInstrumentList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for patchInstrumentIdentifier
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param patchInstrumentIdentifierRequest Specify the previous transaction ID to update. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call patchInstrumentIdentifierCall(String instrumentIdentifierTokenId, PatchInstrumentIdentifierRequest patchInstrumentIdentifierRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = patchInstrumentIdentifierRequest;
        
        // create path and map variables
        String localVarPath = "/tms/v1/instrumentidentifiers/{instrumentIdentifierTokenId}"
            .replaceAll("\\{" + "instrumentIdentifierTokenId" + "\\}", apiClient.escapeString(instrumentIdentifierTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));
        if (ifMatch != null)
        localVarHeaderParams.put("if-match", apiClient.parameterToString(ifMatch));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call patchInstrumentIdentifierValidateBeforeCall(String instrumentIdentifierTokenId, PatchInstrumentIdentifierRequest patchInstrumentIdentifierRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'instrumentIdentifierTokenId' is set
        if (instrumentIdentifierTokenId == null) {
        	logger.error("Missing the required parameter 'instrumentIdentifierTokenId' when calling patchInstrumentIdentifier(Async)");
            throw new ApiException("Missing the required parameter 'instrumentIdentifierTokenId' when calling patchInstrumentIdentifier(Async)");
        }
        
        // verify the required parameter 'patchInstrumentIdentifierRequest' is set
        if (patchInstrumentIdentifierRequest == null) {
        	logger.error("Missing the required parameter 'patchInstrumentIdentifierRequest' when calling patchInstrumentIdentifier(Async)");
            throw new ApiException("Missing the required parameter 'patchInstrumentIdentifierRequest' when calling patchInstrumentIdentifier(Async)");
        }
        
        
        okhttp3.Call call = patchInstrumentIdentifierCall(instrumentIdentifierTokenId, patchInstrumentIdentifierRequest, profileId, ifMatch, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Update an Instrument Identifier
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param patchInstrumentIdentifierRequest Specify the previous transaction ID to update. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @return Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier patchInstrumentIdentifier(String instrumentIdentifierTokenId, PatchInstrumentIdentifierRequest patchInstrumentIdentifierRequest, String profileId, String ifMatch) throws ApiException {
    	logger.info("CALL TO METHOD 'patchInstrumentIdentifier' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier> resp = patchInstrumentIdentifierWithHttpInfo(instrumentIdentifierTokenId, patchInstrumentIdentifierRequest, profileId, ifMatch);
        logger.info("CALL TO METHOD 'patchInstrumentIdentifier' ENDED");
        return resp.getData();
    }

    /**
     * Update an Instrument Identifier
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param patchInstrumentIdentifierRequest Specify the previous transaction ID to update. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @return ApiResponse&lt;Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier> patchInstrumentIdentifierWithHttpInfo(String instrumentIdentifierTokenId, PatchInstrumentIdentifierRequest patchInstrumentIdentifierRequest, String profileId, String ifMatch) throws ApiException {
        okhttp3.Call call = patchInstrumentIdentifierValidateBeforeCall(instrumentIdentifierTokenId, patchInstrumentIdentifierRequest, profileId, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update an Instrument Identifier (asynchronously)
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param patchInstrumentIdentifierRequest Specify the previous transaction ID to update. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call patchInstrumentIdentifierAsync(String instrumentIdentifierTokenId, PatchInstrumentIdentifierRequest patchInstrumentIdentifierRequest, String profileId, String ifMatch, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = patchInstrumentIdentifierValidateBeforeCall(instrumentIdentifierTokenId, patchInstrumentIdentifierRequest, profileId, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postInstrumentIdentifier
     * @param postInstrumentIdentifierRequest Specify either a Card, Bank Account or Enrollable Card (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call postInstrumentIdentifierCall(PostInstrumentIdentifierRequest postInstrumentIdentifierRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = postInstrumentIdentifierRequest;
        
        // create path and map variables
        String localVarPath = "/tms/v1/instrumentidentifiers";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call postInstrumentIdentifierValidateBeforeCall(PostInstrumentIdentifierRequest postInstrumentIdentifierRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'postInstrumentIdentifierRequest' is set
        if (postInstrumentIdentifierRequest == null) {
        	logger.error("Missing the required parameter 'postInstrumentIdentifierRequest' when calling postInstrumentIdentifier(Async)");
            throw new ApiException("Missing the required parameter 'postInstrumentIdentifierRequest' when calling postInstrumentIdentifier(Async)");
        }
        
        
        okhttp3.Call call = postInstrumentIdentifierCall(postInstrumentIdentifierRequest, profileId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Create an Instrument Identifier
     * 
     * @param postInstrumentIdentifierRequest Specify either a Card, Bank Account or Enrollable Card (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier postInstrumentIdentifier(PostInstrumentIdentifierRequest postInstrumentIdentifierRequest, String profileId) throws ApiException {
    	logger.info("CALL TO METHOD 'postInstrumentIdentifier' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier> resp = postInstrumentIdentifierWithHttpInfo(postInstrumentIdentifierRequest, profileId);
        logger.info("CALL TO METHOD 'postInstrumentIdentifier' ENDED");
        return resp.getData();
    }

    /**
     * Create an Instrument Identifier
     * 
     * @param postInstrumentIdentifierRequest Specify either a Card, Bank Account or Enrollable Card (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return ApiResponse&lt;Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier> postInstrumentIdentifierWithHttpInfo(PostInstrumentIdentifierRequest postInstrumentIdentifierRequest, String profileId) throws ApiException {
        okhttp3.Call call = postInstrumentIdentifierValidateBeforeCall(postInstrumentIdentifierRequest, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create an Instrument Identifier (asynchronously)
     * 
     * @param postInstrumentIdentifierRequest Specify either a Card, Bank Account or Enrollable Card (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call postInstrumentIdentifierAsync(PostInstrumentIdentifierRequest postInstrumentIdentifierRequest, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = postInstrumentIdentifierValidateBeforeCall(postInstrumentIdentifierRequest, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postInstrumentIdentifierEnrollment
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param postInstrumentIdentifierEnrollmentRequest Specify Enrollable Card details (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call postInstrumentIdentifierEnrollmentCall(String instrumentIdentifierTokenId, PostInstrumentIdentifierEnrollmentRequest postInstrumentIdentifierEnrollmentRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = postInstrumentIdentifierEnrollmentRequest;
        
        // create path and map variables
        String localVarPath = "/tms/v1/instrumentidentifiers/{instrumentIdentifierTokenId}/enrollment"
            .replaceAll("\\{" + "instrumentIdentifierTokenId" + "\\}", apiClient.escapeString(instrumentIdentifierTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call postInstrumentIdentifierEnrollmentValidateBeforeCall(String instrumentIdentifierTokenId, PostInstrumentIdentifierEnrollmentRequest postInstrumentIdentifierEnrollmentRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'instrumentIdentifierTokenId' is set
        if (instrumentIdentifierTokenId == null) {
        	logger.error("Missing the required parameter 'instrumentIdentifierTokenId' when calling postInstrumentIdentifierEnrollment(Async)");
            throw new ApiException("Missing the required parameter 'instrumentIdentifierTokenId' when calling postInstrumentIdentifierEnrollment(Async)");
        }
        
        // verify the required parameter 'postInstrumentIdentifierEnrollmentRequest' is set
        if (postInstrumentIdentifierEnrollmentRequest == null) {
        	logger.error("Missing the required parameter 'postInstrumentIdentifierEnrollmentRequest' when calling postInstrumentIdentifierEnrollment(Async)");
            throw new ApiException("Missing the required parameter 'postInstrumentIdentifierEnrollmentRequest' when calling postInstrumentIdentifierEnrollment(Async)");
        }
        
        
        okhttp3.Call call = postInstrumentIdentifierEnrollmentCall(instrumentIdentifierTokenId, postInstrumentIdentifierEnrollmentRequest, profileId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Enroll an Instrument Identifier for Network Tokenization
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param postInstrumentIdentifierEnrollmentRequest Specify Enrollable Card details (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void postInstrumentIdentifierEnrollment(String instrumentIdentifierTokenId, PostInstrumentIdentifierEnrollmentRequest postInstrumentIdentifierEnrollmentRequest, String profileId) throws ApiException {
    	logger.info("CALL TO METHOD 'postInstrumentIdentifierEnrollment' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        postInstrumentIdentifierEnrollmentWithHttpInfo(instrumentIdentifierTokenId, postInstrumentIdentifierEnrollmentRequest, profileId);

    }

    /**
     * Enroll an Instrument Identifier for Network Tokenization
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param postInstrumentIdentifierEnrollmentRequest Specify Enrollable Card details (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> postInstrumentIdentifierEnrollmentWithHttpInfo(String instrumentIdentifierTokenId, PostInstrumentIdentifierEnrollmentRequest postInstrumentIdentifierEnrollmentRequest, String profileId) throws ApiException {
        okhttp3.Call call = postInstrumentIdentifierEnrollmentValidateBeforeCall(instrumentIdentifierTokenId, postInstrumentIdentifierEnrollmentRequest, profileId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Enroll an Instrument Identifier for Network Tokenization (asynchronously)
     * 
     * @param instrumentIdentifierTokenId The TokenId of a Instrument Identifier. (required)
     * @param postInstrumentIdentifierEnrollmentRequest Specify Enrollable Card details (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call postInstrumentIdentifierEnrollmentAsync(String instrumentIdentifierTokenId, PostInstrumentIdentifierEnrollmentRequest postInstrumentIdentifierEnrollmentRequest, String profileId, final ApiCallback<Void> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = postInstrumentIdentifierEnrollmentValidateBeforeCall(instrumentIdentifierTokenId, postInstrumentIdentifierEnrollmentRequest, profileId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
