/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.cache;

import com.cybersource.authsdk.cache.CachedJWEPrivateKey;
import com.cybersource.authsdk.cache.Identity;
import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.JWEUtility;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cache {
    private static Logger logger = LogManager.getLogger(Cache.class);
    public static boolean isCache = false;
    public static long lastModifiedTime;
    public static ConcurrentHashMap<String, Identity> cacheP12;
    public static ConcurrentHashMap<String, CachedJWEPrivateKey> cachePEM;
    private boolean isTimeStamp;
    private MerchantConfig merchantConfig;
    private Identity identity = new Identity();
    private CachedJWEPrivateKey cachedJWEPrivateKey = new CachedJWEPrivateKey();
    private X509Certificate x509Certificate;
    private RSAPrivateKey rsaPrivateKey;
    private String merchantID;
    private String accessToken;
    private String refreshToken;

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRsaPrivateKey(RSAPrivateKey rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public RSAPrivateKey getRsaPrivateKey() {
        return this.rsaPrivateKey;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public Cache(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
        logger = LogManager.getLogger(this.getClass());
        this.merchantID = merchantConfig.getMerchantID();
        isCache = cacheP12.isEmpty();
    }

    public void setP12FileDetailsInCache() throws ConfigException {
        if (cacheP12.isEmpty()) {
            this.setUpP12Cache();
        } else {
            this.isTimeStamp = this.isLastModifiedTimeP12();
            if (this.isTimeStamp) {
                this.retrieveP12DataFromCache();
            } else {
                this.setUpP12Cache();
            }
        }
    }

    public void setUpP12Cache() throws ConfigException {
        this.identity.setLastModifiedDate(this.getLastModifiedFileTime(this.merchantConfig.getKeyFile().getAbsolutePath()));
        this.identity.setX509(this.x509Certificate);
        this.identity.setRsaPrivateKey(this.rsaPrivateKey);
        String tempMerchantID = this.merchantConfig.getMerchantID();
        cacheP12.put(tempMerchantID, this.identity);
        lastModifiedTime = this.merchantConfig.getKeyFile().lastModified();
    }

    public void retrieveP12DataFromCache() {
        Identity tempIdentity = cacheP12.get(this.merchantID);
        if (tempIdentity != null) {
            this.x509Certificate = tempIdentity.getX509();
            this.rsaPrivateKey = tempIdentity.getRsaPrivateKey();
        }
    }

    public boolean isLastModifiedTimeP12() {
        Identity tempIdentity = cacheP12.get(this.merchantID);
        if (tempIdentity != null) {
            long tempLastModifiedTime = tempIdentity.getLastModifiedDate();
            return lastModifiedTime == tempLastModifiedTime;
        }
        return false;
    }

    public PrivateKey getJWECachedPrivateKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        CachedJWEPrivateKey cachedJWEPrivateKey;
        if (cachePEM.isEmpty()) {
            this.setUpPEMCache();
        } else {
            cachedJWEPrivateKey = cachePEM.get("privateKeyFromPEMFile");
            if (cachedJWEPrivateKey.getLastModifiedTimeStamp() != this.getLastModifiedFileTime(this.merchantConfig.getPemFileDirectory())) {
                this.setUpPEMCache();
            }
        }
        cachedJWEPrivateKey = cachePEM.get("privateKeyFromPEMFile");
        return cachedJWEPrivateKey.getPrivateKey();
    }

    private void setUpPEMCache() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey privateKey = JWEUtility.readPemFileToGetPrivateKey(this.merchantConfig.getPemFileDirectory());
        long lastModifiedTime = this.getLastModifiedFileTime(this.merchantConfig.getPemFileDirectory());
        this.cachedJWEPrivateKey.setLastModifiedTimeStamp(lastModifiedTime);
        this.cachedJWEPrivateKey.setPrivateKey(privateKey);
        cachePEM.put("privateKeyFromPEMFile", this.cachedJWEPrivateKey);
    }

    public long getLastModifiedFileTime(String path) {
        try {
            File f = new File(path);
            return f.lastModified();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return (Long)null;
        }
    }

    static {
        cacheP12 = new ConcurrentHashMap();
        cachePEM = new ConcurrentHashMap();
    }
}

