/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.log;

import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.Utility;
import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;

public class Log4j {
    private String standardSize;
    private String filePath = null;
    private static volatile Logger logger = null;
    private String logDirectory;
    private String logFileName;
    private String logSize;
    public static boolean logName = false;

    private Log4j(MerchantConfig merchantConfig) {
        this.logDirectory = merchantConfig.getLogDirectory();
        this.logFileName = merchantConfig.getLogFilename();
        this.logSize = merchantConfig.getLogMaximumSize();
        this.checkLogMaxSizeAndFolder();
        this.filePath = this.logDirectory + "/" + this.logFileName + ".log";
        this.standardSize = merchantConfig.getLogMaximumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Logger getInstance(MerchantConfig merchantConfig) {
        if (logger != null) return logger;
        Utility.logEnable = merchantConfig.getEnableLog();
        Class<Log4j> clazz = Log4j.class;
        synchronized (Log4j.class) {
            if (!merchantConfig.getEnableLog() || logger != null) return logger;
            logger = new Log4j(merchantConfig).getLogger();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return logger;
        }
    }

    private Logger getLogger() {
        this.addAppenderLogger(this.filePath, Level.ALL);
        Logger logger = LogManager.getRootLogger();
        return logger;
    }

    public void addAppenderLogger(String filePath, Level vlevel) {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR);
        builder.setConfigurationName("RollingBuilder");
        LayoutComponentBuilder layoutBuilder = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d{yyy-MM-dd HH:mm:ss.SSS} [%t] %-5level %logger{36} - %msg%n");
        ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", this.standardSize));
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("rolling", "RollingFile").addAttribute("fileName", filePath)).addAttribute("filePattern", this.logDirectory + "/ " + this.logFileName + "_%d{yyyyMMddhhmmss}" + ".log")).add(layoutBuilder).addComponent(triggeringPolicy);
        builder.add(appenderBuilder);
        builder.add((RootLoggerComponentBuilder)((RootLoggerComponentBuilder)builder.newRootLogger(vlevel).add(builder.newAppenderRef("rolling"))).addAttribute("additivity", false));
        Configurator.initialize((Configuration)((Configuration)builder.build()));
    }

    private void checkLogMaxSizeAndFolder() {
        try {
            File dir;
            if (this.logDirectory == null || this.logDirectory.isEmpty()) {
                this.logDirectory = "log";
            }
            if (!(dir = new File(this.logDirectory)).isDirectory()) {
                this.logDirectory = "log";
            }
        }
        catch (Exception e) {
            this.logDirectory = "log";
        }
        try {
            if (this.logFileName == null || this.logFileName.isEmpty()) {
                this.logFileName = "cybs";
            }
        }
        catch (Exception e) {
            this.logDirectory = "cybs";
        }
        if (this.logSize == null || this.logSize.isEmpty()) {
            this.logSize = "5K";
        }
    }
}

