/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.http;

import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.core.TokenGenerator;
import com.cybersource.authsdk.http.SignatureGenerator;
import com.cybersource.authsdk.log.Log4j;
import com.cybersource.authsdk.util.Utility;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.Logger;

public class HttpSignatureToken
implements TokenGenerator {
    private MerchantConfig merchantConfigSigHead = null;
    private StringBuilder signatureHeader;
    private String merchantkeyId = null;
    private String merchantSecertKey = null;
    private String httpMethod = null;
    private String httpMerchantID = null;
    private String requestData = null;
    private Logger logger;

    public HttpSignatureToken(MerchantConfig merchantConfig) {
        this.merchantConfigSigHead = merchantConfig;
        this.merchantkeyId = merchantConfig.getMerchantKeyId();
        this.merchantSecertKey = merchantConfig.getMerchantSecretKey();
        this.httpMethod = merchantConfig.getRequestType();
        this.httpMerchantID = merchantConfig.getMerchantID();
        this.logger = Log4j.getInstance(merchantConfig);
    }

    @Override
    public String getToken() {
        String signature = null;
        try {
            signature = this.signatureHeader();
        }
        catch (NoSuchAlgorithmException e) {
            Utility.log(this.logger, e);
        }
        catch (InvalidKeyException e) {
            Utility.log(this.logger, e);
        }
        return signature;
    }

    private String signatureHeader() throws InvalidKeyException, NoSuchAlgorithmException {
        this.signatureHeader = new StringBuilder();
        this.signatureHeader.append("keyid=\"" + this.merchantkeyId + "\"");
        this.signatureHeader.append(", algorithm=\"HmacSHA256\"");
        if (this.httpMethod.equalsIgnoreCase("GET")) {
            this.signatureHeader.append(", headers=\"" + this.getRequestHeaders("GET") + "\"");
        }
        if (this.httpMethod.equalsIgnoreCase("DELETE")) {
            this.signatureHeader.append(", headers=\"" + this.getRequestHeaders("DELETE") + "\"");
        }
        if (this.httpMethod.equalsIgnoreCase("POST")) {
            this.signatureHeader.append(", headers=\"" + this.getRequestHeaders("POST") + "\"");
        } else if (this.httpMethod.equalsIgnoreCase("PUT")) {
            this.signatureHeader.append(", headers=\"" + this.getRequestHeaders("PUT") + "\"");
        }
        String signatureValue = new SignatureGenerator(this.merchantConfigSigHead).signatureGeneration();
        this.signatureHeader.append(", signature=\"" + signatureValue + "\"");
        return this.signatureHeader.toString();
    }

    private String getRequestHeaders(String requestType) {
        String requestHeader = null;
        switch (requestType) {
            case "GET": {
                requestHeader = "host date (request-target) v-c-merchant-id";
                break;
            }
            case "DELETE": {
                requestHeader = "host date (request-target) v-c-merchant-id";
                break;
            }
            case "POST": {
                requestHeader = "host date (request-target) digest v-c-merchant-id";
                break;
            }
            case "PUT": {
                requestHeader = "host date (request-target) digest v-c-merchant-id";
                break;
            }
            default: {
                return requestHeader;
            }
        }
        return requestHeader;
    }
}

