/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.core;

import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.log.Log4j;
import com.cybersource.authsdk.util.PropertiesUtil;
import com.cybersource.authsdk.util.Utility;
import java.io.File;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class MerchantConfig {
    private Properties props;
    private String keysDirectory;
    private String keyAlias;
    private String keyPass;
    private String keyType;
    private String keyFilename;
    private String password;
    private boolean enableLog;
    private int timeout;
    private String proxyUser;
    private String proxyPassword;
    private String recipientID;
    private String effectivePassword;
    private String requestData;
    private String runEnvironment;
    private String proxyAddress;
    private int proxyPort;
    private File keyFile;
    private boolean isRequestType = false;
    public static boolean isSetMerchantDetails = true;
    private String merchantKeyId;
    private String merchantSecretKey;
    private String merchantID;
    private String url;
    private String requestTarget;
    private String authenticationType;
    private boolean sendToProduction;
    private String getID;
    private String requestHost;
    private String responseMessage;
    private String responseCode;
    private String vcCorelationID;
    private String requestType;
    private boolean isRequestJson = true;
    private Logger log;
    private boolean logSignedData;
    private String logDirectory;
    private String logFilename;
    private String logMaximumSize;
    private String date;
    private String requestJsonPath;
    private String urlRequestHeader;

    public void setRunEnvironment(String runEnvironment) {
        this.runEnvironment = runEnvironment;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public boolean isRequestJson() {
        return this.isRequestJson;
    }

    public String getRequestData() {
        try {
            if (this.getRequestJsonPath().equalsIgnoreCase("not required")) {
                return this.requestData;
            }
            if (this.getRequestJsonPath() != null && !this.getRequestJsonPath().isEmpty()) {
                this.requestData = PropertiesUtil.getJsonInput(this.getRequestJsonPath());
            }
        }
        catch (Exception e) {
            Utility.log(this.log, "File not found, Entered path/file name :: ", this.getRequestJsonPath(), Level.FATAL);
            Utility.log(this.log, e);
            return null;
        }
        return this.requestData;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    public String getVcCorelationID() {
        return this.vcCorelationID;
    }

    public void setVcCorelationID(String vcCorelationID) {
        this.vcCorelationID = vcCorelationID;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) throws NullPointerException {
        this.responseMessage = responseMessage;
    }

    public String getUrlRequestHeader() {
        return this.urlRequestHeader;
    }

    public void setUrlRequestHeader(String urlRequestHeader) {
        this.urlRequestHeader = urlRequestHeader;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public String getRequestJsonPath() {
        return this.requestJsonPath;
    }

    public void setRequestJsonPath(String requestJsonPath) {
        this.requestJsonPath = requestJsonPath;
    }

    public String getGetID() {
        return this.getID;
    }

    public String getMerchantSecretKey() {
        return this.merchantSecretKey;
    }

    public String getMerchantKeyId() {
        return this.merchantKeyId;
    }

    public String getDate() {
        return this.date;
    }

    public String getMerchantID() {
        return this.merchantID;
    }

    public void setRecipientID(String recipientID) {
        this.recipientID = recipientID;
    }

    public String getRecipientID() {
        return this.recipientID;
    }

    public String getKeysDirectory() {
        return this.keysDirectory;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    public boolean getrequestJson() {
        return false;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void setMerchantID(String merchantID) {
        this.merchantID = merchantID;
    }

    public String getKey() {
        return this.keyPass;
    }

    public String getKeyType() {
        return this.keyType != null ? this.keyType : "p12";
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public boolean getSendToProduction() {
        return this.sendToProduction;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRequestTarget() {
        return this.requestTarget;
    }

    public void setRequestTarget(String requestTarget) {
        this.requestTarget = requestTarget;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getEnableLog() {
        return this.enableLog;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setKeysDirectory(String keysDirectory) {
        this.keysDirectory = keysDirectory;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setKeyFilename(String keyFilename) {
        this.keyFilename = keyFilename;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setEffectivePassword(String effectivePassword) {
        this.effectivePassword = effectivePassword;
    }

    public void setSendToProduction(boolean sendToProduction) {
        this.sendToProduction = sendToProduction;
    }

    public void setGetID(String getID) {
        this.getID = getID;
    }

    public void setRequestHost(String requestHost) {
        this.requestHost = requestHost;
    }

    public void setRequestJson(boolean isRequestJson) {
        this.isRequestJson = isRequestJson;
    }

    public void setLogSignedData(boolean logSignedData) {
        this.logSignedData = logSignedData;
    }

    public void setLogMaximumSize(String logMaximumSize) {
        this.logMaximumSize = logMaximumSize;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setEnableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }

    public boolean getLogSignedData() {
        return this.logSignedData;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public String getLogMaximumSize() {
        return this.logMaximumSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword != null ? this.proxyPassword : "";
    }

    public String getEffectivePassword() {
        return this.effectivePassword;
    }

    public void setLogFilename(String logFilename) {
        this.logFilename = logFilename;
    }

    public MerchantConfig() throws ConfigException {
    }

    public void setIsRequestType(boolean b) {
        this.isRequestType = b;
    }

    public MerchantConfig(Properties _props) throws ConfigException {
        if (_props != null) {
            this.props = _props;
            this.merchantID = this.props.getProperty("merchantID");
            this.date = this.date();
            this.setMerchantDetails();
        }
    }

    public boolean validateMerchantDetails(Logger logger) throws ConfigException {
        this.log = logger;
        this.isRequestType = this.checkRequestType();
        boolean isMerchantId = true;
        boolean isCheckMerchantSecertKey = false;
        boolean isCheckMerchantKeyId = false;
        boolean isGetKeyAlias = false;
        boolean isCheckKeyPassword = false;
        boolean isCheckKeyFile = false;
        boolean isCheckLogMaxSize = true;
        boolean isMerchantDetailStatus = false;
        this.checkAuthenticationType();
        isMerchantId = this.checkMerchantId();
        if (this.authenticationType.equalsIgnoreCase("HTTP_Signature")) {
            isCheckMerchantSecertKey = this.checkMerchantSecertKey();
            isCheckMerchantKeyId = this.checkMerchantKeyId();
        } else if (this.authenticationType.equalsIgnoreCase("JWT") || this.authenticationType.equalsIgnoreCase("JWE")) {
            isGetKeyAlias = this.checkKeyAlias();
            isCheckKeyPassword = this.checkKeyPassword();
            isCheckKeyFile = this.checkKeyFile();
        }
        boolean isCheckJsonPath = this.checkJsonPath(this.getRequestJsonPath());
        isCheckLogMaxSize = this.checkLogMaxSizeAndFolder();
        boolean isCheckRunEnvironment = this.checkRunEvironment();
        if (this.authenticationType.equalsIgnoreCase("HTTP_Signature")) {
            isMerchantDetailStatus = isMerchantId && isCheckMerchantSecertKey && isCheckMerchantKeyId && isCheckJsonPath && isCheckLogMaxSize && isCheckRunEnvironment && this.isRequestType && isSetMerchantDetails;
        } else if (this.authenticationType.equalsIgnoreCase("JWT")) {
            isMerchantDetailStatus = isMerchantId && isGetKeyAlias && isCheckKeyPassword && isCheckKeyFile && isCheckJsonPath && isCheckLogMaxSize && isCheckRunEnvironment && this.isRequestType && isSetMerchantDetails;
        }
        return isMerchantDetailStatus;
    }

    public boolean checkRequestType() throws ConfigException {
        if (this.requestType.equalsIgnoreCase("PUT") || this.requestType.equalsIgnoreCase("GET") || this.requestType.equalsIgnoreCase("POST") || this.requestType.equalsIgnoreCase("DELETE")) {
            return true;
        }
        Utility.log(this.log, "Invalid Request Type :: ", this.requestType, Level.ERROR);
        throw new ConfigException("Invalid Request Type :: ");
    }

    public boolean checkKeyPassword() throws ConfigException {
        if (this.keyPass == null || this.keyPass.isEmpty()) {
            Utility.log(this.log, "KeyPassword Empty/Null. Assigning merchantID value", "", Level.ERROR);
            throw new ConfigException("KeyPassword Empty/Null. Assigning merchantID value");
        }
        return true;
    }

    public boolean checkRunEvironment() throws ConfigException {
        boolean runEnvironment = false;
        if (this.runEnvironment.equalsIgnoreCase("CyberSource.Environment.SANDBOX") || this.runEnvironment.equalsIgnoreCase("CyberSource.Environment.PRODUCTION")) {
            runEnvironment = true;
        } else {
            if (this.runEnvironment == null || this.runEnvironment.isEmpty()) {
                Utility.log(this.log, "Run Environment value is missing in cybs.properties", "", Level.ERROR);
                throw new ConfigException("Run Environment value is missing in cybs.properties");
            }
            runEnvironment = true;
        }
        return runEnvironment;
    }

    public boolean checkMerchantKeyId() throws ConfigException {
        if (this.merchantKeyId == null || this.merchantKeyId.isEmpty()) {
            Utility.log(this.log, "Merchant KeyID missing/null, check cybs.properties", "", Level.ERROR);
            throw new ConfigException("Merchant KeyID missing/null, check cybs.properties");
        }
        return true;
    }

    public void setMerchantKeyId(String merchantKeyId) {
        this.merchantKeyId = merchantKeyId;
    }

    public boolean checkMerchantSecertKey() throws ConfigException {
        if (this.merchantSecretKey == null || this.merchantSecretKey.isEmpty()) {
            Utility.log(this.log, "Merchant Secret Key missing/null, check cybs.properties", "", Level.ERROR);
            throw new ConfigException("Merchant Secret Key missing/null, check cybs.properties");
        }
        return true;
    }

    public void setMerchantSecretKey(String merchantsecretKey) {
        this.merchantSecretKey = merchantsecretKey;
    }

    public boolean checkLogMaxSizeAndFolder() throws ConfigException {
        if (this.logDirectory == null || this.logDirectory.isEmpty()) {
            Utility.log(this.log, "No log directory, setting default directory path.", "", Level.ERROR);
            this.logDirectory = "log";
            throw new ConfigException("No log directory, setting default directory path.");
        }
        return this.getLogFile();
    }

    public boolean checkJsonPath(String jsonPath) throws ConfigException {
        File f = null;
        boolean check = true;
        if (!this.isRequestType) {
            return false;
        }
        if (this.requestType.equalsIgnoreCase("GET") || this.requestType.equalsIgnoreCase("DELETE")) {
            return check;
        }
        if (jsonPath.equalsIgnoreCase("not required")) {
            return check;
        }
        if (jsonPath == null || jsonPath.isEmpty()) {
            Utility.log(this.log, "Request Json File Missing/Null", "", Level.ERROR);
            check = false;
            throw new ConfigException("Request Json File Missing/Null");
        }
        f = new File(jsonPath);
        if (!f.exists()) {
            Utility.log(this.log, "Request Json File missing. File Path :: ", f.getAbsolutePath(), Level.ERROR);
            check = false;
            throw new ConfigException("Request Json File missing. File Path :: ");
        }
        if (!f.canRead()) {
            Utility.log(this.log, "File cannot be read permission denied :: ", f.getAbsolutePath(), Level.ERROR);
            check = false;
            throw new ConfigException("File cannot be read permission denied :: ");
        }
        this.isRequestJson = true;
        return check;
    }

    public boolean checkKeyAlias() throws ConfigException {
        if (this.keyAlias == null || this.keyAlias.isEmpty()) {
            Utility.log(this.log, "KeyAlias Empty/Null. Assigning merchantID value :: ", this.merchantID, Level.ERROR);
            this.keyAlias = this.merchantID;
            throw new ConfigException("KeyAlias Empty/Null. Assigning merchantID value :: ");
        }
        if (!this.keyAlias.equalsIgnoreCase(this.merchantID)) {
            this.keyAlias = this.merchantID;
            Utility.log(this.log, "KeyAlias Mismatch. Assigning merchantID value ", "", Level.ERROR);
            throw new ConfigException("KeyAlias Mismatch. Assigning merchantID value ");
        }
        return true;
    }

    public void setMerchantDetails() {
        this.authenticationType = this.getProperty(this.merchantID, "authenticationType").trim();
        this.logDirectory = this.getProperty(this.merchantID, "logDirectory").trim();
        this.logFilename = this.getProperty(this.merchantID, "logFilename").trim();
        this.logMaximumSize = this.getProperty(this.merchantID, "logMaximumSize").trim();
        this.keysDirectory = this.getProperty(this.merchantID, "keysDirectory").trim();
        this.keyAlias = this.getProperty(this.merchantID, "keyAlias").trim();
        this.keyPass = this.getProperty(this.merchantID, "keyPass");
        this.keyFilename = this.getProperty(this.merchantID, "keyFileName").trim();
        this.enableLog = this.checkBooleanLogValue(this.merchantID, "enableLog");
        this.timeout = this.getIntegerProperty(this.merchantID, "timeout", 130);
        this.proxyPort = this.getIntegerProperty(this.merchantID, "proxyPort", 8080);
        this.proxyPassword = this.getProperty(this.merchantID, "proxyPassword");
        this.proxyAddress = this.getProperty(this.merchantID, "proxyAddress");
        this.merchantKeyId = this.getProperty(this.merchantID, "merchantKeyId").trim();
        this.merchantSecretKey = this.getProperty(this.merchantID, "merchantsecretKey").trim();
        this.runEnvironment = this.getProperty(this.merchantID, "runEnvironment").trim();
        try {
            this.requestHost = this.runEnvironment.equalsIgnoreCase("CyberSource.Environment.SANDBOX") ? "apitest.cybersource.com" : (this.runEnvironment.equalsIgnoreCase("CyberSource.Environment.PRODUCTION") ? "api.cybersource.com" : this.runEnvironment);
        }
        catch (Exception e) {
            this.log = Log4j.getInstance(this);
            Utility.log(this.log, "********* START *********", "", Level.INFO);
            Utility.log(this.log, "Run Environment mandatory : NO Run Environment entered. ", "", Level.ERROR);
            isSetMerchantDetails = false;
        }
    }

    private boolean checkAuthenticationType() throws ConfigException {
        boolean check = true;
        if (this.authenticationType == null || this.authenticationType.isEmpty()) {
            this.log = Log4j.getInstance(this);
            Utility.log(this.log, "********* START *********", "", Level.INFO);
            Utility.log(this.log, "Authentication type is mandatory", "", Level.ERROR);
            check = false;
            throw new ConfigException("Authentication type is mandatory");
        }
        return check;
    }

    public boolean checkMerchantId() throws ConfigException {
        boolean check = true;
        if (this.merchantID == null || this.merchantID.isEmpty()) {
            this.log = Log4j.getInstance(this);
            Utility.log(this.log, "********* START *********", "", Level.INFO);
            Utility.log(this.log, "MerchantID mandatory : NO MerchantID entered. ", "", Level.ERROR);
            check = false;
            throw new ConfigException("MerchantID mandatory : NO MerchantID entered. ");
        }
        return check;
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    public boolean checkKeyFile() throws ConfigException {
        this.keyFile = null;
        if (this.keyFilename == null || this.keyFilename.isEmpty()) {
            Utility.log(this.log, "KeyFileName is empty, assigning merchantID value :: ", this.merchantID, Level.ERROR);
            if (this.merchantID != null) {
                this.keyFilename = this.merchantID;
            }
            throw new ConfigException("KeyFileName is empty, assigning merchantID value :: ");
        }
        if (this.keysDirectory.isEmpty() || this.keysDirectory == null) {
            Utility.log(this.log, "Key Directory is empty, assigning default path :: src/main/resources", "", Level.ERROR);
            this.keysDirectory = "src/main/resources";
            throw new ConfigException("Key Directory is empty, assigning default path :: src/main/resources");
        }
        this.keyFile = new File(this.keysDirectory);
        if (!this.keyFile.isDirectory()) {
            Utility.log(this.log, "KeyDirectory not found, Entered directory :: ", this.keysDirectory, Level.ERROR);
            this.keyFile = null;
            return false;
        }
        try {
            this.keyFile = new File(this.keysDirectory, this.keyFilename.concat(".p12"));
            if (!this.keyFile.exists()) {
                Utility.log(this.log, "KeyFile not found, Entered path/file name :: ", this.keysDirectory.concat("/").concat(this.keyFilename) + ".p12", Level.ERROR);
                this.keyFile = null;
                return false;
            }
            Utility.log(this.log, "KeyFile, Entered path/file name :: ", this.keysDirectory.concat("/").concat(this.keyFilename) + ".p12", Level.INFO);
        }
        catch (Exception e) {
            this.keyFile = null;
            return false;
        }
        boolean isRead = this.keyFile.canRead();
        if (isRead) {
            return true;
        }
        Utility.log(this.log, "File cannot be read permission denied :: ", this.keysDirectory.concat(this.keyFilename), Level.ERROR);
        this.keyFile = null;
        return false;
    }

    public boolean getLogFile() throws ConfigException {
        File dir = new File(this.getLogDirectory());
        if (!dir.isDirectory()) {
            Utility.log(this.log, "Invalid log directory, creating default log directory", "", Level.ERROR);
            this.logDirectory = "log";
            throw new ConfigException("Invalid log directory, creating default log directory");
        }
        return this.getLogFileNameStatus();
    }

    private boolean getLogFileNameStatus() throws ConfigException {
        boolean status = true;
        if (this.logFilename == null || this.logFilename.isEmpty()) {
            Utility.log(this.log, "No log file name, setting default log file name :: cybs.log", "", Level.ERROR);
            this.logFilename = "cybs".concat(".log");
            throw new ConfigException("No log file name, setting default log file name :: cybs.log");
        }
        return status;
    }

    public String getProperty(String merchantID, String prop) {
        return this.getProperty(merchantID, prop, null);
    }

    public String getProperty(String merchantID, String prop, String defaultVal) {
        String merchantSpecificProp;
        String val = null;
        String string = merchantSpecificProp = merchantID != null ? merchantID + "." + prop : null;
        if (this.props != null && merchantSpecificProp != null) {
            val = this.props.getProperty(merchantSpecificProp);
        }
        if (this.props != null && val == null) {
            val = this.props.getProperty(prop);
        }
        if (val == null && merchantSpecificProp != null) {
            val = System.getProperty("cybs." + merchantSpecificProp);
        }
        if (val == null) {
            val = System.getProperty("cybs." + prop);
        }
        if (val == null) {
            val = defaultVal;
        }
        return val;
    }

    public boolean getBooleanProperty(String merchantID, String prop, boolean defaultVal) throws ConfigException {
        String strValue = this.getProperty(merchantID, prop);
        if (strValue == null) {
            return defaultVal;
        }
        if (!"1".equals(strValue) && !"true".equalsIgnoreCase(strValue)) {
            if (!"0".equals(strValue) && !"false".equalsIgnoreCase(strValue)) {
                throw new ConfigException(prop + " has an invalid value.");
            }
            return false;
        }
        return true;
    }

    public int getIntegerProperty(String merchantID, String prop, int defaultVal) {
        String strValue = this.getProperty(merchantID, prop);
        if (strValue == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException var6) {
            Utility.log(this.log, "Prop has an invalid Value", "", Level.ERROR);
            return defaultVal;
        }
    }

    private String date() {
        this.date = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT")));
        return this.date;
    }

    private boolean checkBooleanLogValue(String merchantID, String prop) {
        String logBoolean = this.getProperty(merchantID, prop);
        try {
            if (logBoolean == null || logBoolean.isEmpty()) {
                return true;
            }
            if (logBoolean.equalsIgnoreCase("1")) {
                return true;
            }
            if (logBoolean.equalsIgnoreCase("0")) {
                return false;
            }
            return logBoolean.equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return true;
        }
    }
}

