/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.client.service;

import com.ctrip.framework.apollo.openapi.client.service.AbstractOpenApiService;
import com.ctrip.framework.apollo.openapi.client.url.OpenApiPathBuilder;
import com.ctrip.framework.apollo.openapi.dto.NamespaceReleaseDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenReleaseDTO;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class ReleaseOpenApiService
extends AbstractOpenApiService
implements com.ctrip.framework.apollo.openapi.api.ReleaseOpenApiService {
    public ReleaseOpenApiService(CloseableHttpClient client, String baseUrl, Gson gson) {
        super(client, baseUrl, gson);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenReleaseDTO publishNamespace(String appId, String env, String clusterName, String namespaceName, NamespaceReleaseDTO releaseDTO) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(releaseDTO.getReleaseTitle(), "Release title");
        this.checkNotEmpty(releaseDTO.getReleasedBy(), "Released by");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).appsPathVal(appId).clustersPathVal(clusterName).namespacesPathVal(namespaceName).customResource("releases");
        try (CloseableHttpResponse response = this.post(pathBuilder, releaseDTO);){
            OpenReleaseDTO openReleaseDTO = (OpenReleaseDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenReleaseDTO.class);
            return openReleaseDTO;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Release namespace: %s for appId: %s, cluster: %s in env: %s failed", namespaceName, appId, clusterName, env), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenReleaseDTO getLatestActiveRelease(String appId, String env, String clusterName, String namespaceName) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).appsPathVal(appId).clustersPathVal(clusterName).namespacesPathVal(namespaceName).releasesPathVal("latest");
        try (CloseableHttpResponse response = this.get(pathBuilder);){
            OpenReleaseDTO openReleaseDTO = (OpenReleaseDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenReleaseDTO.class);
            return openReleaseDTO;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Get latest active release for appId: %s, cluster: %s, namespace: %s in env: %s failed", appId, clusterName, namespaceName, env), ex);
        }
    }

    @Override
    public void rollbackRelease(String env, long releaseId, String operator) {
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(operator, "Operator");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).releasesPathVal(String.valueOf(releaseId)).customResource("rollback").addParam("operator", operator);
        try {
            CloseableHttpResponse ignored = this.put(pathBuilder, null);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Rollback release: %s in env: %s failed", releaseId, env), ex);
        }
    }
}

