/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.CronField;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.time.generator.BetweenFieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.cronutils.utils.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;

class EveryFieldValueGenerator
extends FieldValueGenerator {
    protected final int from;
    protected final int to;

    public EveryFieldValueGenerator(CronField cronField) {
        super(cronField);
        Every every = (Every)cronField.getExpression();
        FieldExpression everyExpression = every.getExpression();
        if (everyExpression instanceof Between) {
            Between between = (Between)everyExpression;
            this.from = Math.max(cronField.getConstraints().getStartRange(), BetweenFieldValueGenerator.map(between.getFrom()));
            this.to = Math.min(cronField.getConstraints().getEndRange(), BetweenFieldValueGenerator.map(between.getTo()));
        } else {
            this.from = cronField.getConstraints().getStartRange();
            this.to = cronField.getConstraints().getEndRange();
        }
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        if (reference >= this.to) {
            throw new NoSuchValueException();
        }
        Every every = (Every)this.cronField.getExpression();
        int next = this.getNext(reference, every);
        if (next < this.from) {
            return this.from;
        }
        if (next > this.to) {
            throw new NoSuchValueException();
        }
        return next;
    }

    private int getNext(int reference, Every every) {
        int offset = this.offset();
        if (reference >= offset) {
            int referenceWithoutOffset = reference - offset;
            int period = every.getPeriod().getValue();
            int remainder = referenceWithoutOffset % period;
            return reference + (period - remainder);
        }
        return offset;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        Every every = (Every)this.cronField.getExpression();
        int period = every.getPeriod().getValue();
        int remainder = reference % period;
        if (remainder == 0) {
            return reference - period;
        }
        return reference - remainder;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        try {
            int offset = this.offset();
            if (start != offset) {
                values.add(offset);
            }
            int reference = this.generateNextValue(start);
            while (reference < end) {
                if (reference != offset) {
                    values.add(reference);
                }
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        Every every = (Every)this.cronField.getExpression();
        int start = this.offset();
        return value >= start && (value - start) % every.getPeriod().getValue() == 0 && value >= this.from && value <= this.to;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Every;
    }

    @VisibleForTesting
    int offset() {
        FieldExpression expression = ((Every)this.cronField.getExpression()).getExpression();
        if (expression instanceof On) {
            return ((On)expression).getTime().getValue();
        }
        return this.from;
    }
}

