/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.time.ExecutionTimeBuilder;
import com.cronutils.model.time.NearestValue;
import com.cronutils.model.time.TimeNode;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.cronutils.model.time.generator.NoDaysForMonthException;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.cronutils.utils.Preconditions;
import com.cronutils.utils.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ExecutionTime {
    private CronDefinition cronDefinition;
    private FieldValueGenerator yearsValueGenerator;
    private CronField daysOfWeekCronField;
    private CronField daysOfMonthCronField;
    private CronField daysOfYearCronField;
    private TimeNode months;
    private TimeNode hours;
    private TimeNode minutes;
    private TimeNode seconds;

    @VisibleForTesting
    ExecutionTime(CronDefinition cronDefinition, FieldValueGenerator yearsValueGenerator, CronField daysOfWeekCronField, CronField daysOfMonthCronField, CronField daysOfYearCronField, TimeNode months, TimeNode hours, TimeNode minutes, TimeNode seconds) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition);
        this.yearsValueGenerator = Preconditions.checkNotNull(yearsValueGenerator);
        this.daysOfWeekCronField = Preconditions.checkNotNull(daysOfWeekCronField);
        this.daysOfMonthCronField = Preconditions.checkNotNull(daysOfMonthCronField);
        this.daysOfYearCronField = daysOfYearCronField;
        this.months = Preconditions.checkNotNull(months);
        this.hours = Preconditions.checkNotNull(hours);
        this.minutes = Preconditions.checkNotNull(minutes);
        this.seconds = Preconditions.checkNotNull(seconds);
    }

    public static ExecutionTime forCron(Cron cron) {
        Map<CronFieldName, CronField> fields = cron.retrieveFieldsAsMap();
        ExecutionTimeBuilder executionTimeBuilder = new ExecutionTimeBuilder(cron.getCronDefinition());
        block10: for (CronFieldName name : CronFieldName.values()) {
            if (fields.get((Object)name) == null) continue;
            switch (name) {
                case SECOND: {
                    executionTimeBuilder.forSecondsMatching(fields.get((Object)name));
                    continue block10;
                }
                case MINUTE: {
                    executionTimeBuilder.forMinutesMatching(fields.get((Object)name));
                    continue block10;
                }
                case HOUR: {
                    executionTimeBuilder.forHoursMatching(fields.get((Object)name));
                    continue block10;
                }
                case DAY_OF_WEEK: {
                    executionTimeBuilder.forDaysOfWeekMatching(fields.get((Object)name));
                    continue block10;
                }
                case DAY_OF_MONTH: {
                    executionTimeBuilder.forDaysOfMonthMatching(fields.get((Object)name));
                    continue block10;
                }
                case MONTH: {
                    executionTimeBuilder.forMonthsMatching(fields.get((Object)name));
                    continue block10;
                }
                case YEAR: {
                    executionTimeBuilder.forYearsMatching(fields.get((Object)name));
                    continue block10;
                }
                case DAY_OF_YEAR: {
                    executionTimeBuilder.forDaysOfYearMatching(fields.get((Object)name));
                    continue block10;
                }
            }
        }
        return executionTimeBuilder.build();
    }

    public Optional<ZonedDateTime> nextExecution(ZonedDateTime date) {
        Preconditions.checkNotNull(date);
        try {
            ZonedDateTime nextMatch = this.nextClosestMatch(date);
            if (nextMatch.equals(date)) {
                nextMatch = this.nextClosestMatch(date.plusSeconds(1L));
            }
            return Optional.of(nextMatch);
        }
        catch (NoSuchValueException e) {
            return Optional.empty();
        }
    }

    private ZonedDateTime nextClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        ExecutionTimeResult newdate = new ExecutionTimeResult(date, false);
        while (!(newdate = this.potentialNextClosestMatch(newdate.getTime())).isMatch()) {
        }
        return newdate.getTime();
    }

    private ExecutionTimeResult potentialNextClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        List<Integer> year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear());
        TimeNode days = null;
        int lowestMonth = this.months.getValues().get(0);
        int lowestHour = this.hours.getValues().get(0);
        int lowestMinute = this.minutes.getValues().get(0);
        int lowestSecond = this.seconds.getValues().get(0);
        if (year.isEmpty()) {
            int newYear = this.yearsValueGenerator.generateNextValue(date.getYear());
            try {
                days = this.generateDays(this.cronDefinition, ZonedDateTime.of(LocalDateTime.of(newYear, lowestMonth, 1, 0, 0), date.getZone()));
            }
            catch (NoDaysForMonthException e) {
                return new ExecutionTimeResult(this.toBeginOfNextMonth(date), false);
            }
            return this.initDateTime(this.yearsValueGenerator.generateNextValue(date.getYear()), lowestMonth, days.getValues().get(0), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.months.getValues().contains(date.getMonthValue())) {
            NearestValue nearestValue = this.months.getNextValue(date.getMonthValue(), 0);
            int nextMonths = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), 1, 1, 0, 0, 0), date.getZone()).plusYears(nearestValue.getShifts());
                return new ExecutionTimeResult(newDate, false);
            }
            if (nearestValue.getValue() < date.getMonthValue()) {
                date = date.plusYears(1L);
                return this.initDateTime(date.getYear(), nextMonths, days.getValues().get(0), lowestHour, lowestMinute, lowestSecond, date.getZone());
            }
            try {
                days = this.generateDays(this.cronDefinition, ZonedDateTime.of(LocalDateTime.of(date.getYear(), nextMonths, 1, 0, 0), date.getZone()));
            }
            catch (NoDaysForMonthException e) {
                return new ExecutionTimeResult(this.toBeginOfNextMonth(date), false);
            }
            return this.initDateTime(date.getYear(), nextMonths, days.getValues().get(0), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        try {
            days = this.generateDays(this.cronDefinition, date);
        }
        catch (NoDaysForMonthException e) {
            return new ExecutionTimeResult(this.toBeginOfNextMonth(date), false);
        }
        if (!days.getValues().contains(date.getDayOfMonth())) {
            NearestValue nearestValue = days.getNextValue(date.getDayOfMonth(), 0);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), 1, 0, 0, 0), date.getZone()).plusMonths(nearestValue.getShifts());
                return new ExecutionTimeResult(newDate, false);
            }
            if (nearestValue.getValue() < date.getDayOfMonth()) {
                date = date.plusMonths(1L);
                return this.initDateTime(date.getYear(), date.getMonthValue(), nearestValue.getValue(), lowestHour, lowestMinute, lowestSecond, date.getZone());
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), nearestValue.getValue(), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.hours.getValues().contains(date.getHour())) {
            NearestValue nearestValue = this.hours.getNextValue(date.getHour(), 0);
            int nextHours = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0), date.getZone()).plusDays(nearestValue.getShifts());
                return new ExecutionTimeResult(newDate, false);
            }
            if (nearestValue.getValue() < date.getHour()) {
                date = date.plusDays(1L);
                return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), nextHours, lowestMinute, lowestSecond, date.getZone());
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), nextHours, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.minutes.getValues().contains(date.getMinute())) {
            NearestValue nearestValue = this.minutes.getNextValue(date.getMinute(), 0);
            int nextMinutes = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.ofLocal(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), 0, 0), date.getZone(), date.getOffset()).plusHours(nearestValue.getShifts());
                return new ExecutionTimeResult(newDate, false);
            }
            if (nearestValue.getValue() < date.getMinute()) {
                date = date.plusHours(1L);
            }
            ZonedDateTime newDate = ZonedDateTime.ofLocal(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), nextMinutes, lowestSecond), date.getZone(), date.getOffset());
            return new ExecutionTimeResult(newDate, true);
        }
        if (!this.seconds.getValues().contains(date.getSecond())) {
            NearestValue nearestValue = this.seconds.getNextValue(date.getSecond(), 0);
            int nextSeconds = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.ofLocal(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), 0), date.getZone(), date.getOffset()).plusMinutes(nearestValue.getShifts());
                return new ExecutionTimeResult(newDate, false);
            }
            if (nearestValue.getValue() < date.getSecond()) {
                date = date.plusMinutes(1L);
            }
            ZonedDateTime newDate = ZonedDateTime.ofLocal(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), nextSeconds), date.getZone(), date.getOffset());
            return new ExecutionTimeResult(newDate, true);
        }
        return new ExecutionTimeResult(date, true);
    }

    private ZonedDateTime toBeginOfNextMonth(ZonedDateTime datetime) {
        ZonedDateTime nextMonth = datetime.plusMonths(1L);
        int lowestHour = this.hours.getValues().get(0);
        int lowestMinute = this.minutes.getValues().get(0);
        int lowestSecond = this.seconds.getValues().get(0);
        return ZonedDateTime.of(nextMonth.getYear(), nextMonth.getMonth().getValue(), 1, lowestHour, lowestMinute, lowestSecond, 0, nextMonth.getZone());
    }

    private ZonedDateTime previousClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        ExecutionTimeResult newdate = new ExecutionTimeResult(date, false);
        while (!(newdate = this.potentialPreviousClosestMatch(newdate.getTime())).isMatch()) {
        }
        return newdate.getTime();
    }

    private ExecutionTimeResult potentialPreviousClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        List<Integer> year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear());
        TimeNode days = null;
        try {
            days = this.generateDays(this.cronDefinition, date);
        }
        catch (NoDaysForMonthException e) {
            return new ExecutionTimeResult(this.toEndOfPreviousMonth(date), false);
        }
        int highestMonth = this.months.getValues().get(this.months.getValues().size() - 1);
        int highestDay = days.getValues().get(days.getValues().size() - 1);
        int highestHour = this.hours.getValues().get(this.hours.getValues().size() - 1);
        int highestMinute = this.minutes.getValues().get(this.minutes.getValues().size() - 1);
        int highestSecond = this.seconds.getValues().get(this.seconds.getValues().size() - 1);
        if (year.isEmpty()) {
            int highestDayOfMonth;
            int previousYear = this.yearsValueGenerator.generatePreviousValue(date.getYear());
            if (highestDay > 28 && highestDay > (highestDayOfMonth = LocalDate.of(previousYear, highestMonth, 1).lengthOfMonth())) {
                NearestValue nearestValue = days.getPreviousValue(highestDay, 1);
                if (nearestValue.getShifts() > 0) {
                    ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(previousYear, highestMonth, 1, 23, 59, 59), ZoneId.systemDefault()).minusMonths(nearestValue.getShifts()).with(TemporalAdjusters.lastDayOfMonth());
                    return new ExecutionTimeResult(newDate, false);
                }
                highestDay = nearestValue.getValue();
            }
            return this.initDateTime(previousYear, highestMonth, highestDay, highestHour, highestMinute, highestSecond, date.getZone());
        }
        if (!this.months.getValues().contains(date.getMonthValue())) {
            NearestValue nearestValue = this.months.getPreviousValue(date.getMonthValue(), 0);
            int previousMonths = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), 12, 31, 23, 59, 59), date.getZone()).minusYears(nearestValue.getShifts());
                return new ExecutionTimeResult(newDate, false);
            }
            return this.initDateTime(date.getYear(), previousMonths, highestDay, highestHour, highestMinute, highestSecond, date.getZone());
        }
        if (!days.getValues().contains(date.getDayOfMonth())) {
            NearestValue nearestValue = days.getPreviousValue(date.getDayOfMonth(), 0);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), 1, 23, 59, 59), date.getZone()).minusMonths(nearestValue.getShifts()).with(TemporalAdjusters.lastDayOfMonth());
                return new ExecutionTimeResult(newDate, false);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), nearestValue.getValue(), highestHour, highestMinute, highestSecond, date.getZone());
        }
        if (!this.hours.getValues().contains(date.getHour())) {
            NearestValue nearestValue = this.hours.getPreviousValue(date.getHour(), 0);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 23, 59, 59), date.getZone()).minusDays(nearestValue.getShifts());
                return new ExecutionTimeResult(newDate, false);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), nearestValue.getValue(), highestMinute, highestSecond, date.getZone());
        }
        if (!this.minutes.getValues().contains(date.getMinute())) {
            NearestValue nearestValue = this.minutes.getPreviousValue(date.getMinute(), 0);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), 59, 59), date.getZone()).minusHours(nearestValue.getShifts());
                return new ExecutionTimeResult(newDate, false);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), nearestValue.getValue(), highestSecond, date.getZone());
        }
        if (!this.seconds.getValues().contains(date.getSecond())) {
            NearestValue nearestValue = this.seconds.getPreviousValue(date.getSecond(), 0);
            int previousSeconds = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), 59), date.getZone()).minusMinutes(nearestValue.getShifts());
                return new ExecutionTimeResult(newDate, false);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), previousSeconds, date.getZone());
        }
        return new ExecutionTimeResult(date, true);
    }

    private ZonedDateTime toEndOfPreviousMonth(ZonedDateTime datetime) {
        ZonedDateTime previousMonth = datetime.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        int highestHour = this.hours.getValues().get(this.hours.getValues().size() - 1);
        int highestMinute = this.minutes.getValues().get(this.minutes.getValues().size() - 1);
        int highestSecond = this.seconds.getValues().get(this.seconds.getValues().size() - 1);
        return ZonedDateTime.of(previousMonth.getYear(), previousMonth.getMonth().getValue(), previousMonth.getDayOfMonth(), highestHour, highestMinute, highestSecond, 0, previousMonth.getZone());
    }

    private TimeNode generateDays(CronDefinition cronDefinition, ZonedDateTime date) throws NoDaysForMonthException {
        if (this.isGenerateDaysAsDoY(cronDefinition)) {
            return this.generateDayCandidatesUsingDoY(date);
        }
        if (cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) != null && cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_MONTH) != null) {
            return this.generateDaysDoWAndDoMSupported(cronDefinition, date);
        }
        if (cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) == null) {
            return this.generateDayCandidatesUsingDoM(date);
        }
        return this.generateDayCandidatesUsingDoW(date, ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue());
    }

    private boolean isGenerateDaysAsDoY(CronDefinition cronDefinition) {
        if (!cronDefinition.containsFieldDefinition(CronFieldName.DAY_OF_YEAR)) {
            return false;
        }
        if (!cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_YEAR).getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
            return true;
        }
        return !(this.daysOfYearCronField.getExpression() instanceof QuestionMark);
    }

    private TimeNode generateDayCandidatesUsingDoY(ZonedDateTime reference) throws NoDaysForMonthException {
        int year = reference.getYear();
        int month = reference.getMonthValue();
        LocalDate date = LocalDate.of(year, 1, 1);
        int lengthOfYear = date.lengthOfYear();
        List<Integer> candidates = FieldValueGeneratorFactory.createDayOfYearValueGeneratorInstance(this.daysOfYearCronField, year).generateCandidates(1, lengthOfYear);
        Range rangeOfMonth = Range.closedOpen((Comparable)Integer.valueOf(LocalDate.of(year, month, 1).getDayOfYear()), (Comparable)Integer.valueOf(month == 12 ? LocalDate.of(year, 12, 31).getDayOfYear() + 1 : LocalDate.of(year, month + 1, 1).getDayOfYear()));
        HashSet<Integer> uniqueCanidatesFilteredByMonth = new HashSet<Integer>();
        for (Integer dayOfYear : candidates) {
            if (!rangeOfMonth.contains((Comparable)dayOfYear)) continue;
            uniqueCanidatesFilteredByMonth.add(dayOfYear);
        }
        ArrayList<Integer> collectedCandidates = new ArrayList<Integer>(uniqueCanidatesFilteredByMonth.size());
        for (Integer dayOfYear : uniqueCanidatesFilteredByMonth) {
            collectedCandidates.add(LocalDate.ofYearDay(reference.getYear(), dayOfYear).getDayOfMonth());
        }
        if (collectedCandidates.isEmpty()) {
            throw new NoDaysForMonthException();
        }
        return new TimeNode(collectedCandidates);
    }

    private TimeNode generateDaysDoWAndDoMSupported(CronDefinition cronDefinition, ZonedDateTime date) throws NoDaysForMonthException {
        boolean questionMarkSupported = cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK).getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK);
        List<Object> candidates = new ArrayList();
        candidates = questionMarkSupported ? this.generateDayCandidatesQuestionMarkSupportedUsingDoWAndDoM(date.getYear(), date.getMonthValue(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()) : this.generateDayCandidatesQuestionMarkNotSupportedUsingDoWAndDoM(date.getYear(), date.getMonthValue(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue());
        if (candidates.isEmpty()) {
            throw new NoDaysForMonthException();
        }
        return new TimeNode(candidates);
    }

    public Optional<Duration> timeToNextExecution(ZonedDateTime date) {
        Optional<ZonedDateTime> next = this.nextExecution(date);
        return next.map(zonedDateTime -> Duration.between(date, zonedDateTime));
    }

    public Optional<ZonedDateTime> lastExecution(ZonedDateTime date) {
        Preconditions.checkNotNull(date);
        try {
            ZonedDateTime previousMatch = this.previousClosestMatch(date);
            if (previousMatch.equals(date)) {
                previousMatch = this.previousClosestMatch(date.minusSeconds(1L));
            }
            return Optional.of(previousMatch);
        }
        catch (NoSuchValueException e) {
            return Optional.empty();
        }
    }

    public Optional<Duration> timeFromLastExecution(ZonedDateTime date) {
        Optional<ZonedDateTime> last = this.lastExecution(date);
        return last.map(zonedDateTime -> Duration.between(zonedDateTime, date));
    }

    public boolean isMatch(ZonedDateTime date) {
        boolean isSecondGranularity = this.cronDefinition.containsFieldDefinition(CronFieldName.SECOND);
        date = isSecondGranularity ? date.truncatedTo(ChronoUnit.SECONDS) : date.truncatedTo(ChronoUnit.MINUTES);
        Optional<ZonedDateTime> last = this.lastExecution(date);
        if (last.isPresent()) {
            Optional<ZonedDateTime> next = this.nextExecution(last.get());
            if (next.isPresent()) {
                return next.get().equals(date);
            }
            boolean everythingInRange = false;
            try {
                everythingInRange = this.dateValuesInExpectedRanges(this.nextClosestMatch(date), date);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
            try {
                everythingInRange = this.dateValuesInExpectedRanges(this.previousClosestMatch(date), date);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
            return everythingInRange;
        }
        return false;
    }

    private boolean dateValuesInExpectedRanges(ZonedDateTime validCronDate, ZonedDateTime date) {
        boolean everythingInRange = true;
        if (this.cronDefinition.getFieldDefinition(CronFieldName.YEAR) != null) {
            boolean bl = everythingInRange = validCronDate.getYear() == date.getYear();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.MONTH) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getMonthValue() == date.getMonthValue();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_MONTH) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getDayOfMonth() == date.getDayOfMonth();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getDayOfWeek().getValue() == date.getDayOfWeek().getValue();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.HOUR) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getHour() == date.getHour();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.MINUTE) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getMinute() == date.getMinute();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.SECOND) != null) {
            everythingInRange = everythingInRange && validCronDate.getSecond() == date.getSecond();
        }
        return everythingInRange;
    }

    private List<Integer> generateDayCandidatesQuestionMarkNotSupportedUsingDoWAndDoM(int year, int month, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(year, month, 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfMonthCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else {
            List<Integer> dayOfWeekCandidates = FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth);
            List<Integer> dayOfMonthCandidates = FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth);
            if (this.cronDefinition.isMatchDayOfWeekAndDayOfMonth()) {
                HashSet dayOfWeekCandidatesSet = Sets.newHashSet(dayOfWeekCandidates);
                HashSet dayOfMonthCandidatesSet = Sets.newHashSet(dayOfMonthCandidates);
                candidates.addAll((Collection<Integer>)Sets.intersection((Set)dayOfMonthCandidatesSet, (Set)dayOfWeekCandidatesSet));
            } else {
                candidates.addAll(dayOfWeekCandidates);
                candidates.addAll(dayOfMonthCandidates);
            }
        }
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return candidatesList;
    }

    private List<Integer> generateDayCandidatesQuestionMarkSupportedUsingDoWAndDoM(int year, int month, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(year, month, 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfMonthCronField.getExpression() instanceof QuestionMark) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfWeekCronField.getExpression() instanceof QuestionMark) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        }
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return candidatesList;
    }

    private TimeNode generateDayCandidatesUsingDoM(ZonedDateTime reference) {
        LocalDate date = LocalDate.of(reference.getYear(), reference.getMonthValue(), 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, reference.getYear(), reference.getMonthValue()).generateCandidates(1, lengthOfMonth));
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return new TimeNode(candidatesList);
    }

    private TimeNode generateDayCandidatesUsingDoW(ZonedDateTime reference, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(reference.getYear(), reference.getMonthValue(), 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, reference.getYear(), reference.getMonthValue(), mondayDoWValue).generateCandidates(1, lengthOfMonth));
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return new TimeNode(candidatesList);
    }

    private ExecutionTimeResult initDateTime(int years, int monthsOfYear, int dayOfMonth, int hoursOfDay, int minutesOfHour, int secondsOfMinute, ZoneId timeZone) throws NoSuchValueException {
        ZonedDateTime date = ZonedDateTime.of(LocalDateTime.of(0, 1, 1, 0, 0, 0), timeZone).plusYears(years).plusMonths(monthsOfYear - 1).plusDays(dayOfMonth - 1).plusHours(hoursOfDay).plusMinutes(minutesOfHour).plusSeconds(secondsOfMinute);
        ZonedDateTime result = this.ensureSameDate(date, years, monthsOfYear, dayOfMonth, hoursOfDay, minutesOfHour, secondsOfMinute);
        if (this.isSameDate(result, years, monthsOfYear, dayOfMonth, hoursOfDay, minutesOfHour, secondsOfMinute)) {
            return new ExecutionTimeResult(result, true);
        }
        return new ExecutionTimeResult(result, false);
    }

    private ZonedDateTime ensureSameDate(ZonedDateTime date, int years, int monthsOfYear, int dayOfMonth, int hoursOfDay, int minutesOfHour, int secondsOfMinute) {
        if (date.getSecond() != secondsOfMinute) {
            date = date.plusSeconds(secondsOfMinute - date.getSecond());
        }
        if (date.getMinute() != minutesOfHour) {
            date = date.plusMinutes(minutesOfHour - date.getMinute());
        }
        if (date.getHour() != hoursOfDay && (date = date.plusHours(hoursOfDay - date.getHour())).getHour() < hoursOfDay) {
            date = date.plusHours(hoursOfDay - date.getHour());
        }
        if (date.getDayOfMonth() != dayOfMonth) {
            date = date.plusDays(dayOfMonth - date.getDayOfMonth());
        }
        if (date.getMonthValue() != monthsOfYear) {
            date = date.plusMonths(monthsOfYear - date.getMonthValue());
        }
        if (date.getYear() != years) {
            date = date.plusYears(years - date.getYear());
        }
        return date;
    }

    private boolean isSameDate(ZonedDateTime date, int years, int monthsOfYear, int dayOfMonth, int hoursOfDay, int minutesOfHour, int secondsOfMinute) {
        return date.getSecond() == secondsOfMinute && date.getMinute() == minutesOfHour && date.getHour() == hoursOfDay && date.getDayOfMonth() == dayOfMonth && date.getMonthValue() == monthsOfYear && date.getYear() == years;
    }

    private static final class ExecutionTimeResult {
        private ZonedDateTime time;
        private boolean isMatch;

        private ExecutionTimeResult(ZonedDateTime time, boolean isMatch) {
            this.time = time;
            this.isMatch = isMatch;
        }

        public ZonedDateTime getTime() {
            return this.time;
        }

        public boolean isMatch() {
            return this.isMatch;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("time", (Object)this.time).add("isMatch", this.isMatch).toString();
        }
    }
}

