/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.parser;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.definition.FieldDefinition;
import com.cronutils.parser.CronParserField;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class CronParser {
    private final Map<Integer, List<CronParserField>> expressions = Maps.newHashMap();
    private CronDefinition cronDefinition;

    public CronParser(CronDefinition cronDefinition) {
        this.cronDefinition = (CronDefinition)Validate.notNull((Object)cronDefinition, (String)"CronDefinition must not be null", (Object[])new Object[0]);
        this.buildPossibleExpressions(cronDefinition);
    }

    private void buildPossibleExpressions(CronDefinition cronDefinition) {
        ArrayList<CronParserField> expression = new ArrayList<CronParserField>();
        for (FieldDefinition fieldDefinition : cronDefinition.getFieldDefinitions()) {
            expression.add(new CronParserField(fieldDefinition.getFieldName(), fieldDefinition.getConstraints()));
        }
        Collections.sort(expression, CronParserField.createFieldTypeComparator());
        this.expressions.put(expression.size(), expression);
        if (cronDefinition.isLastFieldOptional()) {
            ArrayList<CronParserField> shortExpression = new ArrayList<CronParserField>();
            shortExpression.addAll(expression);
            shortExpression.remove(shortExpression.size() - 1);
            this.expressions.put(shortExpression.size(), shortExpression);
        }
    }

    public Cron parse(String expression) {
        Validate.notNull((Object)expression, (String)"Expression must not be null", (Object[])new Object[0]);
        String replaced = expression.replaceAll("\\s+", " ").trim();
        if (StringUtils.isEmpty((CharSequence)replaced)) {
            throw new IllegalArgumentException("Empty expression!");
        }
        String[] expressionParts = replaced.toUpperCase().split(" ");
        int expressionLength = expressionParts.length;
        List<CronParserField> fields = this.expressions.get(expressionLength);
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Cron expression contains %s parts but we expect one of %s", expressionLength, this.expressions.keySet()));
        }
        int size = fields.size();
        ArrayList<CronField> results = new ArrayList<CronField>(size + 1);
        for (int j = 0; j < size; ++j) {
            results.add(fields.get(j).parse(expressionParts[j]));
        }
        return new Cron(this.cronDefinition, results).validate();
    }
}

