/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.CronField;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.time.generator.NoSuchValueException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;

public abstract class FieldValueGenerator {
    protected static int NO_VALUE = Integer.MIN_VALUE;
    protected CronField cronField;

    public FieldValueGenerator(CronField cronField) {
        this.cronField = (CronField)Validate.notNull((Object)cronField, (String)"CronField must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.matchesFieldExpressionClass(cronField.getExpression()), (String)"FieldExpression does not match required class", (Object[])new Object[0]);
    }

    public abstract int generateNextValue(int var1) throws NoSuchValueException;

    public abstract int generatePreviousValue(int var1) throws NoSuchValueException;

    protected abstract List<Integer> generateCandidatesNotIncludingIntervalExtremes(int var1, int var2);

    public abstract boolean isMatch(int var1);

    public final List<Integer> generateCandidates(int start, int end) {
        List<Integer> candidates = this.generateCandidatesNotIncludingIntervalExtremes(start, end);
        if (this.isMatch(start)) {
            candidates.add(start);
        }
        if (this.isMatch(end)) {
            candidates.add(end);
        }
        Collections.sort(candidates);
        return candidates;
    }

    protected abstract boolean matchesFieldExpressionClass(FieldExpression var1);
}

