/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.time.generator.NoSuchValueException;
import java.util.List;
import org.apache.commons.lang3.Validate;

public abstract class FieldValueGenerator {
    protected static int NO_VALUE = Integer.MIN_VALUE;
    protected FieldExpression expression;

    public FieldValueGenerator(FieldExpression expression) {
        Validate.notNull((Object)expression);
        Validate.isTrue((boolean)this.matchesFieldExpressionClass(expression), (String)"FieldExpression does not match required class", (Object[])new Object[0]);
        this.expression = expression;
    }

    public abstract int generateNextValue(int var1) throws NoSuchValueException;

    public abstract int generatePreviousValue(int var1) throws NoSuchValueException;

    protected abstract List<Integer> generateCandidatesNotIncludingIntervalExtremes(int var1, int var2);

    public abstract boolean isMatch(int var1);

    public final List<Integer> generateCandidates(int start, int end) {
        List<Integer> candidates = this.generateCandidatesNotIncludingIntervalExtremes(start, end);
        if (this.isMatch(start)) {
            candidates.add(start);
        }
        if (this.isMatch(end)) {
            candidates.add(end);
        }
        return candidates;
    }

    protected abstract boolean matchesFieldExpressionClass(FieldExpression var1);
}

