/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.field.Always;
import com.cronutils.model.field.And;
import com.cronutils.model.field.Between;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.Every;
import com.cronutils.model.field.FieldExpression;
import com.cronutils.model.field.On;
import com.cronutils.model.field.SpecialChar;
import com.cronutils.model.time.generator.AlwaysFieldValueGenerator;
import com.cronutils.model.time.generator.AndFieldValueGenerator;
import com.cronutils.model.time.generator.BetweenFieldValueGenerator;
import com.cronutils.model.time.generator.EveryFieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NullFieldValueGenerator;
import com.cronutils.model.time.generator.OnDayOfMonthValueGenerator;
import com.cronutils.model.time.generator.OnDayOfWeekValueGenerator;
import com.cronutils.model.time.generator.OnFieldValueGenerator;

public class FieldValueGeneratorFactory {
    private static FieldValueGeneratorFactory factory = new FieldValueGeneratorFactory();

    private FieldValueGeneratorFactory() {
    }

    public static FieldValueGeneratorFactory instance() {
        return factory;
    }

    public static FieldValueGenerator forCronField(CronField cronField) {
        FieldExpression fieldExpression = cronField.getExpression();
        if (fieldExpression instanceof Always) {
            return new AlwaysFieldValueGenerator(fieldExpression);
        }
        if (fieldExpression instanceof And) {
            return new AndFieldValueGenerator(fieldExpression);
        }
        if (fieldExpression instanceof Between) {
            return new BetweenFieldValueGenerator(fieldExpression);
        }
        if (fieldExpression instanceof Every) {
            return new EveryFieldValueGenerator(fieldExpression);
        }
        if (fieldExpression instanceof On) {
            On on = (On)fieldExpression;
            if (!SpecialChar.NONE.equals((Object)on.getSpecialChar())) {
                throw new RuntimeException(String.format("Cannot create instance for On instance with %s value", new Object[]{on.getSpecialChar()}));
            }
            return new OnFieldValueGenerator(fieldExpression);
        }
        return new NullFieldValueGenerator(cronField.getExpression());
    }

    public static FieldValueGenerator createDayOfMonthValueGeneratorInstance(CronField cronField, int year, int month) {
        On on;
        FieldExpression fieldExpression = cronField.getExpression();
        if (fieldExpression instanceof On && !SpecialChar.NONE.equals((Object)(on = (On)fieldExpression).getSpecialChar())) {
            return new OnDayOfMonthValueGenerator(cronField, year, month);
        }
        return FieldValueGeneratorFactory.forCronField(cronField);
    }

    public static FieldValueGenerator createDayOfWeekValueGeneratorInstance(CronField cronField, int year, int month, WeekDay mondayDoWValue) {
        On on;
        FieldExpression fieldExpression = cronField.getExpression();
        if (fieldExpression instanceof On && !SpecialChar.NONE.equals((Object)(on = (On)fieldExpression).getSpecialChar())) {
            return new OnDayOfWeekValueGenerator(cronField, year, month, mondayDoWValue);
        }
        return FieldValueGeneratorFactory.forCronField(cronField);
    }
}

