/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field;

import com.cronutils.model.field.FieldExpression;
import com.cronutils.model.field.SpecialChar;
import com.cronutils.model.field.constraint.FieldConstraints;

public class On
extends FieldExpression {
    private int time;
    private int nth;
    private SpecialChar specialChar;

    public On(FieldConstraints constraints, String exp) {
        super(constraints);
        constraints.validateAllCharsValid(exp);
        this.nth = -1;
        this.specialChar = SpecialChar.NONE;
        this.time = this.getConstraints().validateInRange(this.getConstraints().intToInt(this.getConstraints().stringToInt(this.retrieveSpecialChar(this.getConstraints(), exp))));
    }

    public int getTime() {
        return this.time;
    }

    public int getNth() {
        return this.nth;
    }

    public SpecialChar getSpecialChar() {
        return this.specialChar;
    }

    private String retrieveSpecialChar(FieldConstraints constraints, String exp) {
        String expression = exp;
        if (exp.contains("#")) {
            this.specialChar = SpecialChar.HASH;
            String[] array = exp.split("#");
            this.nth = constraints.validateInRange(constraints.intToInt(constraints.stringToInt(array[1])));
            if (array[0].isEmpty()) {
                throw new RuntimeException("Time should be specified!");
            }
            expression = array[0];
        }
        if (exp.contains("LW")) {
            this.specialChar = SpecialChar.LW;
            expression = "".equals(exp = exp.replace("LW", "")) ? "0" : exp;
        }
        if (exp.contains("L")) {
            this.specialChar = SpecialChar.L;
            expression = "".equals(exp = exp.replace("L", "")) ? "0" : exp;
        }
        if (exp.contains("W")) {
            this.specialChar = SpecialChar.W;
            expression = exp.replace("W", "");
        }
        constraints.validateSpecialCharAllowed(this.specialChar);
        return expression;
    }

    @Override
    public String asString() {
        switch (this.specialChar) {
            case NONE: {
                return "" + this.getTime();
            }
            case HASH: {
                return String.format("%s#%s", this.getTime(), this.getNth());
            }
            case W: {
                return String.format("%sW", this.getTime());
            }
        }
        return this.specialChar.toString();
    }
}

