/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field;

import com.cronutils.model.field.Every;
import com.cronutils.model.field.FieldExpression;
import com.cronutils.model.field.constraint.FieldConstraints;

public class Between
extends FieldExpression {
    private int from;
    private int to;
    private Every every;

    public Between(FieldConstraints constraints, String from, String to) {
        this(constraints, from, to, "1");
    }

    public Between(FieldConstraints constraints, String from, String to, String every) {
        super(constraints);
        constraints.validateAllCharsValid(from);
        constraints.validateAllCharsValid(to);
        constraints.validateAllCharsValid(every);
        this.from = this.getConstraints().validateInRange(this.getConstraints().intToInt(this.getConstraints().stringToInt(from)));
        this.to = this.getConstraints().validateInRange(this.getConstraints().intToInt(this.getConstraints().stringToInt(to)));
        this.every = new Every(this.getConstraints(), every);
        this.validate();
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public Every getEvery() {
        return this.every;
    }

    private void validate() {
        if (this.from >= this.to) {
            throw new IllegalArgumentException("Bad range defined! Defined range should satisfy from <= to, but was [%s, %s]");
        }
        if (this.every.getTime() > this.to - this.from) {
            throw new IllegalArgumentException("Every x time cannot exceed range length");
        }
    }

    @Override
    public String asString() {
        return String.format("%s-%s%s", this.from, this.to, this.every.asString());
    }
}

