/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.mapper;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.Always;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.On;
import com.cronutils.model.field.constraint.FieldConstraintsBuilder;
import com.cronutils.model.field.definition.FieldDefinition;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class CronMapper {
    private Map<CronFieldName, Function<CronField, CronField>> mappings;
    private CronDefinition to;

    public CronMapper(CronDefinition from, CronDefinition to) {
        Validate.notNull((Object)from, (String)"Source CronDefinition must not be null", (Object[])new Object[0]);
        this.to = (CronDefinition)Validate.notNull((Object)to, (String)"Destination CronDefinition must not be null", (Object[])new Object[0]);
        this.mappings = Maps.newHashMap();
        this.buildMappings(from, to);
    }

    public Cron map(Cron cron) {
        Validate.notNull((Object)cron, (String)"Cron must not be null", (Object[])new Object[0]);
        ArrayList fields = Lists.newArrayList();
        for (CronFieldName name : CronFieldName.values()) {
            if (!this.mappings.containsKey((Object)name)) continue;
            fields.add(this.mappings.get((Object)name).apply((Object)cron.retrieve(name)));
        }
        return new Cron(this.to, fields);
    }

    private void buildMappings(CronDefinition from, CronDefinition to) {
        HashMap sourceFieldDefinitions = Maps.newHashMap();
        HashMap destFieldDefinitions = Maps.newHashMap();
        for (FieldDefinition fieldDefinition : from.getFieldDefinitions()) {
            sourceFieldDefinitions.put(fieldDefinition.getFieldName(), fieldDefinition);
        }
        for (FieldDefinition fieldDefinition : to.getFieldDefinitions()) {
            destFieldDefinitions.put(fieldDefinition.getFieldName(), fieldDefinition);
        }
        boolean startedDestMapping = false;
        boolean startedSourceMapping = false;
        for (CronFieldName name : CronFieldName.values()) {
            if (destFieldDefinitions.get((Object)name) != null) {
                startedDestMapping = true;
            }
            if (sourceFieldDefinitions.get((Object)name) != null) {
                startedSourceMapping = true;
            }
            if (startedDestMapping && destFieldDefinitions.get((Object)name) == null) break;
            if (!startedSourceMapping && sourceFieldDefinitions.get((Object)name) == null && destFieldDefinitions.get((Object)name) != null) {
                this.mappings.put(name, CronMapper.returnOnZeroExpression(name));
            }
            if (startedSourceMapping && sourceFieldDefinitions.get((Object)name) == null && destFieldDefinitions.get((Object)name) != null) {
                this.mappings.put(name, CronMapper.returnAlwaysExpression(name));
            }
            if (sourceFieldDefinitions.get((Object)name) == null || destFieldDefinitions.get((Object)name) == null) continue;
            this.mappings.put(name, CronMapper.returnSameExpression());
        }
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnSameExpression() {
        return new Function<CronField, CronField>(){

            public CronField apply(CronField field) {
                return field;
            }
        };
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnOnZeroExpression(final CronFieldName name) {
        return new Function<CronField, CronField>(){

            public CronField apply(CronField field) {
                return new CronField(name, new On(FieldConstraintsBuilder.instance().forField(name).createConstraintsInstance(), "0"));
            }
        };
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnAlwaysExpression(final CronFieldName name) {
        return new Function<CronField, CronField>(){

            public CronField apply(CronField field) {
                return new CronField(name, new Always(FieldConstraintsBuilder.instance().forField(name).createConstraintsInstance()));
            }
        };
    }
}

