/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.parser;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.definition.FieldDefinition;
import com.cronutils.parser.field.CronParserField;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class CronParser {
    private CronDefinition cronDefinition;
    private Map<Integer, List<CronParserField>> expressions = Maps.newHashMap();

    public CronParser(CronDefinition cronDefinition) {
        this.cronDefinition = (CronDefinition)Validate.notNull((Object)cronDefinition, (String)"CronDefinition must not be null", (Object[])new Object[0]);
        this.buildPossibleExpressions(cronDefinition);
    }

    private void buildPossibleExpressions(CronDefinition cronDefinition) {
        ArrayList<CronParserField> expression = new ArrayList<CronParserField>();
        for (FieldDefinition fieldDefinition : cronDefinition.getFieldDefinitions()) {
            expression.add(new CronParserField(fieldDefinition.getFieldName(), fieldDefinition.getConstraints()));
        }
        Collections.sort(expression, CronParserField.createFieldTypeComparator());
        this.expressions.put(expression.size(), expression);
        if (cronDefinition.isLastFieldOptional()) {
            ArrayList<CronParserField> shortExpression = new ArrayList<CronParserField>();
            shortExpression.addAll(expression);
            shortExpression.remove(shortExpression.size() - 1);
            this.expressions.put(shortExpression.size(), shortExpression);
        }
    }

    public Cron parse(String expression) {
        Validate.notNull((Object)expression, (String)"Expression must not be null", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)expression)) {
            throw new IllegalArgumentException("Empty expression!");
        }
        expression = expression.toUpperCase();
        String[] expressionParts = (expression = expression.replace("?", "*")).split(" ");
        if (this.expressions.containsKey(expressionParts.length)) {
            ArrayList<CronField> results = new ArrayList<CronField>();
            List<CronParserField> fields = this.expressions.get(expressionParts.length);
            for (int j = 0; j < fields.size(); ++j) {
                results.add(fields.get(j).parse(expressionParts[j]));
            }
            return new Cron(this.cronDefinition, results);
        }
        throw new IllegalArgumentException(String.format("Cron expression contains %s parts but we expect one of %s", expressionParts.length, this.expressions.keySet()));
    }
}

