/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.mapper.format;

import java.util.Map;
import org.joda.time.DateTimeZone;

public abstract class DateTimeFormatLocaleStrategy {
    protected Map<String, String> dayOfWeek;
    protected Map<String, String> months;

    public String retrievePattern(String expression) {
        if (this.isTimezone(expression.replaceAll("[^A-Za-z0-9/_:\\-\\+ ]", ""))) {
            return this.timezonePattern(expression);
        }
        if ((expression = expression.toLowerCase()).contains("/")) {
            return this.parseDateSlashes(expression);
        }
        if (expression.contains(":")) {
            return this.parseTimeWithColons(expression);
        }
        String clean = expression.replaceAll("[^A-Za-z0-9 ]", "");
        if (this.isNumberPattern(clean)) {
            return expression.replace(clean, this.numberPattern(clean));
        }
        if (this.dayOfWeek.containsKey(clean)) {
            return expression.replace(clean, this.dayOfWeek.get(clean));
        }
        if (this.months.containsKey(clean)) {
            return expression.replace(clean, this.months.get(clean));
        }
        return expression;
    }

    protected abstract String parseDateSlashes(String var1);

    private String parseTimeWithColons(String expression) {
        String[] parts;
        String hour = "HH";
        String pattern = "%s";
        if (expression.contains("am") || expression.contains("pm")) {
            hour = "hh";
            pattern = "%s a";
        }
        if ((parts = expression.split(":")).length == 2) {
            return String.format(pattern, String.format("%s:mm", hour));
        }
        return String.format(pattern, String.format("%s:mm:ss", hour));
    }

    private boolean isNumberPattern(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private String numberPattern(String string) {
        switch (string.length()) {
            case 4: {
                return "YYYY";
            }
            case 2: {
                return "dd";
            }
        }
        return "d";
    }

    private boolean isTimezone(String string) {
        try {
            DateTimeZone.forID((String)string);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private String timezonePattern(String string) {
        return "Z";
    }
}

