/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.descriptor;

import com.cronutils.descriptor.DescriptionStrategy;
import com.cronutils.model.field.Always;
import com.cronutils.model.field.Between;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.Every;
import com.cronutils.model.field.FieldExpression;
import com.cronutils.model.field.On;
import com.cronutils.model.field.constraint.FieldConstraintsBuilder;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang3.Validate;

class TimeDescriptionStrategy
extends DescriptionStrategy {
    private FieldExpression hours;
    private FieldExpression minutes;
    private FieldExpression seconds;
    private Set<Function<TimeFields, String>> descriptions;
    private int defaultSeconds = 0;

    TimeDescriptionStrategy(ResourceBundle bundle, FieldExpression hours, FieldExpression minutes, FieldExpression seconds) {
        super(bundle);
        this.hours = this.ensureInstance(hours, new Always(FieldConstraintsBuilder.instance().forField(CronFieldName.HOUR).createConstraintsInstance()));
        this.minutes = this.ensureInstance(minutes, new Always(FieldConstraintsBuilder.instance().forField(CronFieldName.MINUTE).createConstraintsInstance()));
        this.seconds = this.ensureInstance(seconds, new On(FieldConstraintsBuilder.instance().forField(CronFieldName.SECOND).createConstraintsInstance(), "" + this.defaultSeconds));
        this.descriptions = Sets.newHashSet();
        this.registerFunctions();
    }

    private FieldExpression ensureInstance(FieldExpression expression, FieldExpression defaultExpression) {
        Validate.notNull((Object)defaultExpression, (String)"Default expression must not be null", (Object[])new Object[0]);
        if (expression != null) {
            return expression;
        }
        return defaultExpression;
    }

    @Override
    public String describe() {
        TimeFields fields = new TimeFields(this.hours, this.minutes, this.seconds);
        for (Function<TimeFields, String> function : this.descriptions) {
            if ("".equals(function.apply((Object)fields))) continue;
            return (String)function.apply((Object)fields);
        }
        String secondsDesc = "";
        String minutesDesc = "";
        String hoursDesc = this.addTimeExpressions(this.describe(this.hours), this.bundle.getString("hour"), this.bundle.getString("hours"));
        if (!(this.seconds instanceof On) || !this.isDefault((On)this.seconds)) {
            secondsDesc = this.addTimeExpressions(this.describe(this.seconds), this.bundle.getString("second"), this.bundle.getString("seconds"));
        }
        if (!(this.minutes instanceof On) || !this.isDefault((On)this.minutes)) {
            minutesDesc = this.addTimeExpressions(this.describe(this.minutes), this.bundle.getString("minute"), this.bundle.getString("minutes"));
        }
        return String.format("%s %s %s", secondsDesc, minutesDesc, hoursDesc);
    }

    private String addTimeExpressions(String description, String singular, String plural) {
        return description.replaceAll("%s", singular).replaceAll("%p", plural);
    }

    private void registerFunctions() {
        this.descriptions.add(new Function<TimeFields, String>(){

            public String apply(TimeFields timeFields) {
                if (timeFields.hours instanceof Always && timeFields.minutes instanceof Always) {
                    if (timeFields.seconds instanceof Always) {
                        return String.format("%s %s ", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("second"));
                    }
                    if (timeFields.seconds instanceof On) {
                        if (TimeDescriptionStrategy.this.isDefault((On)timeFields.seconds)) {
                            return String.format("%s %s ", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("minute"));
                        }
                        return String.format("%s %s %s %s %02d", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("minute"), TimeDescriptionStrategy.this.bundle.getString("at"), TimeDescriptionStrategy.this.bundle.getString("second"), ((On)timeFields.seconds).getTime());
                    }
                }
                return "";
            }
        });
        this.descriptions.add(new Function<TimeFields, String>(){

            public String apply(TimeFields timeFields) {
                if (timeFields.hours instanceof Always && timeFields.minutes instanceof On && timeFields.seconds instanceof On) {
                    if (TimeDescriptionStrategy.this.isDefault((On)timeFields.seconds)) {
                        if (TimeDescriptionStrategy.this.isDefault((On)timeFields.minutes)) {
                            return String.format("%s %s ", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("hour"));
                        }
                        return String.format("%s %s %s %s %s", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("hour"), TimeDescriptionStrategy.this.bundle.getString("at"), TimeDescriptionStrategy.this.bundle.getString("minute"), ((On)timeFields.minutes).getTime());
                    }
                    return String.format("%s %s %s %s %s %s %s %s", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("hour"), TimeDescriptionStrategy.this.bundle.getString("at"), TimeDescriptionStrategy.this.bundle.getString("minute"), ((On)timeFields.minutes).getTime(), TimeDescriptionStrategy.this.bundle.getString("and"), TimeDescriptionStrategy.this.bundle.getString("second"), ((On)timeFields.seconds).getTime());
                }
                return "";
            }
        });
        this.descriptions.add(new Function<TimeFields, String>(){

            public String apply(TimeFields timeFields) {
                if (timeFields.hours instanceof On && timeFields.minutes instanceof On && timeFields.seconds instanceof Always) {
                    return String.format("%s %s %s %02d:%02d", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("second"), TimeDescriptionStrategy.this.bundle.getString("at"), ((On)TimeDescriptionStrategy.this.hours).getTime(), ((On)TimeDescriptionStrategy.this.minutes).getTime());
                }
                return "";
            }
        });
        this.descriptions.add(new Function<TimeFields, String>(){

            public String apply(TimeFields timeFields) {
                if (timeFields.hours instanceof On && timeFields.minutes instanceof On && timeFields.seconds instanceof On) {
                    if (TimeDescriptionStrategy.this.isDefault((On)timeFields.seconds)) {
                        return String.format("%s %02d:%02d", TimeDescriptionStrategy.this.bundle.getString("at"), ((On)TimeDescriptionStrategy.this.hours).getTime(), ((On)TimeDescriptionStrategy.this.minutes).getTime());
                    }
                    return String.format("%s %02d:%02d:%02d", TimeDescriptionStrategy.this.bundle.getString("at"), ((On)TimeDescriptionStrategy.this.hours).getTime(), ((On)TimeDescriptionStrategy.this.minutes).getTime(), ((On)TimeDescriptionStrategy.this.seconds).getTime());
                }
                return "";
            }
        });
        this.descriptions.add(new Function<TimeFields, String>(){

            public String apply(TimeFields timeFields) {
                if (timeFields.hours instanceof On && timeFields.minutes instanceof Always && timeFields.seconds instanceof Always) {
                    return String.format("%s %02d:00", TimeDescriptionStrategy.this.bundle.getString("at"), ((On)TimeDescriptionStrategy.this.hours).getTime());
                }
                return "";
            }
        });
        this.descriptions.add(new Function<TimeFields, String>(){

            public String apply(TimeFields timeFields) {
                if (timeFields.hours instanceof On && timeFields.minutes instanceof Between) {
                    if (timeFields.seconds instanceof On) {
                        return String.format("%s %s %s %02d:%02d %s %02d:%02d", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("minute"), TimeDescriptionStrategy.this.bundle.getString("between"), ((On)timeFields.hours).getTime(), ((Between)timeFields.minutes).getFrom(), TimeDescriptionStrategy.this.bundle.getString("and"), ((On)timeFields.hours).getTime(), ((Between)timeFields.minutes).getTo());
                    }
                    if (timeFields.seconds instanceof Always) {
                        return String.format("%s %s %s %02d:%02d %s %02d:%02d", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("second"), TimeDescriptionStrategy.this.bundle.getString("between"), ((On)timeFields.hours).getTime(), ((Between)timeFields.minutes).getFrom(), TimeDescriptionStrategy.this.bundle.getString("and"), ((On)timeFields.hours).getTime(), ((Between)timeFields.minutes).getTo());
                    }
                }
                return "";
            }
        });
        this.descriptions.add(new Function<TimeFields, String>(){

            public String apply(TimeFields timeFields) {
                if (timeFields.hours instanceof Always && timeFields.minutes instanceof Every && timeFields.seconds instanceof On) {
                    if (((Every)timeFields.minutes).getTime() == 1 && TimeDescriptionStrategy.this.isDefault((On)timeFields.seconds)) {
                        return String.format("%s %s", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("minute"));
                    }
                    return String.format("%s %s %s ", TimeDescriptionStrategy.this.bundle.getString("every"), ((Every)TimeDescriptionStrategy.this.minutes).getTime(), TimeDescriptionStrategy.this.bundle.getString("minutes"));
                }
                return "";
            }
        });
        this.descriptions.add(new Function<TimeFields, String>(){

            public String apply(TimeFields timeFields) {
                if (timeFields.hours instanceof Every && timeFields.minutes instanceof On && timeFields.seconds instanceof On) {
                    if (((On)timeFields.minutes).getTime() == 0 && ((On)timeFields.seconds).getTime() == 0) {
                        return String.format("%s %s", TimeDescriptionStrategy.this.bundle.getString("every"), TimeDescriptionStrategy.this.bundle.getString("hour"));
                    }
                    String result = String.format("%s %s %s %s %s %s ", TimeDescriptionStrategy.this.bundle.getString("every"), ((Every)TimeDescriptionStrategy.this.hours).getTime(), TimeDescriptionStrategy.this.bundle.getString("hours"), TimeDescriptionStrategy.this.bundle.getString("at"), TimeDescriptionStrategy.this.bundle.getString("minute"), ((On)TimeDescriptionStrategy.this.minutes).getTime());
                    if (TimeDescriptionStrategy.this.isDefault((On)timeFields.seconds)) {
                        return result;
                    }
                    return String.format("%s %s %s", TimeDescriptionStrategy.this.bundle.getString("and"), TimeDescriptionStrategy.this.bundle.getString("second"), ((On)TimeDescriptionStrategy.this.seconds).getTime());
                }
                return "";
            }
        });
    }

    private boolean isDefault(On on) {
        return on.getTime() == this.defaultSeconds;
    }

    class TimeFields {
        public FieldExpression seconds;
        public FieldExpression minutes;
        public FieldExpression hours;

        public TimeFields(FieldExpression hours, FieldExpression minutes, FieldExpression seconds) {
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        }
    }
}

