/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model;

import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class Cron {
    private Map<CronFieldName, CronField> fields = Maps.newHashMap();
    private String asString;

    public Cron(List<CronField> fields) {
        Validate.notNull(fields, (String)"CronFields cannot be null", (Object[])new Object[0]);
        for (CronField field : fields) {
            this.fields.put(field.getField(), field);
        }
    }

    public CronField retrieve(CronFieldName name) {
        return this.fields.get(Validate.notNull((Object)((Object)name), (String)"CronFieldName must not be null", (Object[])new Object[0]));
    }

    public Map<CronFieldName, CronField> retrieveFieldsAsMap() {
        return Collections.unmodifiableMap(this.fields);
    }

    public String asString() {
        if (this.asString == null) {
            ArrayList<CronField> fields = new ArrayList<CronField>(this.fields.values());
            Collections.sort(fields, CronField.createFieldComparator());
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < fields.size(); ++j) {
                builder.append(String.format("%s ", fields.get(j).getExpression().asString()));
            }
            this.asString = builder.toString().trim();
        }
        return this.asString;
    }
}

