/*
 * Decompiled with CFR 0.152.
 */
package com.creativewidgetworks.expressionparser;

import com.creativewidgetworks.expressionparser.FieldInterface;
import com.creativewidgetworks.expressionparser.Function;
import com.creativewidgetworks.expressionparser.Operator;
import com.creativewidgetworks.expressionparser.ParserException;
import com.creativewidgetworks.expressionparser.Token;
import com.creativewidgetworks.expressionparser.TokenType;
import com.creativewidgetworks.expressionparser.Value;
import com.creativewidgetworks.expressionparser.ValueType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parser {
    public static final int DEFAULT_PRECISION = 5;
    public static int MAX_DIM_ROWS = 10000;
    public static int MAX_DIM_COLS = 256;
    private boolean allowProperties = false;
    private TimeZone localTimeZone = TimeZone.getDefault();
    private static final String DEFAULT_SPLIT_CHARACTER = ";";
    private static final String SPLIT_REGEX = "(?=([^\\\"\\']*[\\\"\\'][^\\\"\\']*[\\\"\\'])*[^\\\"\\']*$)";
    private int precision = 5;
    private boolean caseSensitive = false;
    private Pattern combinedPattern;
    private String expressionDelimiter = ";";
    final Map<String, List<Token>> tokenizedExpressions = new HashMap<String, List<Token>>();
    private ParserException lastException;
    private String lastExpression;
    private Map<String, BigDecimal> constants = new HashMap<String, BigDecimal>();
    private Map<String, Function> functions = new HashMap<String, Function>();
    private Map<String, Value> globals = new TreeMap<String, Value>();
    private Map<String, Value> variables = new TreeMap<String, Value>();
    private FieldInterface fieldInterface;
    private boolean suppressParseExceptions;

    public Parser() {
        this.clearConstants();
        this.clearFunctions();
    }

    public Parser(Parser parser) {
        this();
        this.allowProperties = parser.allowProperties;
        this.expressionDelimiter = parser.expressionDelimiter;
        this.fieldInterface = parser.fieldInterface;
        this.localTimeZone = parser.localTimeZone;
        this.precision = parser.precision;
        this.suppressParseExceptions = parser.suppressParseExceptions;
        this.caseSensitive = parser.getCaseSensitive();
        this.constants = parser.getConstants();
        this.functions = parser.getFunctions();
        this.globals = parser.getGlobalVariables();
        this.variables = parser.getVariables();
    }

    public boolean setAllowProperties(boolean allowProperties) {
        boolean orgAllowProperties = this.allowProperties;
        this.allowProperties = allowProperties;
        return orgAllowProperties;
    }

    public TimeZone getTimeZone() {
        return this.localTimeZone;
    }

    public TimeZone setTimeZone(TimeZone timezone) {
        TimeZone orgTimeZone = this.localTimeZone;
        this.localTimeZone = timezone;
        return orgTimeZone;
    }

    public String listOfNullParameters(Stack<Token> stack) {
        return this.listOfNullParameters(stack, 0);
    }

    public String listOfNullParameters(Stack<Token> stack, int argCount) {
        StringBuilder sb = new StringBuilder();
        if (stack != null) {
            int offset;
            int i = offset = argCount == 0 ? 0 : stack.size() - argCount;
            int p = 1;
            while (i < stack.size()) {
                if (((Token)stack.elementAt(i)).getValue().asObject() == null) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(p);
                }
                ++i;
                ++p;
            }
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public void addConstant(String name, BigDecimal value) {
        if (name != null) {
            this.constants.put(this.caseSensitive ? name : name.toUpperCase(), value);
            this.invalidatePattern();
        }
    }

    public void clearConstant(String name) {
        this.constants.remove(this.caseSensitive ? name : name.toUpperCase());
        this.invalidatePattern();
    }

    public void clearConstants() {
        this.constants.clear();
        this.addConstant("null", null);
        this.addConstant("pi", BigDecimal.valueOf(Math.PI));
        this.invalidatePattern();
    }

    public BigDecimal getConstant(String name) {
        return name == null ? null : this.constants.get(this.caseSensitive ? name : name.toUpperCase());
    }

    public Map<String, BigDecimal> getConstants() {
        return this.constants;
    }

    public String getConstantRegex() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.constants.keySet());
        Collections.sort(names, Collections.reverseOrder());
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(name);
        }
        if (sb.length() == 0) {
            sb.append("~~no-constants-defined~~");
        }
        return sb.toString();
    }

    public Value getField(String name) {
        if (this.fieldInterface != null) {
            return this.fieldInterface.getField(name, this.getCaseSensitive());
        }
        return null;
    }

    public FieldInterface getFieldInterface() {
        return this.fieldInterface;
    }

    public FieldInterface setFieldInterface(FieldInterface fieldInterface) {
        FieldInterface oldValue = fieldInterface;
        this.fieldInterface = fieldInterface;
        return oldValue;
    }

    public void addFunction(Function function) {
        if (function != null) {
            this.functions.put(this.caseSensitive ? function.getName() : function.getName().toUpperCase(), function);
            this.invalidatePattern();
        }
    }

    public void clearFunction(String name) {
        this.functions.remove(this.caseSensitive ? name : name.toUpperCase());
        this.invalidatePattern();
    }

    public void clearFunctions() {
        this.functions.clear();
        this.addFunction(new Function("clearGlobal", this, "_CLEARGLOBAL", 1, 1, new ValueType[0]));
        this.addFunction(new Function("clearGlobals", this, "_CLEARGLOBALS", 0, 0, new ValueType[0]));
        this.addFunction(new Function("dim", this, "_DIM", 2, 3, ValueType.UNDEFINED, ValueType.NUMBER, ValueType.NUMBER));
        this.addFunction(new Function("getGlobal", this, "_GETGLOBAL", 1, 1, ValueType.STRING));
        this.addFunction(new Function("setGlobal", this, "_SETGLOBAL", 2, 2, ValueType.STRING));
        this.addFunction(new Function("now", this, "_NOW", 0, 1, new ValueType[0]));
        this.addFunction(new Function("precision", this, "_PRECISION", 1, 1, ValueType.NUMBER));
        this.invalidatePattern();
    }

    public Pattern getPattern(Parser parser) {
        if (this.combinedPattern == null) {
            StringBuilder sb = new StringBuilder();
            for (TokenType tokenType : TokenType.values()) {
                sb.append(String.format("|(?<%s>%s)", tokenType.name(), tokenType.getRegex(parser)));
            }
            int options = parser.getCaseSensitive() ? 64 : 66;
            this.combinedPattern = Pattern.compile(sb.substring(1), options |= 0x100);
        }
        return this.combinedPattern;
    }

    public void invalidatePattern() {
        this.combinedPattern = null;
    }

    public Function getFunction(String functionName) {
        return functionName == null ? null : this.functions.get(this.caseSensitive ? functionName : functionName.toUpperCase());
    }

    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    public String getFunctionRegex() {
        ArrayList<String> regexs = new ArrayList<String>();
        for (Function function : this.functions.values()) {
            regexs.add(function.getName());
        }
        Collections.sort(regexs, Collections.reverseOrder());
        StringBuilder sb = new StringBuilder();
        for (String regex : regexs) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(regex);
        }
        if (sb.length() == 0) {
            sb.append("~~no-functions-defined~~");
        }
        return sb.toString();
    }

    private Object getProperty(String name) {
        if (this.allowProperties) {
            String obj = System.getenv(name);
            return obj == null ? System.getProperties().get(name) : obj;
        }
        return null;
    }

    public void addGlobalVariable(String name, Value value) {
        if (name != null && value != null) {
            this.globals.put(this.caseSensitive ? name : name.toUpperCase(), value);
        }
    }

    public void clearGlobalVariable(String name) {
        if (name != null) {
            this.globals.remove(this.caseSensitive ? name : name.toUpperCase());
        }
    }

    public void clearGlobalVariables() {
        this.globals.clear();
    }

    public Value getGlobalVariable(String name) {
        return name == null ? null : this.globals.get(this.caseSensitive ? name : name.toUpperCase());
    }

    public Map<String, Value> getGlobalVariables() {
        return this.globals;
    }

    public void addVariable(String name, Value value) {
        if (name != null && value != null) {
            this.variables.put(this.caseSensitive ? name : name.toUpperCase(), value);
        }
    }

    public void clearVariable(String name) {
        this.variables.remove(this.caseSensitive ? name : name.toUpperCase());
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public Value getVariable(String name) {
        return name == null ? null : this.variables.get(this.caseSensitive ? name : name.toUpperCase());
    }

    public Map<String, Value> getVariables() {
        return this.variables;
    }

    private int compareTokens(Token token1, Token token2, boolean caseSensitive) throws ParserException {
        if (!token1.isOperator()) {
            throw new ParserException(ParserException.formatMessage("error.operator_expected", token1.getType().name()));
        }
        if (!token2.isOperator()) {
            throw new ParserException(ParserException.formatMessage("error.operator_expected_at_top", token1.getType().name()));
        }
        Operator o1 = Operator.find(token1, caseSensitive);
        if (o1 == null) {
            throw new ParserException(ParserException.formatMessage("error.operator_not_found", token1.getText()));
        }
        Operator o2 = Operator.find(token2, caseSensitive);
        if (o2 == null) {
            throw new ParserException(ParserException.formatMessage("error.operator_not_found", token2.getText()));
        }
        return o1.getPrecedence() - o2.getPrecedence();
    }

    private boolean isType(Token token, int type, boolean caseSensitive) throws ParserException {
        if (!token.isOperator()) {
            throw new ParserException(ParserException.formatMessage("error.expected_operator_token", token.getText(), token.getType().name()));
        }
        Operator o = Operator.find(token, caseSensitive);
        if (o == null) {
            throw new ParserException(ParserException.formatMessage("error.operator_not_found", token.getText()));
        }
        return o.getAssociation() == type;
    }

    private boolean shouldPopToken(Token token, Token topOfStack, boolean caseSensitive) throws ParserException {
        Operator op = Operator.find(token, caseSensitive);
        if (op.inSet(Operator.UNARY_MINUS, Operator.UNARY_PLUS) && Operator.EXP.getText().equals(topOfStack.getText())) {
            return false;
        }
        return this.isType(token, 1, caseSensitive) && this.compareTokens(token, topOfStack, caseSensitive) >= 0 || this.isType(token, 2, caseSensitive) && this.compareTokens(token, topOfStack, caseSensitive) > 0;
    }

    public void clearCache() {
        this.tokenizedExpressions.clear();
    }

    public ParserException getLastException() {
        return this.lastException;
    }

    public String getLastExpression() {
        return this.lastExpression;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean setCaseSensitive(boolean caseSensitive) {
        boolean oldValue = this.caseSensitive;
        this.caseSensitive = caseSensitive;
        return oldValue;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int setPrecision(int decimals) {
        int oldValue = this.precision;
        this.precision = decimals;
        return oldValue;
    }

    private void setStatusAndFail(Token currentToken, String message, Object ... parameters) throws ParserException {
        int errorAtRow = currentToken == null ? -1 : currentToken.getRow();
        int errorAtCol = currentToken == null ? -1 : currentToken.getColumn();
        String errorMessage = ParserException.formatMessage(message, parameters);
        throw new ParserException(errorMessage, errorAtRow, errorAtCol);
    }

    public Value eval(String source) {
        if (source == null) {
            source = "";
        }
        source = source + DEFAULT_SPLIT_CHARACTER;
        this.lastException = null;
        Value value = new Value("ERROR: EMPTY EXPRESSION");
        try {
            String[] expressions;
            for (String expression : expressions = source.split(this.expressionDelimiter + SPLIT_REGEX)) {
                if (expression.trim().length() <= 0) continue;
                List<Token> tokens = this.tokenizedExpressions.get(expression);
                if (tokens == null) {
                    this.lastExpression = expression;
                    tokens = new ArrayList<Token>();
                    List<Token> list = this.tokenize(expression, false);
                    if (list.size() > 0) {
                        tokens.addAll(this.infixToRPN(list));
                        this.tokenizedExpressions.put(expression, tokens);
                    }
                }
                for (Token token : tokens) {
                    token.restoreOrgValue();
                }
                value = tokens.size() > 0 ? this.RPNtoValue(tokens) : new Value("ERROR: EMPTY EXPRESSION");
            }
        }
        catch (ParserException ex) {
            this.lastException = ex;
            value = new Value().setValue(this.lastException);
        }
        return value;
    }

    public List<Token> tokenize(String input, boolean wantWhitespace) throws ParserException {
        int offset = 0;
        int row = 1;
        ArrayList<Token> tokens = new ArrayList<Token>();
        Matcher matcher = this.getPattern(this).matcher(input);
        while (matcher.find()) {
            if (wantWhitespace || matcher.group(TokenType.WHITESPACE.name()) == null) {
                for (TokenType tokenType : TokenType.values()) {
                    if (matcher.group(tokenType.name()) == null) continue;
                    String text = tokenType.resolve(matcher.group(tokenType.name()));
                    Token token = new Token(tokenType, text, row, matcher.start() + 1 - offset);
                    token.saveOrgValue();
                    tokens.add(token);
                    break;
                }
            }
            if (matcher.group(TokenType.NEWLINE.name()) == null) continue;
            offset = matcher.start() + 1;
            ++row;
        }
        if (tokens.size() > 1) {
            int last = tokens.size() - 1;
            Token lastToken = (Token)tokens.get(last);
            if (TokenType.NOMATCH.equals((Object)lastToken.getType())) {
                tokens.remove(last);
            }
            for (Token token : tokens) {
                if (!TokenType.NOMATCH.equals((Object)token.getType())) continue;
                this.setStatusAndFail(token, "error.invalid_token", new Object[0]);
            }
        }
        return tokens;
    }

    protected List<Token> infixToRPN(List<Token> inputTokens) throws ParserException {
        Token token;
        ArrayList<Token> outputTokens = new ArrayList<Token>();
        Token lastToken = null;
        Stack<Token> stack = new Stack<Token>();
        Stack<ArgCount> argStack = new Stack<ArgCount>();
        int bcount = 0;
        int pcount = 0;
        for (Token token2 : inputTokens) {
            if (token2.opEquals(Operator.LBRACKET)) {
                ++bcount;
            } else if (token2.opEquals(Operator.RBRACKET) && --bcount < 0) {
                this.setStatusAndFail(token2, "error.missing_bracket", Operator.LBRACKET.getText());
            }
            if (token2.opEquals(Operator.LPAREN)) {
                ++pcount;
                continue;
            }
            if (!token2.opEquals(Operator.RPAREN) || --pcount >= 0) continue;
            this.setStatusAndFail(token2, "error.missing_parens", Operator.LPAREN.getText());
        }
        if (bcount != 0) {
            token = inputTokens.get(inputTokens.size() - 1);
            this.setStatusAndFail(token, "error.missing_bracket", Operator.RBRACKET.getText());
        }
        if (pcount != 0) {
            token = inputTokens.get(inputTokens.size() - 1);
            this.setStatusAndFail(token, "error.missing_parens", Operator.RPAREN.getText());
        }
        for (Token token2 : inputTokens) {
            if (token2.opEquals(Operator.MINUS) || token2.opEquals(Operator.PLUS)) {
                boolean isUnary;
                boolean bl = isUnary = lastToken == null || lastToken.isOperator() || lastToken.isParen();
                if (isUnary) {
                    if (token2.opEquals(Operator.MINUS)) {
                        token2.setText(Operator.UNARY_MINUS.getText());
                    } else {
                        token2.setText(Operator.UNARY_PLUS.getText());
                    }
                }
            }
            if (lastToken != null && lastToken.isIdentifer() && token2.getText().equalsIgnoreCase(Operator.LPAREN.getText())) {
                this.setStatusAndFail(lastToken, "error.expected_function", lastToken.getText());
            }
            lastToken = token2;
            if (token2.opEquals(Operator.TIF)) {
                outputTokens.add(new Token(TokenType.NOTHROW, "?", token2.getRow(), token2.getColumn()));
            }
            if (token2.isNumber() || token2.isString() || token2.isConstant() || token2.isField() || token2.isIdentifer() || token2.isProperty()) {
                outputTokens.add(token2);
                if (argStack.isEmpty()) continue;
                ((ArgCount)argStack.peek()).haveArgs = true;
                continue;
            }
            if (token2.isFunction()) {
                stack.push(token2);
                if (!argStack.isEmpty()) {
                    ((ArgCount)argStack.peek()).haveArgs = true;
                }
                argStack.push(new ArgCount());
                continue;
            }
            if (token2.opEquals(Operator.COMMA)) {
                if (bcount != 0) continue;
                while (!stack.empty() && !((Token)stack.peek()).opEquals(Operator.LPAREN)) {
                    outputTokens.add((Token)stack.pop());
                }
                if (argStack.size() <= 0 || !((ArgCount)argStack.peek()).haveArgs) continue;
                ++((ArgCount)argStack.peek()).count;
                continue;
            }
            if (token2.opEquals(Operator.LBRACKET)) {
                ++bcount;
                stack.push(token2);
                continue;
            }
            if (token2.opEquals(Operator.LPAREN)) {
                stack.push(token2);
                continue;
            }
            if (token2.opEquals(Operator.RBRACKET)) {
                --bcount;
                while (!stack.empty() && !((Token)stack.peek()).opEquals(Operator.LBRACKET)) {
                    outputTokens.add((Token)stack.pop());
                }
                outputTokens.add((Token)stack.pop());
                continue;
            }
            if (token2.opEquals(Operator.RPAREN)) {
                while (!stack.empty() && !((Token)stack.peek()).opEquals(Operator.LPAREN)) {
                    outputTokens.add((Token)stack.pop());
                }
                stack.pop();
                if (stack.empty() || !((Token)stack.peek()).isFunction()) continue;
                Token function = (Token)stack.pop();
                ArgCount argc = (ArgCount)argStack.pop();
                function.setArgc(argc.haveArgs ? argc.count + 1 : argc.count);
                outputTokens.add(function);
                continue;
            }
            if (!token2.isOperator()) continue;
            while (!stack.empty() && ((Token)stack.peek()).isOperator() && this.shouldPopToken(token2, (Token)stack.peek(), this.caseSensitive)) {
                outputTokens.add((Token)stack.pop());
            }
            stack.push(token2);
        }
        while (!stack.empty()) {
            outputTokens.add((Token)stack.pop());
        }
        return outputTokens;
    }

    private boolean haveString(Token lhs, Token rhs) {
        return lhs.getValue().getType() == ValueType.STRING || rhs.getValue().getType() == ValueType.STRING;
    }

    private void assertBothNumbers(Token lhs, Token rhs) throws ParserException {
        if (lhs.getValue().getType() != ValueType.NUMBER || rhs.getValue().getType() != ValueType.NUMBER) {
            this.setStatusAndFail(rhs, "error.both_must_be_numeric", lhs.asString(), rhs.asString());
        }
    }

    private void assertSufficientStack(Token token, Stack<Token> stack, int requiredSize) throws ParserException {
        if (stack.size() < requiredSize) {
            this.setStatusAndFail(token, "error.syntax", new Object[0]);
        }
    }

    private Token processOperators(Token token, Stack<Token> stack) throws ParserException {
        Token result = null;
        Operator op = Operator.find(token, this.caseSensitive);
        if (op.equals((Object)Operator.PERCENT)) {
            this.assertSufficientStack(token, stack, 1);
            BigDecimal bd = stack.pop().asNumber().divide(new BigDecimal(100), this.getPrecision(), RoundingMode.HALF_UP).stripTrailingZeros();
            return new Token(TokenType.NUMBER, bd.toPlainString(), token.getRow(), token.getColumn());
        }
        if (op.equals((Object)Operator.TIF)) {
            Token tValue;
            this.assertSufficientStack(token, stack, 4);
            if (!Operator.TELSE.equals((Object)Operator.find(stack.pop(), this.caseSensitive))) {
                this.setStatusAndFail(token, "error.expected_telse", Operator.TELSE.getText());
            }
            Token falseValue = stack.pop();
            Token trueValue = stack.pop();
            Token booleanValue = stack.pop();
            if (booleanValue.getValue().getType() != ValueType.BOOLEAN) {
                this.setStatusAndFail(booleanValue, "error.boolean_expected", new Object[]{booleanValue.getType()});
            }
            this.suppressParseExceptions = false;
            Token token2 = tValue = booleanValue.asBoolean() != false ? trueValue : falseValue;
            if (tValue.asObject() instanceof ParserException) {
                throw (ParserException)tValue.asObject();
            }
            return tValue;
        }
        this.assertSufficientStack(token, stack, 2);
        Token rhs = stack.pop();
        Token lhs = stack.pop();
        try {
            if (op.equals((Object)Operator.PLUS)) {
                if (this.haveString(lhs, rhs)) {
                    String strL = lhs.asString() == null ? "" : lhs.asString();
                    String strR = rhs.asString() == null ? "" : rhs.asString();
                    result = new Token(TokenType.STRING, strL + strR, token.getRow(), token.getColumn());
                } else {
                    this.assertBothNumbers(lhs, rhs);
                    BigDecimal bd = lhs.asNumber().add(rhs.asNumber());
                    bd = bd.setScale(this.getPrecision(), 4).stripTrailingZeros();
                    result = new Token(TokenType.NUMBER, bd.toPlainString(), token.getRow(), token.getColumn());
                }
            } else if (op.equals((Object)Operator.MINUS)) {
                this.assertBothNumbers(lhs, rhs);
                BigDecimal bd = lhs.asNumber().subtract(rhs.asNumber());
                bd = bd.setScale(this.getPrecision(), 4).stripTrailingZeros();
                result = new Token(TokenType.NUMBER, bd.toPlainString(), token.getRow(), token.getColumn());
            } else if (op.equals((Object)Operator.MULT)) {
                this.assertBothNumbers(lhs, rhs);
                BigDecimal bd = lhs.asNumber().multiply(rhs.asNumber());
                bd = bd.setScale(this.getPrecision(), 4).stripTrailingZeros();
                result = new Token(TokenType.NUMBER, bd.toPlainString(), token.getRow(), token.getColumn());
            } else if (op.equals((Object)Operator.DIV)) {
                this.assertBothNumbers(lhs, rhs);
                int divisorScale = rhs.asNumber().scale();
                int scale = lhs.asNumber().equals(BigDecimal.ZERO) ? divisorScale : this.getPrecision();
                BigDecimal bd = lhs.asNumber().divide(rhs.asNumber(), scale, 4).stripTrailingZeros();
                result = new Token(TokenType.NUMBER, bd.toPlainString(), token.getRow(), token.getColumn());
            } else if (op.equals((Object)Operator.IDIV)) {
                this.assertBothNumbers(lhs, rhs);
                BigDecimal bd = lhs.asNumber().divideToIntegralValue(rhs.asNumber());
                result = new Token(TokenType.NUMBER, bd.toPlainString(), token.getRow(), token.getColumn());
            } else if (op.equals((Object)Operator.MODULUS)) {
                this.assertBothNumbers(lhs, rhs);
                BigDecimal bd = lhs.asNumber().remainder(rhs.asNumber());
                result = new Token(TokenType.NUMBER, bd.toPlainString(), token.getRow(), token.getColumn());
            } else if (op.equals((Object)Operator.EXP)) {
                this.assertBothNumbers(lhs, rhs);
                MathContext mc = rhs.asNumber().compareTo(BigDecimal.ZERO) < 0 ? MathContext.DECIMAL128 : MathContext.UNLIMITED;
                BigDecimal bd = lhs.asNumber().pow(rhs.asNumber().intValue(), mc);
                bd = bd.setScale(this.getPrecision(), 4).stripTrailingZeros();
                result = new Token(TokenType.NUMBER, bd.toPlainString(), token.getRow(), token.getColumn());
            } else if (op.equals((Object)Operator.ASSIGNMENT)) {
                if (lhs.isIdentifer()) {
                    if (rhs.getValue().getType().equals((Object)ValueType.UNDEFINED)) {
                        this.setStatusAndFail(rhs, "error.expected_initialized", rhs.getText());
                    }
                    String[] varName = lhs.getText().split("[\\[,\\]]");
                    Value val = this.variables.get(varName[0].toUpperCase());
                    if (varName.length > 1) {
                        val = val.getArray().get(Integer.valueOf(varName[1]));
                        if (varName.length > 2) {
                            val = val.getArray().get(Integer.valueOf(varName[2]));
                        }
                    }
                    val.set(rhs.getValue());
                } else {
                    this.setStatusAndFail(lhs, "error.expected_identifier", lhs.getText());
                }
            } else {
                result = this.processRelationalOperators(lhs, token, rhs);
            }
        }
        catch (ArithmeticException ex) {
            throw new ParserException(ex.getMessage(), (Throwable)ex, token.getRow(), token.getColumn());
        }
        return result;
    }

    private Token processRelationalOperators(Token lhs, Token operator, Token rhs) throws ParserException {
        boolean isTrue = false;
        Operator op = Operator.find(operator, this.caseSensitive);
        if (lhs.getValue().getType() == ValueType.BOOLEAN) {
            if (op.inSet(Operator.EQU, Operator.NEQ, Operator.AND, Operator.OR)) {
                isTrue = this.performComparison(lhs.getValue().asBoolean(), rhs.getValue().asBoolean(), op);
            } else {
                this.setStatusAndFail(operator, "error.invalid_operator_boolean", op.getText());
            }
        } else if (lhs.getValue().getType() == ValueType.NUMBER) {
            if (!op.inSet(Operator.AND, Operator.OR)) {
                isTrue = this.performComparison(lhs.getValue().asNumber(), rhs.getValue().asNumber(), op);
            } else {
                this.setStatusAndFail(rhs, "error.invalid_operator", op.getText());
            }
        } else if (lhs.getValue().getType() == ValueType.STRING) {
            if (!op.inSet(Operator.AND, Operator.OR)) {
                isTrue = this.performComparison((Comparable)((Object)lhs.getValue().asString()), (Comparable)((Object)rhs.getValue().asString()), op);
            } else {
                this.setStatusAndFail(rhs, "error.invalid_operator", op.getText());
            }
        } else if (lhs.getValue().getType() == ValueType.DATE) {
            if (!op.inSet(Operator.AND, Operator.OR)) {
                isTrue = this.performComparison(lhs.getValue().asDate(), rhs.getValue().asDate(), op);
            } else {
                this.setStatusAndFail(rhs, "error.invalid_operator", op.getText());
            }
        }
        return new Token(TokenType.VALUE, new Value("VALUE", isTrue ? Boolean.TRUE : Boolean.FALSE), rhs.getRow(), rhs.getColumn() + 1);
    }

    private boolean performComparison(Comparable o1, Comparable o2, Operator op) throws ParserException {
        boolean haveValues;
        boolean isTrue = false;
        boolean bl = haveValues = o1 != null && o2 != null;
        if (Operator.AND.equals((Object)op)) {
            isTrue = o1 instanceof Boolean && o2 instanceof Boolean && (Boolean)o1 != false && (Boolean)o2 != false;
        } else if (Operator.OR.equals((Object)op)) {
            isTrue = o1 instanceof Boolean && o2 instanceof Boolean && ((Boolean)o1 != false || (Boolean)o2 != false);
        } else if (Operator.LT.equals((Object)op)) {
            isTrue = haveValues && o1.compareTo(o2) < 0;
        } else if (Operator.LTE.equals((Object)op)) {
            isTrue = haveValues && o1.compareTo(o2) <= 0;
        } else if (Operator.EQU.equals((Object)op)) {
            isTrue = haveValues && o1.compareTo(o2) == 0;
        } else if (Operator.NEQ.equals((Object)op)) {
            isTrue = haveValues && o1.compareTo(o2) != 0;
        } else if (Operator.GTE.equals((Object)op)) {
            isTrue = haveValues && o1.compareTo(o2) >= 0;
        } else if (Operator.GT.equals((Object)op)) {
            isTrue = haveValues && o1.compareTo(o2) > 0;
        }
        return isTrue;
    }

    private Token processField(Token field, Stack<Token> stack) throws ParserException {
        return new Token(TokenType.VALUE, this.getField(field.getText()), field.getRow(), field.getColumn());
    }

    private Token processFunction(Token function, Stack<Token> stack) throws ParserException {
        Value value = null;
        String name = function.getText();
        int orgStackSize = stack.size();
        Function f = this.getFunction(name);
        if (f != null) {
            try {
                value = f.execute(function, stack);
            }
            catch (ParserException ex) {
                int toRemove = function.getArgc() - (orgStackSize - stack.size());
                for (int i = 0; i < toRemove; ++i) {
                    stack.pop();
                }
                if (!this.suppressParseExceptions) {
                    throw ex;
                }
                return new Token(TokenType.VALUE, new Value().setValue(ex), function.getRow(), function.getColumn());
            }
        } else {
            this.setStatusAndFail(function, "error.no_handler", name);
        }
        return new Token(TokenType.VALUE, value, function.getRow(), function.getColumn());
    }

    protected Value RPNtoValue(List<Token> tokens) throws ParserException {
        int tcount = 0;
        Token last_telse = null;
        Stack<Token> stack = new Stack<Token>();
        block4: for (Token token : tokens) {
            Value value;
            if (TokenType.NOTHROW.equals((Object)token.getType())) {
                this.suppressParseExceptions = true;
                continue;
            }
            if (token.isProperty()) {
                Object obj = this.getProperty(token.getText());
                value = new Value();
                if (obj instanceof Boolean) {
                    value.setValue((Boolean)obj);
                } else if (obj instanceof BigDecimal) {
                    value.setValue((BigDecimal)obj);
                } else if (obj instanceof Date) {
                    value.setValue((Date)obj);
                } else if (obj != null) {
                    value.setValue(obj.toString());
                }
                token.setValue(value);
                stack.push(token);
                continue;
            }
            if (token.isField()) {
                stack.push(this.processField(token, stack));
                continue;
            }
            if (token.isFunction()) {
                stack.push(this.processFunction(token, stack));
                continue;
            }
            if (token.isConstant()) {
                BigDecimal bd = this.getConstant(token.getText());
                token.getValue().setValue(bd);
                stack.push(token);
                continue;
            }
            if (token.isIdentifer()) {
                Value value2 = this.variables.get(token.getText().toUpperCase());
                if (value2 == null) {
                    value2 = new Value();
                    this.variables.put(token.getText().toUpperCase(), value2);
                }
                token.getValue().set(value2);
                stack.push(token);
                continue;
            }
            if (token.isOperator()) {
                Token result;
                Operator op = Operator.find(token, this.caseSensitive);
                if (Operator.UNARY_MINUS.equals((Object)op) || Operator.NOT.equals((Object)op)) {
                    value = stack.pop().getValue();
                    switch (value.getType()) {
                        case NUMBER: {
                            value.setValue(value.asNumber().negate());
                            stack.push(new Token(TokenType.NUMBER, value.asString(), token.getRow(), token.getColumn()));
                            continue block4;
                        }
                        case BOOLEAN: {
                            value.setValue(value.asBoolean() != false ? Boolean.FALSE : Boolean.TRUE);
                            stack.push(new Token(TokenType.VALUE, value, token.getRow(), token.getColumn()));
                            continue block4;
                        }
                    }
                    this.setStatusAndFail(token, "error.type_mismatch", value.getType().name());
                    continue;
                }
                if (op.equals((Object)Operator.TIF)) {
                    --tcount;
                } else {
                    if (op.equals((Object)Operator.TELSE)) {
                        ++tcount;
                        last_telse = token;
                        stack.push(token);
                        continue;
                    }
                    if (op.equals((Object)Operator.UNARY_PLUS)) continue;
                }
                if (tcount % 2 != 0) {
                    this.setStatusAndFail(token, "error.missing_telse", Operator.TIF.getText(), Operator.TELSE.getText());
                }
                if ((result = this.processOperators(token, stack)) == null) continue;
                stack.push(result);
                continue;
            }
            if (token.getText().equals(Operator.LBRACKET.getText())) {
                Token var;
                Token index = null;
                Token subIndex = null;
                if (stack.peek().getType().equals((Object)TokenType.NUMBER)) {
                    index = stack.pop();
                    if (stack.size() == 0) {
                        this.setStatusAndFail(index, "error.syntax", new Object[0]);
                    }
                    if (stack.peek().getType().equals((Object)TokenType.NUMBER)) {
                        subIndex = index;
                        index = stack.pop();
                        if (!stack.peek().getType().equals((Object)TokenType.IDENTIFIER)) {
                            this.setStatusAndFail(subIndex, "Only one or two dimensional arrays are supported", new Object[0]);
                        }
                    }
                }
                if (!ValueType.ARRAY.equals((Object)(var = stack.pop()).getValue().getType())) {
                    this.setStatusAndFail(var, "error.expected_array", new Object[]{var.getValue().getType()});
                }
                String strIdx = "";
                if (index != null) {
                    strIdx = subIndex == null ? index.asString() : index.asString() + "," + subIndex.asString();
                    strIdx = "[" + strIdx + "]";
                }
                String valName = var.getText() + strIdx;
                int idx = 0;
                Value val = null;
                if (index != null) {
                    int len;
                    List<Value> array = var.getValue().getArray();
                    int n = len = array == null ? 0 : array.size() - 1;
                    if (len >= 0 || !this.suppressParseExceptions) {
                        idx = index.getValue().asNumber().intValue();
                        if (idx < 0 || idx > len) {
                            this.setStatusAndFail(index, "error.index_out_of_range", String.valueOf(idx), String.valueOf(len));
                        }
                        val = new Value();
                        val.set(var.getValue().getArray().get(idx));
                        val.setName(valName);
                        if (subIndex != null) {
                            if (!ValueType.ARRAY.equals((Object)val.getType())) {
                                this.setStatusAndFail(var, "error.expected_array", new Object[]{val.getType()});
                            }
                            len = (array = val.getArray()) == null ? 0 : array.size() - 1;
                            idx = subIndex.getValue().asNumber().intValue();
                            if (idx < 0 || idx > len) {
                                this.setStatusAndFail(subIndex, "error.index_out_of_range", String.valueOf(idx), String.valueOf(len));
                            }
                            val = val.getArray().get(idx);
                        }
                    }
                }
                if (val == null) {
                    int len = var.getValue().getArray().size();
                    val = len > 0 ? var.getValue().getArray().get(0) : var.getValue();
                }
                stack.push(new Token(TokenType.IDENTIFIER, valName, val, var.getRow(), var.getColumn()));
                continue;
            }
            stack.push(token);
        }
        if (tcount != 0) {
            this.setStatusAndFail(last_telse, "error.missing_tif", Operator.TELSE.getText(), Operator.TIF.getText());
        }
        if (stack.size() > 1) {
            this.setStatusAndFail((Token)stack.get(0), "error.syntax", new Object[0]);
        }
        return stack.size() == 0 ? new Value("empty result", Boolean.TRUE) : ((Token)stack.pop()).getValue();
    }

    public Token[] popArguments(Token function, Stack<Token> stack) {
        Token[] args = null;
        if (function.getArgc() > 0 && stack.size() > 0) {
            args = new Token[function.getArgc()];
            for (int i = function.getArgc() - 1; i >= 0; --i) {
                args[i] = stack.pop();
            }
        } else {
            args = new Token[]{};
        }
        return args;
    }

    public Value _CLEARGLOBAL(Token function, Stack<Token> stack) throws ParserException {
        boolean haveParameters;
        boolean bl = haveParameters = this.listOfNullParameters(stack) == null;
        if (haveParameters) {
            this.clearGlobalVariable(stack.pop().asString());
        }
        return new Value(function.getText()).setValue(haveParameters ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _CLEARGLOBALS(Token function, Stack<Token> stack) throws ParserException {
        this.clearGlobalVariables();
        return new Value(function.getText()).setValue(Boolean.TRUE);
    }

    public Value _DIM(Token function, Stack<Token> stack) throws ParserException {
        int numRows;
        Token[] args;
        String nullParams = this.listOfNullParameters(stack, function.getArgc() - 1);
        if (nullParams != null) {
            this.setStatusAndFail(function, "error.null_parameters", nullParams);
        }
        if (!TokenType.IDENTIFIER.equals((Object)(args = this.popArguments(function, stack))[0].getType())) {
            this.setStatusAndFail(args[0], "error.expected_identifier", args[0].getType().name());
        }
        if ((numRows = args[1].asNumber().intValue()) < 1 || numRows > MAX_DIM_ROWS) {
            this.setStatusAndFail(args[1], "error.function_value_out_of_range", "DIM", "numRows", "1", "10000", String.valueOf(numRows));
        }
        int numCols = 0;
        if (args.length > 2 && ((numCols = args[2].asNumber().intValue()) < 1 || numCols > MAX_DIM_COLS)) {
            this.setStatusAndFail(args[2], "error.function_value_out_of_range", "DIM", "numCols", "1", "256", String.valueOf(numCols));
        }
        Value value = new Value("ARRAY", (Object)ValueType.ARRAY);
        for (int i = 0; i < numRows; ++i) {
            Value newRow = new Value();
            value.addValueToArray(newRow);
            for (int j = 0; j < numCols; ++j) {
                newRow.addValueToArray(new Value());
            }
        }
        args[0].setValue(value);
        this.variables.put(args[0].getText().toUpperCase(), args[0].getValue());
        return value;
    }

    public Value _GETGLOBAL(Token function, Stack<Token> stack) throws ParserException {
        String name = stack.pop().asString();
        Value value = new Value(function.getText());
        value.set(this.globals.get(name == null ? "~nofind~" : name));
        return value;
    }

    public Value _SETGLOBAL(Token function, Stack<Token> stack) throws ParserException {
        boolean haveValues;
        Value value = stack.pop().getValue();
        String name = stack.pop().asString();
        boolean bl = haveValues = value.asString() != null && name != null;
        if (haveValues) {
            this.addGlobalVariable(name, value);
        }
        return new Value(function.getText()).setValue(haveValues ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _NOW(Token function, Stack<Token> stack) throws ParserException {
        String nullParams = this.listOfNullParameters(stack, function.getArgc());
        if (nullParams != null) {
            this.setStatusAndFail(function, "error.null_parameters", nullParams);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(this.getTimeZone());
        if (function.getArgc() > 0) {
            Token token = stack.pop();
            int mode = token.asNumber().intValue();
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    break;
                }
                case 2: {
                    calendar.set(11, 23);
                    calendar.set(12, 59);
                    calendar.set(13, 59);
                    calendar.set(14, 0);
                    break;
                }
                default: {
                    String msg = ParserException.formatMessage("error.function_value_out_of_range", function.getText(), "1", "0", "2", String.valueOf(mode));
                    throw new ParserException(msg, token.getRow(), token.getColumn() - 1);
                }
            }
        }
        return new Value(function.getText()).setValue(new Date(calendar.getTimeInMillis()));
    }

    public Value _PRECISION(Token function, Stack<Token> stack) throws ParserException {
        String nullParams = this.listOfNullParameters(stack, function.getArgc());
        if (nullParams != null) {
            this.setStatusAndFail(function, "error.null_parameters", nullParams);
        }
        Value value = new Value(function.getText()).setValue(BigDecimal.valueOf(this.precision));
        Token token = stack.pop();
        int decimals = token.asNumber().intValue();
        if (decimals < 0 || decimals > 100) {
            String msg = ParserException.formatMessage("error.function_value_out_of_range", function.getText(), "1", "0", "100", String.valueOf(decimals));
            throw new ParserException(msg, token.getRow(), token.getColumn() - 1);
        }
        this.precision = decimals;
        return value;
    }

    public class ArgCount {
        public boolean haveArgs;
        public int count;
    }
}

