/*
 * Decompiled with CFR 0.152.
 */
package com.createsend;

import com.createsend.CreateSendBase;
import com.createsend.models.PagedResult;
import com.createsend.models.segments.RuleGroup;
import com.createsend.models.segments.Segment;
import com.createsend.models.subscribers.Subscriber;
import com.createsend.util.AuthenticationDetails;
import com.createsend.util.ErrorDeserialiser;
import com.createsend.util.JerseyClientImpl;
import com.createsend.util.exceptions.CreateSendException;
import com.createsend.util.jersey.JsonProvider;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;

public class Segments
extends CreateSendBase {
    private String segmentID;

    public Segments(AuthenticationDetails auth) {
        this(auth, null);
    }

    public Segments(AuthenticationDetails auth, String segmentID) {
        this.setSegmentID(segmentID);
        this.jerseyClient = new JerseyClientImpl(auth);
    }

    public void setSegmentID(String segmentID) {
        this.segmentID = segmentID;
    }

    public String getSegmentID() {
        return this.segmentID;
    }

    public String create(String listID, Segment segment) throws CreateSendException {
        this.segmentID = this.jerseyClient.post(String.class, (Object)segment, new ErrorDeserialiser(), "segments", listID + ".json");
        return this.segmentID;
    }

    public void update(Segment segment) throws CreateSendException {
        this.jerseyClient.put((Object)segment, new ErrorDeserialiser(), "segments", this.segmentID + ".json");
    }

    public void addRuleGroup(RuleGroup ruleGroup) throws CreateSendException {
        this.jerseyClient.post(String.class, (Object)ruleGroup, new ErrorDeserialiser(), "segments", this.segmentID, "rules.json");
    }

    public Segment details() throws CreateSendException {
        return this.jerseyClient.get(Segment.class, "segments", this.segmentID + ".json");
    }

    public PagedResult<Subscriber> active() throws CreateSendException {
        return this.active(1, (Integer)1000, "email", "asc", false);
    }

    public PagedResult<Subscriber> active(boolean includeTrackingPreference) throws CreateSendException {
        return this.active(1, (Integer)1000, "email", "asc", includeTrackingPreference);
    }

    public PagedResult<Subscriber> active(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.active("", page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> active(Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.active("", page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    public PagedResult<Subscriber> active(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.active(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> active(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.active(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    private PagedResult<Subscriber> active(String subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)subscribedFrom);
        queryString.add((Object)"includetrackingpreference", (Object)String.valueOf(includeTrackingPreference));
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "segments", this.segmentID, "active.json");
    }

    public void delete() throws CreateSendException {
        this.jerseyClient.delete("segments", this.segmentID + ".json");
    }

    public void deleteRules() throws CreateSendException {
        this.jerseyClient.delete("segments", this.segmentID, "rules.json");
    }
}

