/*
 * Decompiled with CFR 0.152.
 */
package com.createsend;

import com.createsend.CreateSendBase;
import com.createsend.models.transactional.response.Message;
import com.createsend.models.transactional.response.MessageLogItem;
import com.createsend.models.transactional.response.MessageSent;
import com.createsend.models.transactional.response.TransactionalStatistics;
import com.createsend.util.AuthenticationDetails;
import com.createsend.util.JerseyClientImpl;
import com.createsend.util.exceptions.CreateSendException;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.ws.rs.core.MultivaluedMap;

public class Messages
extends CreateSendBase {
    public Messages(AuthenticationDetails auth) {
        this.jerseyClient = new JerseyClientImpl(auth);
    }

    public Message get(UUID messageID) throws CreateSendException {
        return this.get(messageID, false);
    }

    public Message get(UUID messageID, boolean includeStatistics) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"statistics", (Object)String.valueOf(includeStatistics));
        return this.jerseyClient.get(Message.class, (MultivaluedMap<String, String>)queryString, "transactional", "messages", messageID.toString());
    }

    public TransactionalStatistics statistics(String clientID, UUID smartEmailID, String group, Date from, Date to, String timezone) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        if (clientID != null) {
            queryString.add((Object)"clientID", (Object)clientID);
        }
        if (smartEmailID != null) {
            queryString.add((Object)"smartEmailID", (Object)smartEmailID.toString());
        }
        if (group != null) {
            queryString.add((Object)"group", (Object)group);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (from != null) {
            String fromStr = dateFormat.format(from);
            queryString.add((Object)"from", (Object)fromStr);
        }
        if (to != null) {
            String toStr = dateFormat.format(to);
            queryString.add((Object)"to", (Object)toStr);
        }
        if (timezone != null) {
            queryString.add((Object)"timezone", (Object)timezone);
        }
        return this.jerseyClient.get(TransactionalStatistics.class, (MultivaluedMap<String, String>)queryString, "transactional", "statistics");
    }

    public MessageSent resend(UUID messageID) throws CreateSendException {
        return this.jerseyClient.post(MessageSent.class, null, new String[]{"transactional", "messages", messageID.toString(), "resend"});
    }

    public MessageLogItem[] timeline(String clientID, UUID sentBeforeID, UUID sentAfterID, Integer count, String status, UUID smartEmailID, String group) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        if (clientID != null) {
            queryString.add((Object)"clientID", (Object)clientID);
        }
        if (sentBeforeID != null) {
            queryString.add((Object)"sentBeforeID", (Object)sentBeforeID.toString());
        }
        if (sentAfterID != null) {
            queryString.add((Object)"sentAfterID", (Object)sentAfterID.toString());
        }
        if (count != null) {
            queryString.add((Object)"count", (Object)count.toString());
        }
        if (status != null) {
            queryString.add((Object)"status", (Object)status);
        }
        if (smartEmailID != null) {
            queryString.add((Object)"smartEmailID", (Object)smartEmailID.toString());
        }
        if (group != null) {
            queryString.add((Object)"group", (Object)group);
        }
        return this.jerseyClient.get(MessageLogItem[].class, (MultivaluedMap<String, String>)queryString, "transactional", "messages");
    }
}

