/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.auth;

import com.coze.openapi.client.auth.model.SessionContext;
import java.util.Date;
import lombok.NonNull;

public class JWTPayload {
    @NonNull
    private String iss;
    @NonNull
    private String aud;
    @NonNull
    private Date iat;
    @NonNull
    private Date exp;
    @NonNull
    private String jti;
    private String sessionName;
    private SessionContext sessionContext;

    public static JWTPayloadBuilder builder() {
        return new JWTPayloadBuilder();
    }

    @NonNull
    public String getIss() {
        return this.iss;
    }

    @NonNull
    public String getAud() {
        return this.aud;
    }

    @NonNull
    public Date getIat() {
        return this.iat;
    }

    @NonNull
    public Date getExp() {
        return this.exp;
    }

    @NonNull
    public String getJti() {
        return this.jti;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public void setIss(@NonNull String iss) {
        if (iss == null) {
            throw new NullPointerException("iss is marked non-null but is null");
        }
        this.iss = iss;
    }

    public void setAud(@NonNull String aud) {
        if (aud == null) {
            throw new NullPointerException("aud is marked non-null but is null");
        }
        this.aud = aud;
    }

    public void setIat(@NonNull Date iat) {
        if (iat == null) {
            throw new NullPointerException("iat is marked non-null but is null");
        }
        this.iat = iat;
    }

    public void setExp(@NonNull Date exp) {
        if (exp == null) {
            throw new NullPointerException("exp is marked non-null but is null");
        }
        this.exp = exp;
    }

    public void setJti(@NonNull String jti) {
        if (jti == null) {
            throw new NullPointerException("jti is marked non-null but is null");
        }
        this.jti = jti;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JWTPayload)) {
            return false;
        }
        JWTPayload other = (JWTPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$iss = this.getIss();
        String other$iss = other.getIss();
        if (this$iss == null ? other$iss != null : !this$iss.equals(other$iss)) {
            return false;
        }
        String this$aud = this.getAud();
        String other$aud = other.getAud();
        if (this$aud == null ? other$aud != null : !this$aud.equals(other$aud)) {
            return false;
        }
        Date this$iat = this.getIat();
        Date other$iat = other.getIat();
        if (this$iat == null ? other$iat != null : !((Object)this$iat).equals(other$iat)) {
            return false;
        }
        Date this$exp = this.getExp();
        Date other$exp = other.getExp();
        if (this$exp == null ? other$exp != null : !((Object)this$exp).equals(other$exp)) {
            return false;
        }
        String this$jti = this.getJti();
        String other$jti = other.getJti();
        if (this$jti == null ? other$jti != null : !this$jti.equals(other$jti)) {
            return false;
        }
        String this$sessionName = this.getSessionName();
        String other$sessionName = other.getSessionName();
        if (this$sessionName == null ? other$sessionName != null : !this$sessionName.equals(other$sessionName)) {
            return false;
        }
        SessionContext this$sessionContext = this.getSessionContext();
        SessionContext other$sessionContext = other.getSessionContext();
        return !(this$sessionContext == null ? other$sessionContext != null : !((Object)this$sessionContext).equals(other$sessionContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JWTPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $iss = this.getIss();
        result = result * 59 + ($iss == null ? 43 : $iss.hashCode());
        String $aud = this.getAud();
        result = result * 59 + ($aud == null ? 43 : $aud.hashCode());
        Date $iat = this.getIat();
        result = result * 59 + ($iat == null ? 43 : ((Object)$iat).hashCode());
        Date $exp = this.getExp();
        result = result * 59 + ($exp == null ? 43 : ((Object)$exp).hashCode());
        String $jti = this.getJti();
        result = result * 59 + ($jti == null ? 43 : $jti.hashCode());
        String $sessionName = this.getSessionName();
        result = result * 59 + ($sessionName == null ? 43 : $sessionName.hashCode());
        SessionContext $sessionContext = this.getSessionContext();
        result = result * 59 + ($sessionContext == null ? 43 : ((Object)$sessionContext).hashCode());
        return result;
    }

    public String toString() {
        return "JWTPayload(iss=" + this.getIss() + ", aud=" + this.getAud() + ", iat=" + this.getIat() + ", exp=" + this.getExp() + ", jti=" + this.getJti() + ", sessionName=" + this.getSessionName() + ", sessionContext=" + this.getSessionContext() + ")";
    }

    public JWTPayload(@NonNull String iss, @NonNull String aud, @NonNull Date iat, @NonNull Date exp, @NonNull String jti, String sessionName, SessionContext sessionContext) {
        if (iss == null) {
            throw new NullPointerException("iss is marked non-null but is null");
        }
        if (aud == null) {
            throw new NullPointerException("aud is marked non-null but is null");
        }
        if (iat == null) {
            throw new NullPointerException("iat is marked non-null but is null");
        }
        if (exp == null) {
            throw new NullPointerException("exp is marked non-null but is null");
        }
        if (jti == null) {
            throw new NullPointerException("jti is marked non-null but is null");
        }
        this.iss = iss;
        this.aud = aud;
        this.iat = iat;
        this.exp = exp;
        this.jti = jti;
        this.sessionName = sessionName;
        this.sessionContext = sessionContext;
    }

    public JWTPayload() {
    }

    public static class JWTPayloadBuilder {
        private String iss;
        private String aud;
        private Date iat;
        private Date exp;
        private String jti;
        private String sessionName;
        private SessionContext sessionContext;

        JWTPayloadBuilder() {
        }

        public JWTPayloadBuilder iss(@NonNull String iss) {
            if (iss == null) {
                throw new NullPointerException("iss is marked non-null but is null");
            }
            this.iss = iss;
            return this;
        }

        public JWTPayloadBuilder aud(@NonNull String aud) {
            if (aud == null) {
                throw new NullPointerException("aud is marked non-null but is null");
            }
            this.aud = aud;
            return this;
        }

        public JWTPayloadBuilder iat(@NonNull Date iat) {
            if (iat == null) {
                throw new NullPointerException("iat is marked non-null but is null");
            }
            this.iat = iat;
            return this;
        }

        public JWTPayloadBuilder exp(@NonNull Date exp) {
            if (exp == null) {
                throw new NullPointerException("exp is marked non-null but is null");
            }
            this.exp = exp;
            return this;
        }

        public JWTPayloadBuilder jti(@NonNull String jti) {
            if (jti == null) {
                throw new NullPointerException("jti is marked non-null but is null");
            }
            this.jti = jti;
            return this;
        }

        public JWTPayloadBuilder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public JWTPayloadBuilder sessionContext(SessionContext sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public JWTPayload build() {
            return new JWTPayload(this.iss, this.aud, this.iat, this.exp, this.jti, this.sessionName, this.sessionContext);
        }

        public String toString() {
            return "JWTPayload.JWTPayloadBuilder(iss=" + this.iss + ", aud=" + this.aud + ", iat=" + this.iat + ", exp=" + this.exp + ", jti=" + this.jti + ", sessionName=" + this.sessionName + ", sessionContext=" + this.sessionContext + ")";
        }
    }
}

