/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.conversation;

import com.coze.openapi.api.ConversationAPI;
import com.coze.openapi.api.ConversationMessageAPI;
import com.coze.openapi.client.common.BaseResp;
import com.coze.openapi.client.common.BaseResponse;
import com.coze.openapi.client.common.pagination.PageFetcher;
import com.coze.openapi.client.common.pagination.PageNumBasedPaginator;
import com.coze.openapi.client.common.pagination.PageRequest;
import com.coze.openapi.client.common.pagination.PageResp;
import com.coze.openapi.client.common.pagination.PageResponse;
import com.coze.openapi.client.connversations.ClearConversationReq;
import com.coze.openapi.client.connversations.ClearConversationResp;
import com.coze.openapi.client.connversations.CreateConversationReq;
import com.coze.openapi.client.connversations.CreateConversationResp;
import com.coze.openapi.client.connversations.ListConversationReq;
import com.coze.openapi.client.connversations.ListConversationResp;
import com.coze.openapi.client.connversations.RetrieveConversationReq;
import com.coze.openapi.client.connversations.RetrieveConversationResp;
import com.coze.openapi.client.connversations.model.Conversation;
import com.coze.openapi.service.service.conversation.MessageService;
import com.coze.openapi.service.utils.Utils;
import org.jetbrains.annotations.NotNull;

public class ConversationService {
    private final ConversationAPI api;
    private final MessageService messageApi;

    public ConversationService(ConversationAPI api, ConversationMessageAPI messageApi) {
        this.api = api;
        this.messageApi = new MessageService(messageApi);
    }

    public RetrieveConversationResp retrieve(RetrieveConversationReq req) {
        BaseResponse<Conversation> resp = Utils.execute(this.api.retrieve(req.getConversationID(), req));
        return ((RetrieveConversationResp.RetrieveConversationRespBuilder)((BaseResp.BaseRespBuilder)RetrieveConversationResp.builder().conversation(resp.getData())).logID(resp.getLogID())).build();
    }

    public CreateConversationResp create(CreateConversationReq req) {
        BaseResponse<Conversation> resp = Utils.execute(this.api.create(req, req));
        return ((CreateConversationResp.CreateConversationRespBuilder)((BaseResp.BaseRespBuilder)CreateConversationResp.builder().conversation(resp.getData())).logID(resp.getLogID())).build();
    }

    public ClearConversationResp clear(ClearConversationReq req) {
        return Utils.execute(this.api.clear(req.getConversationID(), req)).getData();
    }

    public PageResp<Conversation> list(@NotNull ListConversationReq req) {
        if (req == null || req.getBotID() == null) {
            throw new IllegalArgumentException("botID is required");
        }
        Integer pageNum = req.getPageNum();
        Integer pageSize = req.getPageSize();
        String botID = req.getBotID();
        PageFetcher pageFetcher = request -> {
            ListConversationResp resp = Utils.execute(this.api.list(botID, request.getPageNum(), request.getPageSize(), req)).getData();
            return PageResponse.builder().hasMore(resp.isHasMore()).data(resp.getConversations()).pageNum(request.getPageNum()).pageSize(request.getPageSize()).logID(resp.getLogID()).build();
        };
        PageNumBasedPaginator paginator = new PageNumBasedPaginator(pageFetcher, pageSize);
        PageRequest initialRequest = PageRequest.builder().pageNum(pageNum).pageSize(pageSize).build();
        PageResponse firstPage = pageFetcher.fetch(initialRequest);
        return PageResp.builder().items(firstPage.getData()).iterator(paginator).logID(firstPage.getLogID()).hasMore(firstPage.isHasMore()).build();
    }

    public MessageService messages() {
        return this.messageApi;
    }
}

