/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;

public final class StateMachine<T extends Enum<T>> {
    private static final LogDomain TAG = LogDomain.DATABASE;
    @Nullable
    private final T errorState;
    @NonNull
    private final EnumMap<T, EnumSet<T>> transitions;
    @NonNull
    private T state;

    private StateMachine(@NonNull T initialState, @Nullable T errorState, @NonNull EnumMap<T, EnumSet<T>> transitions) {
        this.state = initialState;
        this.errorState = errorState;
        this.transitions = transitions;
    }

    @NonNull
    public String toString() {
        return ClassUtils.objId(this);
    }

    @SafeVarargs
    public final boolean assertState(T ... expected) {
        Preconditions.assertPositive(expected.length, "expected states length");
        for (T s : expected) {
            if (s != this.state) continue;
            return true;
        }
        if (this.state != this.errorState) {
            Log.d(TAG, "StateMachine%s: unexpected state %s %s", new Exception(), this, this.state, Arrays.toString(expected));
        }
        return false;
    }

    public boolean setState(@NonNull T nextState) {
        EnumSet<T> legalStates = this.transitions.get(this.state);
        if (nextState == this.errorState || legalStates != null && legalStates.contains(nextState)) {
            Log.d(TAG, "StateMachine%s: transition %s => %s", this, this.state, nextState);
            this.state = nextState;
            return true;
        }
        if (this.state != this.errorState) {
            Log.d(TAG, "StateMachine%s: no transition: %s => %s %s", new Exception(), this, this.state, nextState, legalStates);
        }
        return false;
    }

    /* synthetic */ StateMachine(Enum x0, Enum x1, EnumMap x2, 1 x3) {
        this(x0, x1, x2);
    }

    public static class Builder<S extends Enum<S>> {
        @NonNull
        private final S initialState;
        @Nullable
        private final S errorState;
        @NonNull
        private final EnumMap<S, EnumSet<S>> transitions;

        public Builder(@NonNull Class<S> klass, @NonNull S initialState, @Nullable S errorState) {
            this.transitions = new EnumMap(klass);
            this.initialState = initialState;
            this.errorState = errorState;
        }

        @SafeVarargs
        @NonNull
        public final Builder<S> addTransition(@NonNull S source, @NonNull S target1, S ... targets) {
            if (source == this.errorState) {
                throw new IllegalArgumentException("transitions from the error state are illegal");
            }
            this.transitions.put(source, EnumSet.of(target1, targets));
            return this;
        }

        @NonNull
        public StateMachine<S> build() {
            return new StateMachine((Enum)this.initialState, (Enum)this.errorState, this.transitions, null);
        }
    }
}

